/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.texts;

import gplx.Bry_;
import gplx.String_;

public class Base64Converter {
    private static final char[] ALPHABET = String_.XtoCharAry("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
    private static int[] toInt = null;

    static void Init() {
        toInt = new int[128];
        for (int i = 0; i < ALPHABET.length; ++i) {
            Base64Converter.toInt[Base64Converter.ALPHABET[i]] = i;
        }
    }

    public static String EncodeString(String string) {
        return Base64Converter.Encode(Bry_.new_u8(string));
    }

    public static String Encode(byte[] byArray) {
        if (toInt == null) {
            Base64Converter.Init();
        }
        int n = byArray.length;
        char[] cArray = new char[(n + 2) / 3 * 4];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            byte by = byArray[n3++];
            byte by2 = n3 < n ? byArray[n3++] : (byte)0;
            byte by3 = n3 < n ? byArray[n3++] : (byte)0;
            int n4 = 63;
            cArray[n2++] = ALPHABET[by >> 2 & n4];
            cArray[n2++] = ALPHABET[(by << 4 | (by2 & 0xFF) >> 4) & n4];
            cArray[n2++] = ALPHABET[(by2 << 2 | (by3 & 0xFF) >> 6) & n4];
            cArray[n2++] = ALPHABET[by3 & n4];
        }
        switch (n % 3) {
            case 1: {
                cArray[--n2] = 61;
                cArray[--n2] = 61;
                break;
            }
            case 2: {
                cArray[--n2] = 61;
            }
        }
        return new String(cArray);
    }

    public static String DecodeString(String string) {
        return String_.new_u8(Base64Converter.Decode(string));
    }

    public static byte[] Decode(String string) {
        if (toInt == null) {
            Base64Converter.Init();
        }
        int n = String_.Len(string);
        int n2 = String_.Has_at_end(string, "==") ? 2 : (String_.Has_at_end(string, "=") ? 1 : 0);
        byte[] byArray = new byte[n * 3 / 4 - n2];
        int n3 = 255;
        int n4 = 0;
        for (int i = 0; i < n; i += 4) {
            int n5 = toInt[String_.CharAt(string, i)];
            int n6 = toInt[String_.CharAt(string, i + 1)];
            byArray[n4++] = (byte)((n5 << 2 | n6 >> 4) & n3);
            if (n4 >= byArray.length) {
                return byArray;
            }
            int n7 = toInt[String_.CharAt(string, i + 2)];
            byArray[n4++] = (byte)((n6 << 4 | n7 >> 2) & n3);
            if (n4 >= byArray.length) {
                return byArray;
            }
            int n8 = toInt[String_.CharAt(string, i + 3)];
            byArray[n4++] = (byte)((n7 << 6 | n8) & n3);
        }
        return byArray;
    }
}

