/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.security.files;

import gplx.Bry_;
import gplx.Bry_find_;
import gplx.Bry_split_;
import gplx.Err_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.String_;
import gplx.core.envs.Op_sys;
import gplx.core.security.files.Cksum_itm;

public class Cksum_list {
    public final byte Type;
    public final Cksum_itm[] Itms;
    public long Itms_size;

    public Cksum_list(byte by, Cksum_itm[] cksum_itmArray, long l) {
        this.Type = by;
        this.Itms = cksum_itmArray;
        this.Itms_size = l;
    }

    public Io_url[] Itms_ary() {
        int n = this.Itms.length;
        Io_url[] io_urlArray = new Io_url[n];
        for (int i = 0; i < n; ++i) {
            io_urlArray[i] = this.Itms[i].File_url;
        }
        return io_urlArray;
    }

    public static Cksum_list Parse_by_fil(Io_url io_url) {
        byte by = Cksum_list.Get_hash_tid_by_ext(io_url.Ext());
        return Cksum_list.Parse(by, io_url.OwnerDir(), Io_mgr.Instance.LoadFilBry(io_url));
    }

    public static Cksum_list Parse(byte by, Io_url io_url, byte[] byArray) {
        List_adp list_adp = List_adp_.New();
        byte[][] byArray2 = Bry_split_.Split_lines(byArray);
        int n = byArray2.length;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            byte[] byArray3 = byArray2[i];
            int n2 = Bry_find_.Find_fwd(byArray3, (byte)32);
            if (n2 == -1) {
                throw Err_.new_("chsum", "checksum line does not have space", "line", byArray3);
            }
            byte[] byArray4 = Bry_.Mid(byArray3, 0, n2);
            int n3 = n2 + 1;
            if (byArray3[n3] == 42) {
                ++n3;
            }
            byte[] byArray5 = Bry_.Mid(byArray3, n3);
            Io_url io_url2 = Cksum_list.GenSubFil_nest(io_url, byArray5);
            long l2 = Io_mgr.Instance.QueryFil(io_url2).Size();
            l += l2;
            Cksum_itm cksum_itm = new Cksum_itm(byArray4, io_url2, l2);
            list_adp.Add(cksum_itm);
        }
        return new Cksum_list(by, (Cksum_itm[])list_adp.To_ary_and_clear(Cksum_itm.class), l);
    }

    private static Io_url GenSubFil_nest(Io_url io_url, byte[] byArray) {
        byte by = Op_sys.Lnx.Fsys_dir_spr_byte();
        int n = Bry_find_.Find_fwd(byArray, by);
        if (n == -1 && (n = Bry_find_.Find_fwd(byArray, by = Op_sys.Wnt.Fsys_dir_spr_byte())) == -1) {
            return io_url.GenSubFil(String_.new_u8(byArray));
        }
        byte[][] byArray2 = Bry_split_.Split(byArray, by);
        return io_url.GenSubFil_nest(String_.Ary(byArray2));
    }

    private static byte Get_hash_tid_by_ext(String string) {
        if (String_.Eq(string, ".md5")) {
            return 0;
        }
        if (String_.Eq(string, ".sha1")) {
            return 1;
        }
        if (String_.Eq(string, ".sha256")) {
            return 2;
        }
        throw Err_.new_unhandled_default(string);
    }
}

