/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.security.algos.jacksum;

import gplx.Err_;
import gplx.core.encoders.Hex_utl_;
import gplx.core.security.algos.Hash_algo;
import java.security.NoSuchAlgorithmException;
import jonelo.jacksum.JacksumAPI;
import jonelo.jacksum.algorithm.AbstractChecksum;

public class Jacksum_algo
implements Hash_algo {
    private final AbstractChecksum checksum;
    private final String key;

    public Jacksum_algo(String string) {
        this.key = string;
        try {
            this.checksum = JacksumAPI.getChecksumInstance((String)string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw Err_.new_wo_type("jacksum algo doesn't exist: key=" + string, new Object[0]);
        }
    }

    @Override
    public String Key() {
        return this.key;
    }

    @Override
    public Hash_algo Clone_hash_algo() {
        return new Jacksum_algo(this.key);
    }

    @Override
    public void Update_digest(byte[] byArray, int n, int n2) {
        this.checksum.update(byArray, n, n2 - n);
    }

    @Override
    public byte[] To_hash_bry() {
        byte[] byArray = this.checksum.getByteArray();
        return Hex_utl_.Encode_bry(byArray);
    }
}

