/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.security.algos.gnu_crypto;

import gnu.crypto.hash.Haval;
import gplx.Err_;
import gplx.Int_;
import gplx.String_;
import gplx.core.security.algos.Hash_algo;
import gplx.core.security.algos.Hash_algo_factory;
import gplx.core.security.algos.gnu_crypto.Gnu_haval_algo;

public class Gnu_haval_factory
implements Hash_algo_factory {
    public static String Key__haval128_3 = "haval128,3";
    public static String Key__haval160_3 = "haval160,3";
    public static String Key__haval192_3 = "haval192,3";
    public static String Key__haval224_3 = "haval224,3";
    public static String Key__haval256_3 = "haval256,3";
    public static String Key__haval128_4 = "haval128,4";
    public static String Key__haval160_4 = "haval160,4";
    public static String Key__haval192_4 = "haval192,4";
    public static String Key__haval224_4 = "haval224,4";
    public static String Key__haval256_4 = "haval256,4";
    public static String Key__haval128_5 = "haval128,5";
    public static String Key__haval160_5 = "haval160,5";
    public static String Key__haval192_5 = "haval192,5";
    public static String Key__haval224_5 = "haval224,5";
    public static String Key__haval256_5 = "haval256,5";
    public static final Gnu_haval_factory Instance = new Gnu_haval_factory();

    @Override
    public Hash_algo New_hash_algo(String string) {
        return new Gnu_haval_algo(this, string);
    }

    public Haval New_Haval(String string) {
        int n = Int_.Parse_or(String_.Mid(string, 5, 8), -1);
        switch (n) {
            case 128: {
                n = 16;
                break;
            }
            case 160: {
                n = 20;
                break;
            }
            case 192: {
                n = 24;
                break;
            }
            case 224: {
                n = 28;
                break;
            }
            case 256: {
                n = 32;
                break;
            }
            default: {
                throw Err_.new_unhandled_default(n);
            }
        }
        int n2 = Int_.Parse_or(String_.Mid(string, 9, 10), -1);
        switch (n2) {
            case 3: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 5: {
                n2 = 5;
                break;
            }
            default: {
                throw Err_.new_unhandled_default(n2);
            }
        }
        return new Haval(n, n2);
    }

    Gnu_haval_factory() {
    }
}

