/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.security.algos.bouncy_castle;

import gplx.Err_;
import gplx.core.encoders.Hex_utl_;
import gplx.core.security.algos.Hash_algo;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Bouncy_castle_algo
implements Hash_algo {
    private static boolean Provider_needs_init = true;
    private final MessageDigest md;
    private final String key;

    public Bouncy_castle_algo(String string) {
        if (Provider_needs_init) {
            Provider_needs_init = false;
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try {
            this.key = string;
            this.md = MessageDigest.getInstance(string);
        }
        catch (Exception exception) {
            throw Err_.new_wo_type("unknown messageDigest; key=" + string, new Object[0]);
        }
    }

    @Override
    public String Key() {
        return this.key;
    }

    @Override
    public Hash_algo Clone_hash_algo() {
        return new Bouncy_castle_algo(this.key);
    }

    @Override
    public void Update_digest(byte[] byArray, int n, int n2) {
        this.md.update(byArray, n, n2 - n);
    }

    @Override
    public byte[] To_hash_bry() {
        byte[] byArray = this.md.digest();
        return Hex_utl_.Encode_bry(byArray);
    }
}

