/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.net.downloads;

import gplx.Err_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Long_;
import gplx.core.net.downloads.Http_download_wkr;
import gplx.core.net.downloads.Http_download_wkr__base;
import gplx.core.progs.Gfo_prog_ui;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class Http_download_wkr__jre
extends Http_download_wkr__base {
    public static final String Err__server_connection_failed = "server connection failed";
    public static final String Err__server_download_failed = "server download failed";

    @Override
    public Http_download_wkr Make_new() {
        return new Http_download_wkr__jre();
    }

    @Override
    public byte Exec_hook(Gfo_prog_ui gfo_prog_ui, String string, Io_url io_url, long l) {
        long l2 = l;
        boolean bl = l2 > 0L;
        Io_mgr.Instance.CreateDirIfAbsent(io_url.OwnerDir());
        if (bl) {
            Io_mgr.Instance.Truncate_fil(io_url, l);
        }
        File file = new File(io_url.Xto_api());
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file.getPath(), bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw Err_.new_wo_type("write failed; permission error?", "trg", io_url, "err", fileNotFoundException.toString());
        }
        InputStream inputStream = null;
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw Err_.new_wo_type("bad url", "src", string, "err" + malformedURLException.toString());
        }
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            if (bl) {
                httpURLConnection.addRequestProperty("Range", "bytes=" + Long_.To_str(l2) + "-");
            }
            httpURLConnection.setReadTimeout(10000);
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            if (bl) {
                if (n != 206) {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (n == 416 && l2 > 0L) {
                        Io_mgr.Instance.DeleteFil(this.Trg_url());
                        Io_mgr.Instance.DeleteFil(this.Checkpoint_url());
                    }
                    throw Err_.new_wo_type("server returned non-partial response code", "src", string, "code", httpURLConnection.getResponseCode(), "msg", httpURLConnection.getResponseMessage());
                }
            } else if (n != 200) {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw Err_.new_wo_type("server returned non-OK response code", "src", string, "code", httpURLConnection.getResponseCode(), "msg", httpURLConnection.getResponseMessage());
            }
            inputStream = httpURLConnection.getInputStream();
        }
        catch (Exception exception) {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw Err_.new_wo_type(Err__server_connection_failed, "src", string, "err", exception.toString());
        }
        try {
            int n;
            long l3 = gfo_prog_ui.Prog_data_end();
            if (l3 == -1L) {
                l3 = httpURLConnection.getContentLength();
            }
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
                this.Checkpoint__save(l2 += (long)n);
                if (!gfo_prog_ui.Prog_notify_and_chk_if_suspended(l2, l3)) continue;
                byte by = 16;
                return by;
            }
        }
        catch (Exception exception) {
            throw Err_.new_wo_type(Err__server_download_failed, "src", string, "trg_url", io_url, "err", exception.toString());
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return 4;
    }
}

