/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.net;

import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Bry_find_;
import gplx.Err_;
import gplx.String_;
import gplx.core.btries.Btrie_rv;
import gplx.core.btries.Btrie_slim_mgr;
import gplx.core.net.Http_client_rdr;
import gplx.core.net.Http_post_data_hash;
import gplx.core.net.Http_request_itm;
import gplx.core.net.Http_server_wtr;
import gplx.core.primitives.Int_obj_val;

public class Http_request_parser {
    private boolean dnt;
    private int type;
    private int content_length;
    private byte[] url;
    private byte[] protocol;
    private byte[] host;
    private byte[] user_agent;
    private byte[] accept;
    private byte[] accept_language;
    private byte[] accept_encoding;
    private byte[] x_requested_with;
    private byte[] cookie;
    private byte[] referer;
    private byte[] content_type;
    private byte[] content_type_boundary;
    private byte[] connection;
    private byte[] pragma;
    private byte[] cache_control;
    private byte[] origin;
    private Http_post_data_hash post_data_hash;
    private final Bry_bfr tmp_bfr = Bry_bfr_.New_w_size(255);
    private final Btrie_rv trv = new Btrie_rv();
    private final Http_server_wtr server_wtr;
    private final boolean log;
    private static final int Tid_get = 1;
    private static final int Tid_post = 2;
    private static final int Tid_host = 3;
    private static final int Tid_user_agent = 4;
    private static final int Tid_accept = 5;
    private static final int Tid_accept_language = 6;
    private static final int Tid_accept_encoding = 7;
    private static final int Tid_dnt = 8;
    private static final int Tid_x_requested_with = 9;
    private static final int Tid_cookie = 10;
    private static final int Tid_referer = 11;
    private static final int Tid_content_length = 12;
    private static final int Tid_content_type = 13;
    private static final int Tid_connection = 14;
    private static final int Tid_pragma = 15;
    private static final int Tid_cache_control = 16;
    private static final int Tid_origin = 17;
    private static final int Tid_accept_charset = 188;
    private static final int Tid_upgrade_request = 19;
    private static final int Tid_x_host = 20;
    private static final int Tid_x_real_ip = 21;
    private static final int Tid_sec_fetch_mode = 22;
    private static final int Tid_sec_fetch_site = 23;
    private static final Btrie_slim_mgr trie = Btrie_slim_mgr.ci_a7().Add_str_int("GET", 1).Add_str_int("POST", 2).Add_str_int("Host:", 3).Add_str_int("User-Agent:", 4).Add_str_int("Accept:", 5).Add_str_int("Accept-Language:", 6).Add_str_int("Accept-Encoding:", 7).Add_str_int("Accept-Charset:", 188).Add_str_int("DNT:", 8).Add_str_int("X-Requested-With:", 9).Add_str_int("Cookie:", 10).Add_str_int("Referer:", 11).Add_str_int("Content-length:", 12).Add_str_int("Content-Type:", 13).Add_str_int("Connection:", 14).Add_str_int("Pragma:", 15).Add_str_int("Cache-Control:", 16).Add_str_int("Origin:", 17).Add_str_int("Upgrade-Insecure-Requests:", 19).Add_str_int("X-Host:", 20).Add_str_int("X-Real-IP:", 21).Add_str_int("Sec-Fetch-Mode:", 22).Add_str_int("Sec-Fetch-Site:", 23);
    private static final byte[] Tkn_boundary = Bry_.new_a7("boundary=");
    private static final byte[] Tkn_content_type_boundary_end = Bry_.new_a7("--");
    private static final byte[] Tkn_content_disposition = Bry_.new_a7("Content-Disposition:");
    private static final byte[] Tkn_form_data = Bry_.new_a7("form-data;");
    private static final byte[] Tkn_name = Bry_.new_a7("name=");

    public Http_request_parser(Http_server_wtr http_server_wtr, boolean bl) {
        this.server_wtr = http_server_wtr;
        this.log = bl;
    }

    public void Clear() {
        this.dnt = false;
        this.content_length = 0;
        this.type = 0;
        this.origin = null;
        this.cache_control = null;
        this.pragma = null;
        this.connection = null;
        this.content_type_boundary = null;
        this.content_type = null;
        this.referer = null;
        this.cookie = null;
        this.x_requested_with = null;
        this.accept_encoding = null;
        this.accept_language = null;
        this.accept = null;
        this.user_agent = null;
        this.host = null;
        this.protocol = null;
        this.url = null;
        this.post_data_hash = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Http_request_itm Parse(Http_client_rdr http_client_rdr) {
        Bry_bfr bry_bfr = this.tmp_bfr;
        synchronized (bry_bfr) {
            String string;
            this.Clear();
            boolean bl = false;
            boolean bl2 = false;
            block31: while ((string = http_client_rdr.Read_line()) != null) {
                byte[] byArray;
                int n;
                if (this.log) {
                    this.server_wtr.Write_str_w_nl(string);
                }
                if ((n = (byArray = Bry_.new_u8(string)).length) == 0) {
                    switch (this.type) {
                        case 1: {
                            break block31;
                        }
                        case 2: {
                            if (bl || bl2) {
                                throw Err_.new_wo_type("http.request.parser;invalid new line during post", "request", this.To_str());
                            }
                            bl2 = true;
                            continue block31;
                        }
                        default: {
                            throw Err_.new_unimplemented();
                        }
                    }
                }
                if (this.content_type_boundary != null && Bry_.Has_at_bgn(byArray, this.content_type_boundary)) {
                    while (!Bry_.Has_at_end(byArray, Tkn_content_type_boundary_end)) {
                        byArray = this.Parse_content_type_boundary(http_client_rdr);
                    }
                    break;
                }
                Object object = trie.Match_at(this.trv, byArray, 0, n);
                if (object == null) {
                    this.server_wtr.Write_str_w_nl(String_.Format("http.request.parser; unknown line; line={0} request={1}", string, this.To_str()));
                    continue;
                }
                int n2 = Bry_find_.Find_fwd_while_ws(byArray, this.trv.Pos(), n);
                int n3 = ((Int_obj_val)object).Val();
                switch (n3) {
                    case 1: 
                    case 2: {
                        this.Parse_type(n3, n2, byArray, n);
                        continue block31;
                    }
                    case 3: {
                        this.host = Bry_.Mid(byArray, n2, n);
                        continue block31;
                    }
                    case 4: {
                        this.user_agent = Bry_.Mid(byArray, n2, n);
                        continue block31;
                    }
                    case 5: {
                        this.accept = Bry_.Mid(byArray, n2, n);
                        continue block31;
                    }
                    case 6: {
                        this.accept_language = Bry_.Mid(byArray, n2, n);
                        continue block31;
                    }
                    case 7: {
                        this.accept_encoding = Bry_.Mid(byArray, n2, n);
                        continue block31;
                    }
                    case 8: {
                        this.dnt = byArray[n2] == 49;
                        continue block31;
                    }
                    case 9: {
                        this.x_requested_with = Bry_.Mid(byArray, n2, n);
                        continue block31;
                    }
                    case 10: {
                        this.cookie = Bry_.Mid(byArray, n2, n);
                        continue block31;
                    }
                    case 11: {
                        this.referer = Bry_.Mid(byArray, n2, n);
                        continue block31;
                    }
                    case 12: {
                        this.content_length = Bry_.To_int_or(byArray, n2, n, -1);
                        continue block31;
                    }
                    case 13: {
                        this.Parse_content_type(n2, byArray, n);
                        continue block31;
                    }
                    case 14: {
                        this.connection = Bry_.Mid(byArray, n2, n);
                        continue block31;
                    }
                    case 15: {
                        this.pragma = Bry_.Mid(byArray, n2, n);
                        continue block31;
                    }
                    case 16: {
                        this.cache_control = Bry_.Mid(byArray, n2, n);
                        continue block31;
                    }
                    case 17: {
                        this.origin = Bry_.Mid(byArray, n2, n);
                        continue block31;
                    }
                    case 19: {
                        continue block31;
                    }
                    case 20: {
                        continue block31;
                    }
                    case 21: {
                        continue block31;
                    }
                    case 188: {
                        continue block31;
                    }
                    case 22: {
                        continue block31;
                    }
                    case 23: {
                        continue block31;
                    }
                }
                throw Err_.new_unhandled(n3);
            }
            return this.Make_request_itm();
        }
    }

    private void Parse_type(int n, int n2, byte[] byArray, int n3) {
        int n4 = Bry_find_.Find_bwd(byArray, (byte)32, n3);
        if (n4 == -1) {
            throw Err_.new_wo_type("invalid protocol", "line", byArray, "request", this.To_str());
        }
        switch (n) {
            case 1: {
                this.type = 1;
                break;
            }
            case 2: {
                this.type = 2;
                break;
            }
            default: {
                throw Err_.new_unimplemented();
            }
        }
        this.url = Bry_.Mid(byArray, n2, n4);
        this.protocol = Bry_.Mid(byArray, n4 + 1, n3);
    }

    private void Parse_content_type(int n, byte[] byArray, int n2) {
        int n3 = Bry_find_.Find_fwd(byArray, Tkn_boundary, n, n2);
        if (n3 == -1) {
            return;
        }
        int n4 = Bry_find_.Find_bwd(byArray, (byte)59, n3);
        this.content_type = Bry_.Mid(byArray, n, n4);
        this.content_type_boundary = Bry_.Add(Tkn_content_type_boundary_end, Bry_.Mid(byArray, n3 += Tkn_boundary.length, n2));
    }

    private Http_request_itm Make_request_itm() {
        return new Http_request_itm(this.type, this.url, this.protocol, this.host, this.user_agent, this.accept, this.accept_language, this.accept_encoding, this.dnt, this.x_requested_with, this.cookie, this.referer, this.content_length, this.content_type, this.content_type_boundary, this.connection, this.pragma, this.cache_control, this.origin, this.post_data_hash);
    }

    private byte[] Parse_content_type_boundary(Http_client_rdr http_client_rdr) {
        if (this.post_data_hash == null) {
            this.post_data_hash = new Http_post_data_hash();
        }
        byte[] byArray = Bry_.new_u8(http_client_rdr.Read_line());
        byte[] byArray2 = this.Parse_post_data_name(byArray);
        String string = http_client_rdr.Read_line();
        if (String_.Len_gt_0(string)) {
            throw Err_.new_wo_type("http.request.parser; blank_line should follow content_type_boundary", "request", this.To_str());
        }
        while (!Bry_.Has_at_bgn(byArray = Bry_.new_u8(http_client_rdr.Read_line()), this.content_type_boundary)) {
            if (this.tmp_bfr.Len_gt_0()) {
                this.tmp_bfr.Add_byte_nl();
            }
            this.tmp_bfr.Add(byArray);
        }
        byte[] byArray3 = this.tmp_bfr.To_bry_and_clear();
        this.post_data_hash.Add(byArray2, byArray3);
        return byArray;
    }

    private byte[] Parse_post_data_name(byte[] byArray) {
        int n = byArray.length;
        int n2 = this.Assert_tkn(byArray, 0, n, Tkn_content_disposition);
        n2 = this.Assert_tkn(byArray, n2, n, Tkn_form_data);
        n2 = this.Assert_tkn(byArray, n2, n, Tkn_name);
        int n3 = n;
        if (byArray[n2] == 34) {
            if (byArray[n3 - 1] != 34) {
                throw Err_.new_wo_type("http.request.parser; invalid form at end", "line", byArray, "request", this.To_str());
            }
            ++n2;
            --n3;
        }
        return Bry_.Mid(byArray, n2, n3);
    }

    private int Assert_tkn(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = byArray2.length;
        if (!Bry_.Match(byArray, n, n + n3, byArray2)) {
            throw Err_.new_wo_type("http.request.parser; invalid form_data line", "tkn", byArray2, "line", byArray, "request", this.To_str());
        }
        int n4 = n += n3;
        return Bry_find_.Find_fwd_while_ws(byArray, n4, n2);
    }

    private String To_str() {
        return this.Make_request_itm().To_str(this.tmp_bfr, false);
    }
}

