/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.lists.caches;

import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Datetime_now;
import gplx.Hash_adp;
import gplx.Hash_adp_;
import gplx.Internal;
import gplx.Io_mgr;
import gplx.Object_;
import gplx.Ordered_hash;
import gplx.Ordered_hash_;
import gplx.core.lists.Sorted_hash;
import gplx.core.lists.caches.Mru_cache_itm;
import gplx.core.lists.caches.Mru_cache_itm_comparer;
import gplx.core.lists.caches.Mru_cache_time_mgr;
import gplx.core.lists.caches.Mru_cache_time_mgr__clock;
import gplx.core.logs.Gfo_log_wtr;

public class Mru_cache_mgr {
    private final Mru_cache_time_mgr time_mgr;
    private final Gfo_log_wtr log_wtr;
    private final Hash_adp key_hash = Hash_adp_.New();
    private final Sorted_hash val_hash;
    private final Bry_bfr log_bfr = Bry_bfr_.New_w_size(255);
    private final Mru_cache_itm_comparer comparer;
    private final Ordered_hash dirty = Ordered_hash_.New();
    private long cache_max;
    private long cache_size;
    private long compress_size;

    Mru_cache_mgr(Mru_cache_time_mgr mru_cache_time_mgr, Gfo_log_wtr gfo_log_wtr, long l, long l2, long l3) {
        this.time_mgr = mru_cache_time_mgr;
        this.log_wtr = gfo_log_wtr;
        this.cache_max = l;
        this.compress_size = l2;
        this.comparer = new Mru_cache_itm_comparer(l3, mru_cache_time_mgr.Now());
        this.val_hash = new Sorted_hash(this.comparer);
    }

    public long Cache_max() {
        return this.cache_max;
    }

    public void Cache_max_(long l) {
        this.cache_max = l;
    }

    public Object Get_or_null(String string) {
        Object object = this.key_hash.Get_by(string);
        if (object == null) {
            return null;
        }
        Mru_cache_itm mru_cache_itm = (Mru_cache_itm)object;
        this.dirty.Add_if_dupe_use_1st(string, mru_cache_itm);
        mru_cache_itm.Dirty(this.time_mgr.Now());
        return mru_cache_itm.Val();
    }

    public void Add(String string, Object object, long l) {
        if (this.cache_size + l > this.cache_max) {
            this.Compress(l);
        }
        Mru_cache_itm mru_cache_itm = new Mru_cache_itm(string, object, l, this.time_mgr.Now());
        this.key_hash.Add(string, mru_cache_itm);
        this.val_hash.Add(mru_cache_itm, mru_cache_itm);
        this.cache_size += l;
    }

    public void Compress(long l) {
        int n = this.dirty.Len();
        for (int i = 0; i < n; ++i) {
            Mru_cache_itm mru_cache_itm = (Mru_cache_itm)this.dirty.Get_at(i);
            this.val_hash.Del(mru_cache_itm);
            mru_cache_itm.Update();
            this.val_hash.Add(mru_cache_itm, mru_cache_itm);
        }
        this.dirty.Clear();
        while (this.cache_size + l > this.compress_size) {
            Mru_cache_itm mru_cache_itm = (Mru_cache_itm)this.val_hash.Del_val_at_0();
            this.key_hash.Del(mru_cache_itm.Key());
            this.cache_size -= mru_cache_itm.Size();
            if (this.log_wtr == null) continue;
            this.Write(true, mru_cache_itm);
            this.log_wtr.Write(this.log_bfr);
        }
    }

    public void Flush() {
        this.log_wtr.Flush();
    }

    public void Print() {
        Object[] objectArray = this.val_hash.Values_array();
        int n = objectArray.length;
        for (int i = n - 1; i >= 0; --i) {
            Mru_cache_itm mru_cache_itm = (Mru_cache_itm)objectArray[i];
            this.Write(false, mru_cache_itm);
        }
        Io_mgr.Instance.SaveFilBfr(this.log_wtr.Fil_dir().GenSubFil("cache_mru_final.csv"), this.log_bfr);
        this.log_bfr.Clear();
    }

    private void Write(boolean bl, Mru_cache_itm mru_cache_itm) {
        if (bl) {
            this.log_bfr.Add_dte_under(Datetime_now.Get_force()).Add_byte_pipe();
        }
        this.log_bfr.Add_str_u8(Object_.Xto_str_strict_or_null_mark(mru_cache_itm.Key()));
        this.log_bfr.Add_byte_pipe().Add_long_fixed(this.comparer.Score(mru_cache_itm), 10);
        this.log_bfr.Add_byte_pipe().Add_long_variable(mru_cache_itm.Size());
        this.log_bfr.Add_byte_pipe().Add_long_variable(mru_cache_itm.Time_dif());
        this.log_bfr.Add_byte_pipe().Add_long_variable(mru_cache_itm.Used());
        this.log_bfr.Add_byte_nl();
    }

    public void Clear() {
        this.key_hash.Clear();
        this.val_hash.Clear();
        this.log_bfr.Clear();
        this.dirty.Clear();
        this.cache_size = 0L;
    }

    public static Mru_cache_mgr New_by_mb_secs(Gfo_log_wtr gfo_log_wtr, long l, long l2, long l3) {
        return new Mru_cache_mgr(new Mru_cache_time_mgr__clock(), gfo_log_wtr, 0x100000L * l, 0x100000L * l2, 1000L * l3);
    }

    public Object[] Values_array() {
        return this.val_hash.Values_array();
    }

    @Internal
    protected static Mru_cache_mgr New_test(Mru_cache_time_mgr mru_cache_time_mgr, Gfo_log_wtr gfo_log_wtr, long l, long l2, long l3) {
        return new Mru_cache_mgr(mru_cache_time_mgr, gfo_log_wtr, l, l2, l3);
    }
}

