/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.lists;

import gplx.Err_;
import gplx.core.lists.ComparerAble;
import gplx.core.lists.ComparerAble_;

public class Binary_heap {
    private final ComparerAble comparer;
    private boolean is_max;
    private Object[] heap;
    private int size;
    private static final int SLOT = 2;

    public Binary_heap(ComparerAble comparerAble, boolean bl, int n) {
        this.comparer = comparerAble;
        this.is_max = bl;
        this.heap = new Object[n];
        this.size = 0;
    }

    public Object Get() {
        if (this.size == 0) {
            throw Err_.new_wo_type("heap is empty", new Object[0]);
        }
        return this.heap[0];
    }

    public void Add(Object object) {
        if (this.size == this.heap.length) {
            int n = this.heap.length;
            Object[] objectArray = new Object[n * 2];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.heap[i];
            }
            this.heap = objectArray;
        }
        this.heap[this.size++] = object;
        this.Heapify_up(this.size - 1);
    }

    public Object Pop() {
        return this.Pop(0);
    }

    public Object Pop(int n) {
        if (this.size == 0) {
            throw Err_.new_wo_type("heap is empty", new Object[0]);
        }
        Object object = this.heap[n];
        this.heap[n] = this.heap[this.size - 1];
        --this.size;
        this.Heapify_down(n);
        return object;
    }

    private int Parent(int n) {
        return (n - 1) / 2;
    }

    private int Kth_child(int n, int n2) {
        return n * 2 + n2;
    }

    private int Max_child(int n) {
        int n2 = this.Kth_child(n, 1);
        int n3 = this.Kth_child(n, 2);
        int n4 = ComparerAble_.Compare(this.comparer, this.heap[n2], this.heap[n3]);
        boolean bl = this.is_max ? n4 == 1 : n4 == -1;
        return bl ? n2 : n3;
    }

    private void Heapify_up(int n) {
        Object object = this.heap[n];
        while (n > 0) {
            int n2 = ComparerAble_.Compare(this.comparer, object, this.heap[this.Parent(n)]);
            if (this.is_max) {
                if (n2 != 1) break;
            } else if (n2 != -1) break;
            this.heap[n] = this.heap[this.Parent(n)];
            n = this.Parent(n);
        }
        this.heap[n] = object;
    }

    private void Heapify_down(int n) {
        Object object = this.heap[n];
        while (this.Kth_child(n, 1) < this.size) {
            int n2 = this.Max_child(n);
            int n3 = ComparerAble_.Compare(this.comparer, object, this.heap[n2]);
            if (!(this.is_max ? n3 == -1 : n3 == 1)) break;
            this.heap[n] = this.heap[n2];
            n = n2;
        }
        this.heap[n] = object;
    }
}

