/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios.zips;

import gplx.Err_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.String_;
import gplx.core.envs.Op_sys;
import gplx.core.ios.zips.Io_zip_mgr;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Io_zip_mgr_base
implements Io_zip_mgr {
    byte[] tmp = new byte[4096];
    int tmpLen = 4096;
    public static final Io_zip_mgr Instance = new Io_zip_mgr_base();

    @Override
    public void Zip_fil(Io_url io_url, Io_url io_url2) {
        byte[] byArray = Io_mgr.Instance.LoadFilBry(io_url);
        byte[] byArray2 = this.Zip_bry(byArray, 0, byArray.length);
        Io_mgr.Instance.SaveFilBry(io_url2, byArray2);
    }

    @Override
    public void Zip_dir(Io_url io_url, Io_url io_url2) {
        try {
            byte[] byArray = new byte[4096];
            FileOutputStream fileOutputStream = new FileOutputStream(io_url2.Raw());
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            this.Zip_dir__add_dir(zipOutputStream, byArray, "", io_url, this.Zip_dir__get_subs(io_url));
            zipOutputStream.flush();
            zipOutputStream.close();
        }
        catch (IOException iOException) {
            Err_.new_exc(iOException, "io", "error duing zip", "src", io_url.Raw(), "trg", io_url2.Raw());
        }
    }

    private void Zip_dir__add_dir(ZipOutputStream zipOutputStream, byte[] byArray, String string, Io_url io_url, Io_url[] io_urlArray) {
        for (Io_url io_url2 : io_urlArray) {
            String string2 = string + io_url2.NameAndExt_noDirSpr();
            if (io_url2.Type_dir()) {
                this.Zip_dir__add_dir(zipOutputStream, byArray, string2 + "/", io_url2, this.Zip_dir__get_subs(io_url2));
                continue;
            }
            this.Zip_dir__add_fil(zipOutputStream, byArray, string2, io_url2);
        }
    }

    private void Zip_dir__add_fil(ZipOutputStream zipOutputStream, byte[] byArray, String string, Io_url io_url) {
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(io_url.Raw());
            zipOutputStream.putNextEntry(new ZipEntry(string));
            while ((n = fileInputStream.read(byArray)) > 0) {
                zipOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            throw Err_.new_exc(iOException, "io", "error duing zip", "src", string);
        }
    }

    private Io_url[] Zip_dir__get_subs(Io_url io_url) {
        return Io_mgr.Instance.QueryDir_args(io_url).DirInclude_().ExecAsUrlAry();
    }

    @Override
    public byte[] Zip_bry(byte[] byArray, int n, int n2) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        try {
            int n3;
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            ZipEntry zipEntry = new ZipEntry("file");
            zipOutputStream.putNextEntry(zipEntry);
            while ((n3 = byteArrayInputStream.read(this.tmp, 0, this.tmpLen)) != -1) {
                zipOutputStream.write(this.tmp, 0, n3);
            }
            zipOutputStream.close();
        }
        catch (Exception exception) {
            throw Err_.new_wo_type("failed to zip", "err", exception.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public byte[] Unzip_bry(byte[] byArray, int n, int n2) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        try {
            ZipInputStream zipInputStream = new ZipInputStream(byteArrayInputStream);
            while (zipInputStream.getNextEntry() != null) {
                int n3;
                while ((n3 = zipInputStream.read(this.tmp, 0, this.tmpLen)) != -1) {
                    byteArrayOutputStream.write(this.tmp, 0, n3);
                }
            }
        }
        catch (Exception exception) {
            throw Err_.new_wo_type("failed to unzip", "err", exception.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void Unzip_to_dir(Io_url io_url, Io_url io_url2) {
        byte[] byArray = new byte[4096];
        try {
            Io_mgr.Instance.CreateDirIfAbsent(io_url2);
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(io_url.Raw()));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String string = zipEntry.getName();
                if (Op_sys.Cur().Tid_is_wnt()) {
                    string = String_.Replace(string, "/", "\\");
                }
                Io_url io_url3 = Io_url_.new_any_(io_url2.GenSubFil(string).Raw());
                Io_mgr.Instance.CreateDirIfAbsent(io_url3.OwnerDir());
                if (io_url3.Type_fil()) {
                    int n;
                    Io_mgr.Instance.SaveFilStr_args(io_url3, "").Exec();
                    File file = new File(io_url3.Raw());
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    while ((n = zipInputStream.read(byArray)) > 0) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    fileOutputStream.close();
                }
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.closeEntry();
            zipInputStream.close();
        }
        catch (IOException iOException) {
            throw Err_.new_exc(iOException, "io", "error duing unzip", "src", io_url.Raw(), "trg", io_url2.Raw());
        }
    }
}

