/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios.streams;

import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Err_;
import gplx.Io_url;
import gplx.String_;
import gplx.core.ios.streams.Io_stream_rdr;
import gplx.core.ios.streams.rdrs.Io_stream_rdr__adp;
import gplx.core.ios.streams.rdrs.Io_stream_rdr__bzip2;
import gplx.core.ios.streams.rdrs.Io_stream_rdr__gzip;
import gplx.core.ios.streams.rdrs.Io_stream_rdr__noop;
import gplx.core.ios.streams.rdrs.Io_stream_rdr__raw;
import gplx.core.ios.streams.rdrs.Io_stream_rdr__xz;
import gplx.core.ios.streams.rdrs.Io_stream_rdr__zip;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class Io_stream_rdr_ {
    public static final int Read_done = -1;
    public static final int Read_done_compare = 1;
    public static final Io_stream_rdr Noop = new Io_stream_rdr__noop();

    public static Io_stream_rdr New__raw(Io_url io_url) {
        return new Io_stream_rdr__raw().Url_(io_url);
    }

    public static Io_stream_rdr New__raw(InputStream inputStream) {
        return new Io_stream_rdr__raw().Under_(inputStream);
    }

    private static Io_stream_rdr New__zip(Io_url io_url) {
        return new Io_stream_rdr__zip().Url_(io_url);
    }

    private static Io_stream_rdr New__gzip(Io_url io_url) {
        return new Io_stream_rdr__gzip().Url_(io_url);
    }

    public static Io_stream_rdr New__bzip2(Io_url io_url) {
        return new Io_stream_rdr__bzip2().Url_(io_url);
    }

    public static Io_stream_rdr New__mem(String string) {
        return Io_stream_rdr_.New__mem(Bry_.new_u8(string));
    }

    public static Io_stream_rdr New__mem(byte[] byArray) {
        Io_stream_rdr__adp io_stream_rdr__adp = new Io_stream_rdr__adp(Io_stream_rdr_.New__mem_as_stream(byArray));
        io_stream_rdr__adp.Len_(byArray.length);
        return io_stream_rdr__adp;
    }

    public static InputStream New__mem_as_stream(byte[] byArray) {
        return new ByteArrayInputStream(byArray);
    }

    public static Io_stream_rdr New_by_url(Io_url io_url) {
        String string = io_url.Ext();
        if (String_.Eq(string, ".zip")) {
            return Io_stream_rdr_.New__zip(io_url);
        }
        if (String_.Eq(string, ".gz")) {
            return Io_stream_rdr_.New__gzip(io_url);
        }
        if (String_.Eq(string, ".bz2")) {
            return Io_stream_rdr_.New__bzip2(io_url);
        }
        if (String_.Eq(string, ".xz")) {
            return new Io_stream_rdr__xz().Url_(io_url);
        }
        return Io_stream_rdr_.New__raw(io_url);
    }

    public static Io_stream_rdr New_by_tid(byte by) {
        switch (by) {
            case 1: {
                return new Io_stream_rdr__raw();
            }
            case 2: {
                return new Io_stream_rdr__zip();
            }
            case 3: {
                return new Io_stream_rdr__gzip();
            }
            case 4: {
                return new Io_stream_rdr__bzip2();
            }
            case 5: {
                return new Io_stream_rdr__xz();
            }
        }
        throw Err_.new_unhandled_default(by);
    }

    public static String Load_all_as_str(Io_stream_rdr io_stream_rdr) {
        return String_.new_u8(Io_stream_rdr_.Load_all_as_bry(Bry_bfr_.New(), io_stream_rdr));
    }

    public static byte[] Load_all_as_bry(Bry_bfr bry_bfr, Io_stream_rdr io_stream_rdr) {
        Io_stream_rdr_.Load_all_to_bfr(bry_bfr, io_stream_rdr);
        return bry_bfr.To_bry_and_clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Load_all_to_bfr(Bry_bfr bry_bfr, Io_stream_rdr io_stream_rdr) {
        try {
            int n;
            byte[] byArray = new byte[4096];
            while ((n = io_stream_rdr.Read(byArray, 0, 4096)) >= 1) {
                bry_bfr.Add_mid(byArray, 0, n);
            }
        }
        finally {
            io_stream_rdr.Rls();
        }
    }

    public static int Read_by_parts(InputStream inputStream, int n, byte[] byArray, int n2, int n3) {
        try {
            int n4 = 0;
            int n5 = n2 + n3;
            int n6 = n2;
            while (true) {
                int n7;
                int n8;
                if (n6 + (n8 = n) > n5) {
                    n8 = n5 - n6;
                }
                if (n6 == n5 || (n7 = inputStream.read(byArray, n6, n8)) == -1) break;
                n4 += n7;
                n6 += n7;
            }
            return n4;
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "io", "read failed", "bgn", n2, "len", n3);
        }
    }

    public static boolean Close(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
            return true;
        }
        catch (Exception exception) {
            Err_.Noop(exception);
            return false;
        }
    }
}

