/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios.atrs;

import gplx.Err_;
import gplx.Hash_adp;
import gplx.Hash_adp_;
import gplx.core.ios.atrs.Acl_entry;
import gplx.core.ios.atrs.Io_itm_atr_wkr;
import gplx.core.primitives.Bool_obj_val;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclFileAttributeView;
import java.util.List;
import java.util.Set;

class Io_itm_atr_wkr__acl
extends Io_itm_atr_wkr {
    private final AclFileAttributeView view;

    public Io_itm_atr_wkr__acl(Path path) {
        super(path);
        this.view = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
    }

    @Override
    public boolean Is_read_only() {
        try {
            List<AclEntry> list = this.view.getAcl();
            int n = list.size();
            Acl_entry[] acl_entryArray = new Acl_entry[n];
            for (int i = 0; i < n; ++i) {
                AclEntry aclEntry = list.get(i);
                acl_entryArray[i] = new Acl_entry(aclEntry.principal().toString(), aclEntry.type(), aclEntry.permissions());
            }
            return !Io_itm_atr_wkr__acl.Is_permitted(acl_entryArray, AclEntryPermission.WRITE_DATA);
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "", "Is_read_only failed", "e", Err_.Message_lang(exception));
        }
    }

    public static boolean Is_permitted(Acl_entry[] acl_entryArray, AclEntryPermission aclEntryPermission) {
        boolean bl = false;
        Hash_adp hash_adp = Hash_adp_.New();
        block4: for (Acl_entry acl_entry : acl_entryArray) {
            Set<AclEntryPermission> set = acl_entry.Permissions();
            switch (acl_entry.Type()) {
                case ALLOW: {
                    Bool_obj_val bool_obj_val = (Bool_obj_val)hash_adp.Get_by(acl_entry.Principal());
                    if (bool_obj_val != null) continue block4;
                    if (!set.contains((Object)aclEntryPermission) && !bl) {
                        bl = false;
                        hash_adp.Add(acl_entry.Principal(), Bool_obj_val.False);
                        continue block4;
                    }
                    bl = true;
                    continue block4;
                }
                case DENY: {
                    if (!set.contains((Object)aclEntryPermission)) continue block4;
                    return false;
                }
            }
        }
        return bl;
    }
}

