/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios.atrs;

import gplx.Err;
import gplx.Err_;
import gplx.Gfo_usr_dlg_;
import gplx.Io_url;
import gplx.core.ios.atrs.Io_itm_atr_req;
import gplx.core.ios.atrs.Io_itm_atr_wkr__acl;
import gplx.core.ios.atrs.Io_itm_atr_wkr__psx;
import java.io.File;
import java.nio.file.Path;
import java.util.Set;

public abstract class Io_itm_atr_wkr {
    private final Path path;

    public Io_itm_atr_wkr(Path path) {
        this.path = path;
    }

    public Io_itm_atr_req Process(Io_itm_atr_req io_itm_atr_req) {
        try {
            if (io_itm_atr_req.Check_read_only()) {
                io_itm_atr_req.Is_read_only_(this.Is_read_only());
            }
        }
        catch (Exception exception) {
            Err err = Err_.new_wo_type("query_itm_atrs failed", "url", this.path.toString(), "atrs", io_itm_atr_req.To_str(), "e", Err_.Message_gplx_log(exception));
            if (io_itm_atr_req.Ignore_errors()) {
                Gfo_usr_dlg_.Instance.Warn_many("", "", err.To_str__log(), new Object[0]);
            }
            throw err;
        }
        return io_itm_atr_req;
    }

    public abstract boolean Is_read_only();

    public static Io_itm_atr_wkr New(Io_url io_url) {
        File file = new File(io_url.Xto_api());
        Path path = file.toPath();
        Set<String> set = path.getFileSystem().supportedFileAttributeViews();
        if (set.contains("posix")) {
            return new Io_itm_atr_wkr__psx(path);
        }
        if (set.contains("acl")) {
            return new Io_itm_atr_wkr__acl(path);
        }
        String string = "";
        for (String string2 : set) {
            string = string + string2 + ";";
        }
        throw Err_.new_unhandled(string);
    }
}

