/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.Err_;
import gplx.Internal;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.Rls_able;
import gplx.String_;
import gplx.core.ios.IoItmFil;
import gplx.core.ios.streams.Io_stream_rdr;

public class Io_buffer_rdr
implements Rls_able {
    private Io_stream_rdr rdr;
    private Io_url url;
    private byte[] bfr;
    private int bfr_len;
    long fil_len;
    long fil_pos;
    private boolean fil_eof;
    public static final Io_buffer_rdr Null = new Io_buffer_rdr();

    Io_buffer_rdr(Io_stream_rdr io_stream_rdr, Io_url io_url, int n) {
        this.rdr = io_stream_rdr;
        this.url = io_url;
        if (n <= 0) {
            throw Err_.new_wo_type("bfr_len must be > 0", "bfr_len", n);
        }
        this.bfr = new byte[n];
        this.bfr_len = n;
        IoItmFil ioItmFil = Io_mgr.Instance.QueryFil(io_url);
        if (!ioItmFil.Exists()) {
            throw Err_.new_wo_type("fil does not exist", "url", io_url);
        }
        this.fil_len = ioItmFil.Size();
        this.fil_pos = 0L;
        this.fil_eof = false;
    }

    public Io_url Url() {
        return this.url;
    }

    public byte[] Bfr() {
        return this.bfr;
    }

    public int Bfr_len() {
        return this.bfr_len;
    }

    public long Fil_len() {
        return this.fil_len;
    }

    public long Fil_pos() {
        return this.fil_pos;
    }

    public boolean Fil_eof() {
        return this.fil_eof;
    }

    public boolean Bfr_load_all() {
        return this.Bfr_load(0, this.bfr_len);
    }

    public boolean Bfr_load_from(int n) {
        if (n < 0 || n > this.bfr_len) {
            throw Err_.new_wo_type("invalid bfr_pos", "bfr_pos", n, "bfr_len", this.bfr_len);
        }
        for (int i = n; i < this.bfr_len; ++i) {
            this.bfr[i - n] = this.bfr[i];
        }
        return this.Bfr_load(this.bfr_len - n, n);
    }

    private boolean Bfr_load(int n, int n2) {
        int n3 = this.rdr.Read(this.bfr, n, n2);
        if (n3 == -1) {
            this.fil_eof = true;
            return false;
        }
        this.fil_pos += (long)n3;
        this.bfr_len = n + n3;
        if (n3 < n2) {
            this.fil_eof = true;
        }
        return true;
    }

    public void Seek(long l) {
        this.fil_pos = l;
        this.rdr.Skip(l);
        this.Bfr_load_all();
    }

    @Override
    public void Rls() {
        this.bfr = null;
        this.bfr_len = -1;
        if (this.rdr != null) {
            this.rdr.Rls();
        }
    }

    @Internal
    protected void Dump_to_file(int n, int n2, String string, String string2) {
        String string3 = String_.new_u8__by_len(this.bfr, n, n2);
        Io_mgr.Instance.AppendFilStr(Io_url_.new_any_(string), string2 + string3 + "\n");
    }

    public static Io_buffer_rdr new_(Io_stream_rdr io_stream_rdr, int n) {
        Io_buffer_rdr io_buffer_rdr = new Io_buffer_rdr(io_stream_rdr, io_stream_rdr.Url(), n);
        io_stream_rdr.Open();
        io_buffer_rdr.Bfr_load(0, n);
        return io_buffer_rdr;
    }

    Io_buffer_rdr() {
    }
}

