/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.Bry_;
import gplx.DateAdp;
import gplx.Datetime_now;
import gplx.Err_;
import gplx.Internal;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.String_;
import gplx.core.ios.IoEnginePool;
import gplx.core.ios.IoEngineUtl;
import gplx.core.ios.IoEngine_base;
import gplx.core.ios.IoEngine_xrg_deleteDir;
import gplx.core.ios.IoEngine_xrg_deleteFil;
import gplx.core.ios.IoEngine_xrg_downloadFil;
import gplx.core.ios.IoEngine_xrg_loadFilStr;
import gplx.core.ios.IoEngine_xrg_openWrite;
import gplx.core.ios.IoEngine_xrg_queryDir;
import gplx.core.ios.IoEngine_xrg_saveFilStr;
import gplx.core.ios.IoEngine_xrg_xferDir;
import gplx.core.ios.IoEngine_xrg_xferFil;
import gplx.core.ios.IoErr;
import gplx.core.ios.IoItmAttrib;
import gplx.core.ios.IoItmDir;
import gplx.core.ios.IoItmDir_;
import gplx.core.ios.IoItmFil;
import gplx.core.ios.IoItmFil_;
import gplx.core.ios.IoItmFil_mem;
import gplx.core.ios.IoItmHash;
import gplx.core.ios.IoItm_base;
import gplx.core.ios.atrs.Io_itm_atr_req;
import gplx.core.ios.streams.IoStream;
import gplx.core.ios.streams.Io_stream_rdr;
import gplx.core.ios.streams.Io_stream_rdr_;

public class IoEngine_memory
extends IoEngine_base {
    private String key = "mem";
    IoItmHash dirs = IoItmHash.new_();
    IoEngineUtl utl = IoEngineUtl.new_();

    @Override
    public String Key() {
        return this.key;
    }

    @Override
    public boolean ExistsFil_api(Io_url io_url) {
        return this.FetchFil(io_url) != IoItmFil_mem.Null;
    }

    @Override
    public void DeleteFil_api(IoEngine_xrg_deleteFil ioEngine_xrg_deleteFil) {
        Io_url io_url = ioEngine_xrg_deleteFil.Url();
        IoItmDir ioItmDir = this.FetchDir(io_url.OwnerDir());
        if (ioItmDir == null) {
            return;
        }
        IoItmFil ioItmFil = IoItmFil_.as_(ioItmDir.SubFils().Get_by(io_url.NameAndExt()));
        if (ioItmFil != null && ioItmFil.ReadOnly() && ioEngine_xrg_deleteFil.ReadOnlyFails()) {
            throw IoErr.FileIsReadOnly(io_url);
        }
        ioItmDir.SubFils().Del(io_url);
    }

    void DeleteFil(Io_url io_url) {
        this.DeleteFil_api(IoEngine_xrg_deleteFil.new_(io_url));
    }

    @Override
    public void XferFil(IoEngine_xrg_xferFil ioEngine_xrg_xferFil) {
        this.utl.XferFil(this, ioEngine_xrg_xferFil);
    }

    @Override
    public void MoveFil(IoEngine_xrg_xferFil ioEngine_xrg_xferFil) {
        Io_url io_url = ioEngine_xrg_xferFil.Src();
        Io_url io_url2 = ioEngine_xrg_xferFil.Trg();
        boolean bl = ioEngine_xrg_xferFil.Overwrite();
        if (String_.Eq(io_url.Xto_api(), io_url2.Xto_api())) {
            throw Err_.new_wo_type("move failed; src is same as trg", "raw", io_url.Raw());
        }
        this.CheckTransferArgs("move", io_url, io_url2, bl);
        if (bl) {
            this.DeleteFil(io_url2);
        }
        IoItmFil_mem ioItmFil_mem = this.FetchFil(io_url);
        ioItmFil_mem.Name_(io_url2.NameAndExt());
        this.AddFilToDir(io_url2.OwnerDir(), ioItmFil_mem);
        this.DeleteFil(io_url);
    }

    @Override
    public void CopyFil(IoEngine_xrg_xferFil ioEngine_xrg_xferFil) {
        Io_url io_url = ioEngine_xrg_xferFil.Src();
        Io_url io_url2 = ioEngine_xrg_xferFil.Trg();
        boolean bl = ioEngine_xrg_xferFil.Overwrite();
        this.CheckTransferArgs("copy", io_url, io_url2, bl);
        if (bl) {
            this.DeleteFil(io_url2);
        }
        IoItmFil_mem ioItmFil_mem = this.FetchFil(io_url);
        IoItmFil_mem ioItmFil_mem2 = ioItmFil_mem.Clone();
        ioItmFil_mem2.Name_(io_url2.NameAndExt());
        this.AddFilToDir(io_url2.OwnerDir(), ioItmFil_mem2);
    }

    @Override
    public IoItmDir QueryDirDeep(IoEngine_xrg_queryDir ioEngine_xrg_queryDir) {
        return this.utl.QueryDirDeep(this, ioEngine_xrg_queryDir);
    }

    @Override
    public void UpdateFilAttrib(Io_url io_url, IoItmAttrib ioItmAttrib) {
        this.FetchFil(io_url).ReadOnly_(ioItmAttrib.ReadOnly());
    }

    @Override
    public void UpdateFilModifiedTime(Io_url io_url, DateAdp dateAdp) {
        this.FetchFil(io_url).ModifiedTime_(dateAdp);
    }

    @Override
    public IoItmFil QueryFil(Io_url io_url) {
        return this.FetchFil(io_url);
    }

    @Override
    public void SaveFilText_api(IoEngine_xrg_saveFilStr ioEngine_xrg_saveFilStr) {
        IoItmFil ioItmFil;
        Io_url io_url = ioEngine_xrg_saveFilStr.Url();
        IoItmDir ioItmDir = this.FetchDir(io_url.OwnerDir());
        if (ioItmDir != null && (ioItmFil = IoItmFil_.as_(ioItmDir.SubFils().Get_by(io_url.NameAndExt()))) != null && ioItmFil.ReadOnly()) {
            throw IoErr.FileIsReadOnly(io_url);
        }
        if (ioEngine_xrg_saveFilStr.Append()) {
            this.AppendFilStr(ioEngine_xrg_saveFilStr);
        } else {
            this.SaveFilStr(ioEngine_xrg_saveFilStr.Url(), ioEngine_xrg_saveFilStr.Text());
        }
    }

    @Override
    public boolean Truncate_fil(Io_url io_url, long l) {
        throw Err_.new_unimplemented();
    }

    @Override
    public String LoadFilStr(IoEngine_xrg_loadFilStr ioEngine_xrg_loadFilStr) {
        return this.FetchFil(ioEngine_xrg_loadFilStr.Url()).Text();
    }

    void SaveFilStr(Io_url io_url, String string) {
        DateAdp dateAdp = Datetime_now.Get();
        IoItmFil_mem ioItmFil_mem = IoItmFil_mem.new_(io_url, String_.Len(string), dateAdp, string);
        this.AddFilToDir(io_url.OwnerDir(), ioItmFil_mem);
    }

    void AppendFilStr(IoEngine_xrg_saveFilStr ioEngine_xrg_saveFilStr) {
        Io_url io_url = ioEngine_xrg_saveFilStr.Url();
        String string = ioEngine_xrg_saveFilStr.Text();
        if (this.ExistsFil_api(io_url)) {
            IoItmFil_mem ioItmFil_mem = this.FetchFil(io_url);
            ioItmFil_mem.ModifiedTime_(Datetime_now.Get());
            ioItmFil_mem.Text_set(ioItmFil_mem.Text() + string);
        } else {
            this.SaveFilStr(ioEngine_xrg_saveFilStr.Url(), ioEngine_xrg_saveFilStr.Text());
        }
    }

    @Override
    public IoStream OpenStreamRead(Io_url io_url) {
        IoItmFil_mem ioItmFil_mem = this.FetchFil(io_url);
        ioItmFil_mem.Stream().Position_set(0);
        return ioItmFil_mem.Stream();
    }

    @Override
    public IoStream OpenStreamWrite(IoEngine_xrg_openWrite ioEngine_xrg_openWrite) {
        Io_url io_url = ioEngine_xrg_openWrite.Url();
        IoItmFil_mem ioItmFil_mem = this.FetchFil(io_url);
        if (ioItmFil_mem == IoItmFil_mem.Null) {
            this.SaveFilStr(io_url, "");
            ioItmFil_mem = this.FetchFil(io_url);
        } else if (ioEngine_xrg_openWrite.Mode() == 1) {
            ioItmFil_mem.Text_set("");
        }
        return ioItmFil_mem.Stream();
    }

    @Override
    public boolean ExistsDir(Io_url io_url) {
        return this.FetchDir(io_url) != null;
    }

    @Override
    public void CreateDir(Io_url io_url) {
        IoItmDir ioItmDir = this.FetchDir(io_url);
        if (ioItmDir != null) {
            return;
        }
        ioItmDir = IoItmDir_.top_(io_url);
        this.dirs.Add(ioItmDir);
        IoItmDir ioItmDir2 = this.FetchDir(io_url.OwnerDir());
        if (ioItmDir2 == null && !io_url.OwnerDir().Eq(Io_url_.Empty)) {
            this.CreateDir(io_url.OwnerDir());
            ioItmDir2 = this.FetchDir(io_url.OwnerDir());
        }
        if (ioItmDir2 != null) {
            ioItmDir2.SubDirs().Add(ioItmDir);
        }
    }

    @Override
    public void DeleteDir(Io_url io_url) {
        this.FetchDir(io_url);
        this.dirs.Del(io_url);
        IoItmDir ioItmDir = this.FetchDir(io_url.OwnerDir());
        if (ioItmDir == null) {
            return;
        }
        ioItmDir.SubDirs().Del(io_url);
    }

    @Override
    public void XferDir(IoEngine_xrg_xferDir ioEngine_xrg_xferDir) {
        Io_url io_url = ioEngine_xrg_xferDir.Trg();
        this.utl.XferDir(this, ioEngine_xrg_xferDir.Src(), IoEnginePool.Instance.Get_by(io_url.Info().EngineKey()), io_url, ioEngine_xrg_xferDir);
    }

    @Override
    public void MoveDirDeep(IoEngine_xrg_xferDir ioEngine_xrg_xferDir) {
        Io_url io_url = ioEngine_xrg_xferDir.Trg();
        this.utl.XferDir(this, ioEngine_xrg_xferDir.Src(), IoEnginePool.Instance.Get_by(io_url.Info().EngineKey()), io_url, ioEngine_xrg_xferDir);
    }

    @Override
    public void MoveDir(Io_url io_url, Io_url io_url2) {
        if (this.ExistsDir(io_url2)) {
            throw Err_.new_wo_type("trg already exists", "trg", io_url2);
        }
        IoItmDir ioItmDir = this.FetchDir(io_url);
        ioItmDir.Name_(io_url2.NameAndExt());
        for (Object e : ioItmDir.SubFils()) {
            IoItmFil ioItmFil = (IoItmFil)e;
            ioItmFil.OwnerDir_set(ioItmDir);
        }
        this.dirs.Add(ioItmDir);
        this.DeleteDir(io_url);
    }

    @Override
    public IoItmDir QueryDir(Io_url io_url) {
        IoItm_base ioItm_base;
        IoItmDir ioItmDir = this.FetchDir(io_url);
        IoItmDir ioItmDir2 = IoItmDir_.top_(io_url);
        if (ioItmDir == null) {
            ioItmDir2.Exists_set(false);
            return ioItmDir2;
        }
        for (Object e : ioItmDir.SubDirs()) {
            ioItm_base = (IoItmDir)e;
            ioItmDir2.SubDirs().Add(IoItmDir_.scan_(ioItm_base.Url()));
        }
        for (Object e : ioItmDir.SubFils()) {
            ioItm_base = (IoItmFil)e;
            ioItmDir2.SubFils().Add(ioItm_base);
        }
        return ioItmDir2;
    }

    @Override
    public void DeleteDirDeep(IoEngine_xrg_deleteDir ioEngine_xrg_deleteDir) {
        this.utl.DeleteDirDeep(this, ioEngine_xrg_deleteDir.Url(), ioEngine_xrg_deleteDir);
    }

    @Override
    public void CopyDir(Io_url io_url, Io_url io_url2) {
        IoEngine_xrg_xferDir.copy_(io_url, io_url2).Recur_().Exec();
    }

    void AddFilToDir(Io_url io_url, IoItmFil ioItmFil) {
        IoItmDir ioItmDir = this.FetchDir(io_url);
        if (ioItmDir == null) {
            this.CreateDir(io_url);
            ioItmDir = this.FetchDir(io_url);
        }
        ioItmDir.SubFils().Del(ioItmFil.Url());
        ioItmDir.SubFils().Add(ioItmFil);
    }

    IoItmDir FetchDir(Io_url io_url) {
        return IoItmDir_.as_(this.dirs.Get_by(io_url));
    }

    IoItmFil_mem FetchFil(Io_url io_url) {
        IoItmDir ioItmDir = this.FetchDir(io_url.OwnerDir());
        if (ioItmDir == null) {
            return IoItmFil_mem.Null;
        }
        IoItmFil_mem ioItmFil_mem = IoItmFil_mem.as_(ioItmDir.SubFils().Get_by(io_url.NameAndExt()));
        if (ioItmFil_mem == null) {
            ioItmFil_mem = IoItmFil_mem.Null;
        }
        return ioItmFil_mem;
    }

    void CheckTransferArgs(String string, Io_url io_url, Io_url io_url2, boolean bl) {
        if (!this.ExistsFil_api(io_url)) {
            throw Err_.new_wo_type("src does not exist", "src", io_url);
        }
        if (this.ExistsFil_api(io_url2) && !bl) {
            throw Err_.new_invalid_op("trg already exists").Args_add("op", string, "overwrite", false, "src", io_url, "trg", io_url2);
        }
    }

    public void Clear() {
        this.dirs.Clear();
    }

    @Override
    public boolean DownloadFil(IoEngine_xrg_downloadFil ioEngine_xrg_downloadFil) {
        Io_url io_url = Io_url_.mem_fil_(ioEngine_xrg_downloadFil.Src());
        if (!this.ExistsFil_api(io_url)) {
            ioEngine_xrg_downloadFil.Rslt_((byte)2);
            return false;
        }
        this.XferFil(IoEngine_xrg_xferFil.copy_(io_url, ioEngine_xrg_downloadFil.Trg()).Overwrite_());
        return true;
    }

    @Override
    public Io_stream_rdr DownloadFil_as_rdr(IoEngine_xrg_downloadFil ioEngine_xrg_downloadFil) {
        Io_url io_url = Io_url_.mem_fil_(ioEngine_xrg_downloadFil.Src());
        if (!this.ExistsFil_api(io_url)) {
            ioEngine_xrg_downloadFil.Rslt_((byte)2);
            return Io_stream_rdr_.Noop;
        }
        byte[] byArray = Bry_.new_u8(this.FetchFil(Io_url_.mem_fil_(ioEngine_xrg_downloadFil.Src())).Text());
        return Io_stream_rdr_.New__mem(byArray);
    }

    @Override
    public Io_itm_atr_req Query_itm_atrs(Io_url io_url, Io_itm_atr_req io_itm_atr_req) {
        return io_itm_atr_req;
    }

    @Internal
    protected static IoEngine_memory new_(String string) {
        IoEngine_memory ioEngine_memory = new IoEngine_memory();
        ioEngine_memory.key = string;
        return ioEngine_memory;
    }

    IoEngine_memory() {
    }
}

