/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.gfobjs;

import gplx.Err_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.core.gfobjs.Gfobj_ary;
import gplx.core.gfobjs.Gfobj_grp;
import gplx.core.gfobjs.Gfobj_nde;
import gplx.langs.jsons.Json_ary;
import gplx.langs.jsons.Json_doc;
import gplx.langs.jsons.Json_itm;
import gplx.langs.jsons.Json_itm_bool;
import gplx.langs.jsons.Json_itm_decimal;
import gplx.langs.jsons.Json_itm_int;
import gplx.langs.jsons.Json_itm_long;
import gplx.langs.jsons.Json_itm_str;
import gplx.langs.jsons.Json_kv;
import gplx.langs.jsons.Json_nde;
import gplx.langs.jsons.Json_parser;

public class Gfobj_rdr__json {
    private final Json_parser parser = new Json_parser();

    public Gfobj_grp Load(Io_url io_url) {
        byte[] byArray = Io_mgr.Instance.LoadFilBryOrNull(io_url);
        if (byArray == null) {
            return null;
        }
        return this.Parse(byArray);
    }

    public Gfobj_grp Parse(byte[] byArray) {
        Json_doc json_doc = this.parser.Parse(byArray);
        if (json_doc.Root_grp().Tid() == 9) {
            Gfobj_nde gfobj_nde = Gfobj_nde.New();
            this.Parse_nde((Json_nde)json_doc.Root_grp(), gfobj_nde);
            return gfobj_nde;
        }
        Gfobj_ary gfobj_ary = new Gfobj_ary(null);
        this.Parse_ary((Json_ary)json_doc.Root_grp(), gfobj_ary);
        return gfobj_ary;
    }

    private void Parse_nde(Json_nde json_nde, Gfobj_nde gfobj_nde) {
        int n = json_nde.Len();
        block10: for (int i = 0; i < n; ++i) {
            Json_kv json_kv = json_nde.Get_at_as_kv(i);
            String string = json_kv.Key_as_str();
            Json_itm json_itm = json_kv.Val();
            byte by = json_itm.Tid();
            switch (by) {
                case 6: {
                    gfobj_nde.Add_str(string, ((Json_itm_str)json_itm).Data_as_str());
                    continue block10;
                }
                case 2: {
                    gfobj_nde.Add_bool(string, ((Json_itm_bool)json_itm).Data_as_bool());
                    continue block10;
                }
                case 3: {
                    gfobj_nde.Add_int(string, ((Json_itm_int)json_itm).Data_as_int());
                    continue block10;
                }
                case 4: {
                    gfobj_nde.Add_long(string, ((Json_itm_long)json_itm).Data_as_long());
                    continue block10;
                }
                case 5: {
                    gfobj_nde.Add_double(string, ((Json_itm_decimal)json_itm).Data_as_decimal().To_double());
                    continue block10;
                }
                case 1: {
                    gfobj_nde.Add_str(string, null);
                    continue block10;
                }
                case 8: {
                    Gfobj_ary gfobj_ary = new Gfobj_ary(null);
                    gfobj_nde.Add_ary(string, gfobj_ary);
                    this.Parse_ary(Json_ary.cast(json_itm), gfobj_ary);
                    continue block10;
                }
                case 9: {
                    Gfobj_nde gfobj_nde2 = Gfobj_nde.New();
                    gfobj_nde.Add_nde(string, gfobj_nde2);
                    this.Parse_nde(Json_nde.cast(json_itm), gfobj_nde2);
                    continue block10;
                }
                default: {
                    throw Err_.new_unhandled_default(by);
                }
            }
        }
    }

    private void Parse_ary(Json_ary json_ary, Gfobj_ary gfobj_ary) {
        int n = json_ary.Len();
        Object[] objectArray = new Object[n];
        gfobj_ary.Ary_(objectArray);
        block4: for (int i = 0; i < n; ++i) {
            Json_itm json_itm = json_ary.Get_at(i);
            switch (json_itm.Tid()) {
                case 8: {
                    Gfobj_grp gfobj_grp = new Gfobj_ary(null);
                    this.Parse_ary(Json_ary.cast(json_itm), (Gfobj_ary)gfobj_grp);
                    objectArray[i] = gfobj_grp;
                    continue block4;
                }
                case 9: {
                    Gfobj_grp gfobj_grp = Gfobj_nde.New();
                    this.Parse_nde(Json_nde.cast(json_itm), (Gfobj_nde)gfobj_grp);
                    objectArray[i] = gfobj_grp;
                    continue block4;
                }
                default: {
                    objectArray[i] = json_itm.Data();
                }
            }
        }
    }
}

