/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.gfo_regys;

import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.GfsCtx;
import gplx.Hash_adp;
import gplx.Hash_adp_;
import gplx.Internal;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.String_;
import gplx.UsrDlg_;
import gplx.UsrMsg;
import gplx.core.gfo_regys.GfoRegyItm;
import gplx.core.interfaces.ParseAble;

public class GfoRegy
implements Gfo_invk {
    Hash_adp parsers = Hash_adp_.New();
    public static final String Invk_RegDir = "RegDir";
    public static final String Invk_RegObj = "RegObj";
    Hash_adp hash = Hash_adp_.New();
    public static final String Err_ChopBgn = "chopBgn results in null key";
    public static final String Err_ChopEnd = "chopEnd results in null key";
    public static final String Err_Dupe = "key already registered";
    public static final GfoRegy Instance = new GfoRegy();

    public int Count() {
        return this.hash.Count();
    }

    public Hash_adp Parsers() {
        return this.parsers;
    }

    public GfoRegyItm FetchOrNull(String string) {
        return (GfoRegyItm)this.hash.Get_by(string);
    }

    public Object FetchValOrFail(String string) {
        GfoRegyItm gfoRegyItm = (GfoRegyItm)this.hash.Get_by(string);
        if (gfoRegyItm == null) {
            throw Err_.new_wo_type("regy does not have key", "key", string);
        }
        return gfoRegyItm.Val();
    }

    public Object FetchValOrNull(String string) {
        return this.FetchValOr(string, null);
    }

    public Object FetchValOr(String string, Object object) {
        GfoRegyItm gfoRegyItm = this.FetchOrNull(string);
        return gfoRegyItm == null ? object : gfoRegyItm.Val();
    }

    public void Del(String string) {
        this.hash.Del(string);
    }

    public void RegObj(String string, Object object) {
        this.RegItm(string, object, 1, Io_url_.Empty);
    }

    public void RegDir(Io_url io_url, String string, boolean bl, String string2, String string3) {
        Io_url[] io_urlArray = Io_mgr.Instance.QueryDir_args(io_url).FilPath_(string).Recur_(bl).ExecAsUrlAry();
        if (io_urlArray.length == 0 && !Io_mgr.Instance.ExistsDir(io_url)) {
            UsrDlg_.Instance.Stop(UsrMsg.new_("dirUrl does not exist").Add("dirUrl", io_url.Xto_api()));
            return;
        }
        for (Io_url io_url2 : io_urlArray) {
            String string4 = io_url2.NameAndExt();
            int n = -1;
            if (String_.EqNot(string2, "")) {
                n = String_.FindFwd(string4, string2);
                if (n == String_.Len(string4) - 1) {
                    throw Err_.new_wo_type(Err_ChopBgn, "key", string4, "chopBgn", string2);
                }
                if (n != -1) {
                    string4 = String_.Mid(string4, n + 1);
                }
            }
            if (String_.EqNot(string3, "")) {
                n = String_.FindBwd(string4, string3);
                if (n == 0) {
                    throw Err_.new_wo_type(Err_ChopEnd, "key", string4, "chopEnd", string3);
                }
                if (n != -1) {
                    string4 = String_.MidByLen(string4, 0, n);
                }
            }
            if (this.hash.Has(string4)) {
                throw Err_.new_wo_type(Err_Dupe, "key", string4, "filUrl", io_url2);
            }
            this.RegItm(string4, null, 2, io_url2);
        }
    }

    public void RegObjByType(String string, String string2, String string3) {
        Object object = string2;
        if (String_.EqNot(string3, "string")) {
            ParseAble parseAble = (ParseAble)this.parsers.Get_by(string3);
            if (parseAble == null) {
                throw Err_.new_wo_type("could not find parser", "type", string3, "key", string, "val", string2);
            }
            object = parseAble.ParseAsObj(string2);
        }
        this.RegItm(string, object, 1, Io_url_.Empty);
    }

    @Override
    public Object Invk(GfsCtx gfsCtx, int n, String string, GfoMsg gfoMsg) {
        if (gfsCtx.Match(string, Invk_RegDir)) {
            Io_url io_url = gfoMsg.ReadIoUrl("dir");
            String string2 = gfoMsg.ReadStrOr("match", "*.*");
            boolean bl = gfoMsg.ReadBoolOr("recur", false);
            String string3 = gfoMsg.ReadStrOr("chopBgn", "");
            String string4 = gfoMsg.ReadStrOr("chopEnd", ".");
            if (gfsCtx.Deny()) {
                return this;
            }
            this.RegDir(io_url, string2, bl, string3, string4);
        } else if (gfsCtx.Match(string, Invk_RegObj)) {
            String string5 = gfoMsg.ReadStr("key");
            String string6 = gfoMsg.ReadStr("val");
            String string7 = gfoMsg.ReadStrOr("type", "string");
            if (gfsCtx.Deny()) {
                return this;
            }
            this.RegObjByType(string5, string6, string7);
        } else {
            return Gfo_invk_.Rv_unhandled;
        }
        return this;
    }

    void RegItm(String string, Object object, int n, Io_url io_url) {
        this.hash.Add_if_dupe_use_nth(string, new GfoRegyItm(string, object, n, io_url));
    }

    GfoRegy() {
    }

    @Internal
    protected static GfoRegy new_() {
        return new GfoRegy();
    }
}

