/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.caches;

import gplx.Bry_bfr;
import gplx.Hash_adp;
import gplx.Hash_adp_;
import gplx.core.caches.Lru_cache_root;
import gplx.core.caches.Lru_node;

public class Lru_cache {
    private final Hash_adp map = Hash_adp_.New();
    private Lru_node head;
    private Lru_node tail;
    private long cur;
    private long min;
    private long max;
    private long evicts;
    private final String key;

    public Lru_cache(boolean bl, String string, long l, long l2) {
        this.key = string;
        this.min = l;
        this.max = l2;
        if (bl) {
            Lru_cache_root.Instance.Add(this);
        }
    }

    public String Key() {
        return this.key;
    }

    public long Evicts() {
        return this.evicts;
    }

    public long Cur() {
        return this.cur;
    }

    public void Min_max_(long l, long l2) {
        this.min = l;
        this.max = l2;
    }

    public Object Get_or_null(Object object) {
        Lru_node lru_node = (Lru_node)this.map.Get_by(object);
        if (lru_node == null) {
            return null;
        }
        this.Del_node_from_linked_list(lru_node);
        this.Add_to_tail(lru_node);
        return lru_node.Val();
    }

    public void Set(Object object, Object object2, long l) {
        Lru_node lru_node = (Lru_node)this.map.Get_by(object);
        if (lru_node != null) {
            lru_node.Val_(object2);
            this.Del_node_from_linked_list(lru_node);
            this.Add_to_tail(lru_node);
        } else {
            this.Clear_min(l);
            lru_node = new Lru_node(object, object2, l);
            this.Add_to_tail(lru_node);
            this.map.Add(object, lru_node);
            this.cur += l;
        }
    }

    public void Del(Object object) {
        Lru_node lru_node = (Lru_node)this.map.Get_by(object);
        if (lru_node != null) {
            this.Del_node_from_this(lru_node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Clear_all() {
        Hash_adp hash_adp = this.map;
        synchronized (hash_adp) {
            this.map.Clear();
            this.head = null;
            this.tail = null;
            this.cur = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Clear_min(long l) {
        Hash_adp hash_adp = this.map;
        synchronized (hash_adp) {
            long l2;
            long l3 = l2 = this.min >= 0L ? this.min : this.max;
            while (this.cur + l > l2) {
                this.Del_node_from_this(this.head);
                ++this.evicts;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Del_node_from_this(Lru_node lru_node) {
        Hash_adp hash_adp = this.map;
        synchronized (hash_adp) {
            this.map.Del(lru_node.Key());
            this.cur -= lru_node.Size();
            this.Del_node_from_linked_list(lru_node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Del_node_from_linked_list(Lru_node lru_node) {
        Hash_adp hash_adp = this.map;
        synchronized (hash_adp) {
            if (lru_node.Prv() == null) {
                this.head = lru_node.Nxt();
            } else {
                lru_node.Prv().Nxt_(lru_node.Nxt());
            }
            if (lru_node.Nxt() == null) {
                this.tail = lru_node.Prv();
            } else {
                lru_node.Nxt().Prv_(lru_node.Prv());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Add_to_tail(Lru_node lru_node) {
        Hash_adp hash_adp = this.map;
        synchronized (hash_adp) {
            if (this.tail != null) {
                this.tail.Nxt_(lru_node);
            }
            lru_node.Prv_(this.tail);
            lru_node.Nxt_(null);
            this.tail = lru_node;
            if (this.head == null) {
                this.head = this.tail;
            }
        }
    }

    public void To_str(Bry_bfr bry_bfr, boolean bl) {
        bry_bfr.Add_str_a7("g");
        bry_bfr.Add_byte_pipe().Add_str_u8(this.key);
        bry_bfr.Add_byte_pipe().Add_long_variable(this.cur);
        bry_bfr.Add_byte_pipe().Add_long_variable(this.min);
        bry_bfr.Add_byte_pipe().Add_long_variable(this.max);
        bry_bfr.Add_byte_nl();
        if (bl) {
            for (Lru_node lru_node = this.head; lru_node != null; lru_node = lru_node.Nxt()) {
                lru_node.To_str(bry_bfr);
            }
        }
    }
}

