/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.brys;

import gplx.Array_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Err_;
import gplx.Int_;
import gplx.Int_ary_;
import gplx.Internal;

public class Bry_bfr_mkr_mgr {
    private final Object thread_lock = new Object();
    private final byte mgr_id;
    private final int reset;
    private Bry_bfr[] used = Bry_bfr_.Ary_empty;
    private int used_len = 0;
    private int used_max = 0;
    private int[] free;
    private int free_len;

    public Bry_bfr_mkr_mgr(byte by, int n) {
        this.mgr_id = by;
        this.reset = n;
        this.free = Int_ary_.Empty;
        this.free_len = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bry_bfr Get() {
        Object object = this.thread_lock;
        synchronized (object) {
            Bry_bfr bry_bfr = null;
            int n = -1;
            if (this.free_len > 0) {
                try {
                    n = this.free[--this.free_len];
                }
                catch (Exception exception) {
                    throw Err_.new_exc(exception, "core", "failed to get free", "idx", this.free_len, "free_len", this.free.length);
                }
                try {
                    bry_bfr = this.used[n];
                }
                catch (Exception exception) {
                    throw Err_.new_exc(exception, "core", "failed to get used", "idx", n, "used_len", this.used.length);
                }
            }
            if (this.used_len == this.used_max) {
                this.Expand();
            }
            if ((bry_bfr = this.used[n = this.used_len++]) == null) {
                this.used[n] = bry_bfr = Bry_bfr_.Reset(this.reset);
            }
            bry_bfr.Mkr_init(this, n);
            return bry_bfr.Clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Rls(int n) {
        Object object = this.thread_lock;
        synchronized (object) {
            if (n == -1) {
                throw Err_.new_wo_type("rls called on bfr that was not created by factory", new Object[0]);
            }
            int n2 = this.used_len - 1;
            if (n == n2) {
                this.used_len = n2;
            } else {
                this.free[this.free_len++] = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Clear_fail_check() {
        Object object = this.thread_lock;
        synchronized (object) {
            for (int i = 0; i < this.used_max; ++i) {
                Bry_bfr bry_bfr = this.used[i];
                if (bry_bfr != null) {
                    if (!bry_bfr.Mkr_idx_is_null()) {
                        throw Err_.new_wo_type("failed to clear bfr", "mgr_id", this.mgr_id, "idx", Int_.To_str(i));
                    }
                    bry_bfr.Clear();
                }
                this.used[i] = null;
            }
            this.used = Bry_bfr_.Ary_empty;
            this.free = Int_ary_.Empty;
            this.used_max = 0;
            this.used_len = 0;
            this.free_len = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Clear() {
        Object object = this.thread_lock;
        synchronized (object) {
            for (int i = 0; i < this.used_max; ++i) {
                Bry_bfr bry_bfr = this.used[i];
                if (bry_bfr != null) {
                    bry_bfr.Clear();
                }
                this.used[i] = null;
            }
            this.used = Bry_bfr_.Ary_empty;
            this.free = Int_ary_.Empty;
            this.free_len = 0;
            this.used_max = 0;
            this.used_len = 0;
        }
    }

    @Internal
    protected Bry_bfr[] Used() {
        return this.used;
    }

    @Internal
    protected int Used_len() {
        return this.used_len;
    }

    private void Expand() {
        int n = this.used_max == 0 ? 2 : this.used_max * 2;
        Bry_bfr[] bry_bfrArray = new Bry_bfr[n];
        Array_.Copy_to(this.used, 0, bry_bfrArray, 0, this.used_max);
        this.used = bry_bfrArray;
        this.used_max = n;
        int[] nArray = new int[this.used_max];
        Array_.Copy_to(this.free, 0, nArray, 0, this.free_len);
        this.free = nArray;
    }
}

