/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.Array_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.GfsCtx;
import gplx.Internal;
import gplx.List_adp;
import gplx.Object_;
import gplx.RandomAdp;
import gplx.RandomAdp_;
import gplx.Virtual;
import gplx.core.lists.ComparerAble;
import gplx.core.lists.Iterator_null;
import gplx.core.lists.Iterator_objAry;
import gplx.core.lists.List_adp_sorter;
import java.util.Iterator;

public abstract class List_adp_base
implements List_adp,
Gfo_invk {
    private Object[] list;
    private int count;
    private static final int Len_initial = 8;
    private static final String Invk_len = "len";
    private static final String Invk_get_at = "get_at";

    public List_adp_base(int n) {
        this.list = new Object[n];
    }

    public Iterator iterator() {
        if (this.count == 0) {
            return Iterator_null.Instance;
        }
        return new Iterator_objAry(this.list, this.count);
    }

    @Override
    public void Add_many(Object ... objectArray) {
        for (Object object : objectArray) {
            this.Add_base(object);
        }
    }

    @Override
    public int Len() {
        return this.count;
    }

    @Override
    public int Count() {
        return this.count;
    }

    @Override
    public int Idx_last() {
        return this.count - 1;
    }

    protected Object Get_at_base(int n) {
        if (n >= this.count || n < 0) {
            throw Err_.new_missing_idx(n, this.count);
        }
        return this.list[n];
    }

    protected void Add_base(Object object) {
        if (this.count == Array_.Len_obj(this.list)) {
            this.Resize_expand();
        }
        this.list[this.count] = object;
        ++this.count;
    }

    protected int Del_base(Object object) {
        int n = this.IndexOf_base(object);
        if (n == -1) {
            return -1;
        }
        this.Del_at(n);
        return n;
    }

    @Override
    public void Del_range(int n, int n2) {
        this.BoundsChk(n, n2, this.count);
        if (n == 0 && n2 == this.count - 1) {
            this.Clear();
            return;
        }
        int n3 = n2 - n + 1;
        int n4 = this.count - n3;
        Object[] objectArray = new Object[n4];
        if (n != 0) {
            Array_.Copy_to(this.list, 0, objectArray, 0, n);
        }
        if (n2 != this.count - 1) {
            Array_.Copy_to(this.list, n2 + 1, objectArray, n, n4 - n);
        }
        this.list = objectArray;
        this.count = this.list.length;
    }

    protected int IndexOf_base(Object object) {
        for (int i = 0; i < this.count; ++i) {
            if (!Object_.Eq(this.list[i], object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    @Virtual
    public void Clear() {
        for (int i = 0; i < this.count; ++i) {
            this.list[i] = null;
        }
        this.count = 0;
    }

    @Override
    @Virtual
    public void Del_at(int n) {
        if (n >= this.count || n < 0) {
            throw Err_.new_missing_idx(n, this.count);
        }
        this.Collapse(n);
        --this.count;
    }

    @Override
    public void Move_to(int n, int n2) {
        if (n >= this.count || n < 0) {
            throw Err_.new_missing_idx(n, this.count);
        }
        if (n2 >= this.count || n2 < 0) {
            throw Err_.new_missing_idx(n2, this.count);
        }
        if (n == n2) {
            return;
        }
        Object object = this.list[n];
        int n3 = n2 > n ? 1 : -1;
        for (int i = n; i != n2; i += n3) {
            this.list[i] = this.list[i + n3];
        }
        this.list[n2] = object;
    }

    protected void AddAt_base(int n, Object object) {
        if (this.count + 1 >= Array_.Len_obj(this.list)) {
            this.Resize_expand();
        }
        for (int i = this.count; i > n; --i) {
            this.list[i] = this.list[i - 1];
        }
        this.list[n] = object;
        ++this.count;
    }

    @Override
    public void Resize_bounds(int n) {
        this.Resize_expand(n);
    }

    @Override
    public void Sort() {
        this.Sort_by(null);
    }

    @Override
    public void Sort_by(ComparerAble comparerAble) {
        List_adp_sorter.new_().Sort(this.list, this.count, true, comparerAble);
    }

    @Override
    public void Reverse() {
        int n = this.count / 2;
        for (int i = 0; i < n; ++i) {
            int n2 = this.count - i - 1;
            Object object = this.list[i];
            this.list[i] = this.list[n2];
            this.list[n2] = object;
        }
    }

    @Override
    @Virtual
    public void Shuffle() {
        RandomAdp randomAdp = RandomAdp_.new_();
        for (int i = this.count; i > 1; --i) {
            int n = randomAdp.Next(i);
            Object object = this.list[n];
            this.list[n] = this.list[i - 1];
            this.list[i - 1] = object;
        }
    }

    @Override
    public Object Get_at(int n) {
        return this.Get_at_base(n);
    }

    @Override
    public Object Get_at_last() {
        if (this.count == 0) {
            throw Err_.new_invalid_op("cannot call Get_at_last on empty list");
        }
        return this.Get_at_base(this.count - 1);
    }

    @Override
    public void Add(Object object) {
        this.Add_base(object);
    }

    @Override
    public void Add_at(int n, Object object) {
        this.AddAt_base(n, object);
    }

    @Override
    public void Del(Object object) {
        this.Del_base(object);
    }

    @Override
    public int Idx_of(Object object) {
        return this.IndexOf_base(object);
    }

    public List_adp_base() {
        this.list = new Object[8];
    }

    @Override
    public Object To_ary_and_clear(Class<?> clazz) {
        Object object = this.To_ary(clazz);
        this.Clear();
        return object;
    }

    @Override
    public Object To_ary(Class<?> clazz) {
        Object object = Array_.Create(clazz, this.count);
        for (int i = 0; i < this.count; ++i) {
            Array_.Set_at(object, i, this.list[i]);
        }
        return object;
    }

    @Override
    public String[] To_str_ary_and_clear() {
        String[] stringArray = this.To_str_ary();
        this.Clear();
        return stringArray;
    }

    @Override
    public String[] To_str_ary() {
        return (String[])this.To_ary(String.class);
    }

    @Override
    public Object[] To_obj_ary() {
        Object[] objectArray = new Object[this.count];
        for (int i = 0; i < this.count; ++i) {
            objectArray[i] = this.list[i];
        }
        return objectArray;
    }

    @Override
    public String To_str() {
        Bry_bfr bry_bfr = Bry_bfr_.New();
        for (int i = 0; i < this.count; ++i) {
            bry_bfr.Add_str_u8(Object_.Xto_str_strict_or_null_mark(this.list[i])).Add_byte_nl();
        }
        return bry_bfr.To_str_and_clear();
    }

    private void BoundsChk(int n, int n2, int n3) {
        if (n >= 0 && n < n3 && n2 >= 0 && n2 < n3 && n <= n2) {
            return;
        }
        throw Err_.new_wo_type("bounds check failed", "bgn", n, "end", n2, Invk_len, n3);
    }

    void Resize_expand() {
        this.Resize_expand(this.count * 2);
    }

    void Resize_expand(int n) {
        Object[] objectArray = new Object[n];
        for (int i = 0; i < this.count; ++i) {
            objectArray[i] = this.list[i];
            this.list[i] = null;
        }
        this.list = objectArray;
    }

    void Collapse(int n) {
        for (int i = n; i < this.count; ++i) {
            this.list[i] = i == this.count - 1 ? null : this.list[i + 1];
        }
    }

    @Internal
    protected int Capacity() {
        return Array_.Len_obj(this.list);
    }

    @Override
    public Object Invk(GfsCtx gfsCtx, int n, String string, GfoMsg gfoMsg) {
        if (gfsCtx.Match(string, Invk_len)) {
            return this.count;
        }
        if (gfsCtx.Match(string, Invk_get_at)) {
            return this.Get_at(gfoMsg.ReadInt("v"));
        }
        return Gfo_invk_.Rv_unhandled;
    }
}

