/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Datetime_now;
import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk_;
import gplx.Gfo_usr_dlg__log;
import gplx.GfsCtx;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Ordered_hash;
import gplx.Ordered_hash_;
import gplx.String_;
import gplx.Usr_log_fil;
import gplx.core.brys.fmtrs.Bry_fmtr;
import gplx.core.strings.String_bldr;
import gplx.core.strings.String_bldr_;

public class Gfo_usr_dlg__log_base
implements Gfo_usr_dlg__log {
    private int archive_dirs_max = 8;
    private Io_url log_dir;
    private Io_url err_fil;
    private final Ordered_hash queued_list = Ordered_hash_.New();
    private final Bry_fmtr fmtr = Bry_fmtr.New__tmp();
    private final Bry_bfr tmp_bfr = Bry_bfr_.Reset(255);
    private boolean queue_enabled;
    private boolean enabled = true;
    private Io_url session_dir;
    private Io_url session_fil;
    private String_bldr sb = String_bldr_.new_thread();
    public static final Gfo_usr_dlg__log_base Instance = new Gfo_usr_dlg__log_base();

    public boolean Queue_enabled() {
        return this.queue_enabled;
    }

    @Override
    public void Queue_enabled_(boolean bl) {
        this.queue_enabled = bl;
        if (!bl) {
            this.Flush();
        }
    }

    @Override
    public boolean Enabled() {
        return this.enabled;
    }

    @Override
    public void Enabled_(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public Io_url Session_dir() {
        return this.session_dir;
    }

    @Override
    public Io_url Session_fil() {
        return this.session_fil;
    }

    private void Flush() {
        int n = this.queued_list.Count();
        for (int i = 0; i < n; ++i) {
            Usr_log_fil usr_log_fil = (Usr_log_fil)this.queued_list.Get_at(i);
            if (usr_log_fil.Url() == null) {
                usr_log_fil.Url_(this.session_dir.GenSubFil("session.txt"));
            }
            usr_log_fil.Flush(this.enabled);
        }
    }

    @Override
    public Io_url Log_dir() {
        return this.log_dir;
    }

    @Override
    public void Log_dir_(Io_url io_url) {
        this.log_dir = io_url;
        if (this.enabled) {
            this.session_dir = io_url.GenSubDir(Datetime_now.Get().XtoStr_fmt_yyyyMMdd_HHmmss_fff());
            this.session_fil = this.session_dir.GenSubFil("session.txt");
            this.err_fil = this.session_dir.GenSubFil("err.txt");
        }
    }

    @Override
    public void Log_term() {
        if (!this.enabled) {
            Io_mgr.Instance.DeleteDirDeep(this.log_dir);
            return;
        }
        Io_url[] io_urlArray = Io_mgr.Instance.QueryDir_args(this.log_dir).DirInclude_().DirOnly_().ExecAsUrlAry();
        int n = io_urlArray.length;
        int n2 = n - this.archive_dirs_max;
        for (int i = 0; i < n2; ++i) {
            Io_url io_url = io_urlArray[i];
            Io_mgr.Instance.DeleteDirDeep(io_url);
            this.Log_to_session("archive dir del: " + this.session_dir.Raw());
        }
        this.Log_to_session("app term");
    }

    public void Log_info(boolean bl, String string) {
        if (bl) {
            this.Log_to_err(string);
        } else {
            this.Log_to_session(string);
        }
    }

    @Override
    public void Log_msg_to_url_fmt(Io_url io_url, String string, Object ... objectArray) {
        if (!this.enabled) {
            return;
        }
        String string2 = this.Bld_msg(String_.new_u8(this.fmtr.Fmt_(string).Bld_bry_many(this.tmp_bfr, objectArray)));
        this.Log_msg(io_url, string2);
        this.Log_msg(this.session_fil, string2);
    }

    @Override
    public void Log_to_session_fmt(String string, Object ... objectArray) {
        this.Log_to_session(String_.new_u8(this.fmtr.Fmt_(string).Bld_bry_many(this.tmp_bfr, objectArray)));
    }

    @Override
    public void Log_to_session(String string) {
        if (!this.enabled) {
            return;
        }
        String string2 = this.Bld_msg(string);
        this.Log_msg(this.session_fil, string2);
    }

    @Override
    public void Log_to_session_direct(String string) {
        if (!this.enabled) {
            return;
        }
        this.Log_msg(this.session_fil, string);
    }

    @Override
    public void Log_to_err(String string) {
        if (!this.enabled) {
            return;
        }
        try {
            String string2 = this.Bld_msg(string);
            this.Log_msg(this.session_fil, string2);
            this.Log_msg(this.err_fil, string2);
        }
        catch (Exception exception) {
            Err_.Noop(exception);
        }
    }

    private String Bld_msg(String string) {
        return this.sb.Add(Datetime_now.Get_force().XtoUtc().XtoStr_fmt_yyyyMMdd_HHmmss_fff()).Add(" ").Add(string).Add_char_nl().To_str_and_clear();
    }

    private void Log_msg(Io_url io_url, String string) {
        if (this.queue_enabled) {
            String string2 = io_url == null ? "mem" : io_url.Raw();
            Usr_log_fil usr_log_fil = (Usr_log_fil)this.queued_list.Get_by(string2);
            if (usr_log_fil == null) {
                usr_log_fil = new Usr_log_fil(io_url);
                this.queued_list.Add(string2, usr_log_fil);
            }
            usr_log_fil.Add(string);
        } else if (this.enabled) {
            Io_mgr.Instance.AppendFilStr(io_url, string);
        }
    }

    @Override
    public Object Invk(GfsCtx gfsCtx, int n, String string, GfoMsg gfoMsg) {
        if (gfsCtx.Match(string, "enabled_")) {
            this.enabled = gfoMsg.ReadYn("v");
        } else if (gfsCtx.Match(string, "archive_dirs_max_")) {
            this.archive_dirs_max = gfoMsg.ReadInt("v");
        } else if (gfsCtx.Match(string, "log_dir_")) {
            this.log_dir = gfoMsg.ReadIoUrl("v");
        } else {
            return Gfo_invk_.Rv_unhandled;
        }
        return this;
    }
}

