/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.Decimal_adp;
import gplx.Err_;
import gplx.Float_;
import gplx.Math_;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class Decimal_adp_ {
    public static final String Cls_val_name = "decimal";
    public static final Class<?> Cls_ref_type = Decimal_adp.class;
    public static final Decimal_adp Zero = new Decimal_adp(0);
    public static final Decimal_adp One = new Decimal_adp(1);
    public static final Decimal_adp Neg1 = new Decimal_adp(-1);
    public static final Decimal_adp Const_e = Decimal_adp_.double_(Math_.E);
    public static final Decimal_adp Const_pi = Decimal_adp_.double_(Math_.Pi);
    public static final MathContext RoundDownContext = new MathContext(0, RoundingMode.DOWN);
    public static final MathContext Gplx_rounding_context = new MathContext(14, RoundingMode.HALF_UP);

    public static Decimal_adp as_(Object object) {
        return object instanceof Decimal_adp ? (Decimal_adp)object : null;
    }

    public static Decimal_adp base1000_(long l) {
        return Decimal_adp_.divide_(l, 1000L);
    }

    public static Decimal_adp parts_1000_(long l, int n) {
        return Decimal_adp_.divide_(l * 1000L + (long)n, 1000L);
    }

    public static Decimal_adp parts_(long l, int n) {
        int n2 = Decimal_adp_.XtoPow10(n);
        return Decimal_adp_.divide_(l * (long)n2 + (long)n, n2);
    }

    public static Decimal_adp cast(Object object) {
        return (Decimal_adp)object;
    }

    static int XtoPow10(int n) {
        if (n > -1 && n < 10) {
            return 10;
        }
        if (n > 9 && n < 100) {
            return 100;
        }
        if (n > 99 && n < 1000) {
            return 1000;
        }
        if (n > 999 && n < 10000) {
            return 10000;
        }
        if (n > 9999 && n < 100000) {
            return 100000;
        }
        if (n > 99999 && n < 1000000) {
            return 1000000;
        }
        if (n > 999999 && n < 10000000) {
            return 10000000;
        }
        if (n > 9999999 && n < 100000000) {
            return 100000000;
        }
        if (n > 99999999 && n < 1000000000) {
            return 1000000000;
        }
        throw Err_.new_wo_type("value must be between 0 and 1 billion", "v", n);
    }

    public static String CalcPctStr(long l, long l2, String string) {
        if (l2 == 0L) {
            return "%ERR";
        }
        return Decimal_adp_.float_(Float_.Div(l, l2) * 100.0f).To_str(string) + "%";
    }

    public static Decimal_adp divide_safe_(long l, long l2) {
        return l2 == 0L ? Zero : Decimal_adp_.divide_(l, l2);
    }

    public static Decimal_adp divide_(long l, long l2) {
        return new Decimal_adp(new BigDecimal(l).divide(new BigDecimal(l2), Gplx_rounding_context));
    }

    public static Decimal_adp int_(int n) {
        return new Decimal_adp(new BigDecimal(n));
    }

    public static Decimal_adp long_(long l) {
        return new Decimal_adp(new BigDecimal(l));
    }

    public static Decimal_adp float_(float f) {
        return new Decimal_adp(new BigDecimal(f));
    }

    public static Decimal_adp double_(double d) {
        return new Decimal_adp(new BigDecimal(d));
    }

    public static Decimal_adp double_thru_str_(double d) {
        return new Decimal_adp(BigDecimal.valueOf(d));
    }

    public static Decimal_adp db_(Object object) {
        return new Decimal_adp((BigDecimal)object);
    }

    public static Decimal_adp parse(String string) {
        try {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
            decimalFormat.setParseBigDecimal(true);
            BigDecimal bigDecimal = (BigDecimal)decimalFormat.parse(string);
            return new Decimal_adp(bigDecimal);
        }
        catch (ParseException parseException) {
            throw Err_.new_("Decimal_adp_", "parse to decimal failed", "raw", string);
        }
    }

    public static Decimal_adp pow_10_(int n) {
        return new Decimal_adp(new BigDecimal(1).scaleByPowerOfTen(n));
    }
}

