/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.Bool_;
import gplx.Bry_;
import gplx.Bry_find_;
import gplx.Byte_;
import gplx.Byte_ascii;
import gplx.DateAdp;
import gplx.Double_;
import gplx.Err_;
import gplx.Float_;
import gplx.Int_;
import gplx.Io_url;
import gplx.Long_;
import gplx.Object_;
import gplx.String_;
import gplx.core.brys.Bfr_arg;
import gplx.core.brys.Bry_bfr_mkr_mgr;
import gplx.core.encoders.Base85_;
import gplx.core.intls.Utf16_;
import gplx.core.primitives.Bry_obj_ref;
import gplx.core.primitives.Int_list;

public class Bry_bfr {
    private Bry_bfr_mkr_mgr mkr_mgr;
    private int reset;
    private byte[] bfr;
    private int bfr_len;
    private static final boolean[] Trim_end_ws_ary = Bry_bfr.Trim_end_ws_new();
    private int mkr_idx = -1;
    private int bfr_max;

    public byte[] Bfr() {
        return this.bfr;
    }

    public int Len() {
        return this.bfr_len;
    }

    public boolean Len_eq_0() {
        return this.bfr_len == 0;
    }

    public boolean Len_gt_0() {
        return this.bfr_len > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Bfr_init(byte[] byArray, int n) {
        Bry_bfr bry_bfr = this;
        synchronized (bry_bfr) {
            this.bfr = byArray;
            this.bfr_len = n;
            this.bfr_max = byArray.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bry_bfr Mkr_rls() {
        if (this.mkr_mgr != null) {
            Bry_bfr bry_bfr = this;
            synchronized (bry_bfr) {
                this.mkr_mgr.Rls(this.mkr_idx);
                this.mkr_mgr = null;
                this.mkr_idx = -1;
            }
        }
        return this;
    }

    public void Clear_and_rls() {
        this.Clear();
        this.Mkr_rls();
    }

    public String To_str_and_rls() {
        return String_.new_u8(this.To_bry_and_rls());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] To_bry_and_rls() {
        byte[] byArray = null;
        byte[] byArray2 = this.bfr;
        synchronized (this.bfr) {
            byArray = this.To_bry();
            this.Clear();
            if (this.reset > 0) {
                this.Reset_if_gt(this.reset);
            }
            Bry_bfr bry_bfr = this;
            synchronized (bry_bfr) {
                this.mkr_mgr.Rls(this.mkr_idx);
                this.mkr_idx = -1;
                this.mkr_mgr = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return byArray;
        }
    }

    public Bry_bfr Reset_(int n) {
        this.reset = n;
        return this;
    }

    public Bry_bfr Reset_if_gt(int n) {
        if (this.bfr_max > n) {
            this.bfr_max = n;
            this.bfr = new byte[n];
        }
        this.bfr_len = 0;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bry_bfr Clear() {
        Bry_bfr bry_bfr = this;
        synchronized (bry_bfr) {
            this.bfr_len = 0;
        }
        return this;
    }

    public Bry_bfr ClearAndReset() {
        this.bfr_len = 0;
        if (this.reset > 0) {
            this.Reset_if_gt(this.reset);
        }
        return this;
    }

    public byte Get_at_last_or_nil_if_empty() {
        return this.bfr_len == 0 ? (byte)0 : this.bfr[this.bfr_len - 1];
    }

    public Bry_bfr Add_safe(byte[] byArray) {
        return byArray == null ? this : this.Add(byArray);
    }

    public Bry_bfr Add(byte[] byArray) {
        int n = byArray.length;
        if (this.bfr_len + n > this.bfr_max) {
            this.Resize((this.bfr_max + n) * 2);
        }
        Bry_.Copy_to(byArray, 0, n, this.bfr, this.bfr_len);
        this.bfr_len += n;
        return this;
    }

    public Bry_bfr Add_mid(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw Err_.new_wo_type("negative len", "bgn", n, "end", n2, "excerpt", String_.new_u8__by_len(byArray, n, n + 16));
        }
        if (this.bfr_len + n3 > this.bfr_max) {
            this.Resize((this.bfr_max + n3) * 2);
        }
        Bry_.Copy_to(byArray, n, n2, this.bfr, this.bfr_len);
        this.bfr_len += n3;
        return this;
    }

    public Bry_bfr Add_reverse_mid(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw Err_.new_wo_type("negative len", "bgn", n, "end", n2, "excerpt", String_.new_u8__by_len(byArray, n, n + 16));
        }
        if (this.bfr_len + n3 > this.bfr_max) {
            this.Resize((this.bfr_max + n3) * 2);
        }
        Bry_.Copy_to_reversed(byArray, n, n2, this.bfr, this.bfr_len);
        this.bfr_len += n3;
        return this;
    }

    public Bry_bfr Add_mid_w_swap(byte[] byArray, int n, int n2, byte by, byte by2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw Err_.new_wo_type("negative len", "bgn", n, "end", n2, "excerpt", String_.new_u8__by_len(byArray, n, n + 16));
        }
        if (this.bfr_len + n3 > this.bfr_max) {
            this.Resize((this.bfr_max + n3) * 2);
        }
        int n4 = n2 - n;
        for (int i = 0; i < n4; ++i) {
            byte by3 = byArray[i + n];
            if (by3 == by) {
                by3 = by2;
            }
            this.bfr[i + this.bfr_len] = by3;
        }
        this.bfr_len += n3;
        return this;
    }

    public Bry_bfr Add_bry_ref_obj(Bry_obj_ref bry_obj_ref) {
        bry_obj_ref.Bfr_arg__add(this);
        return this;
    }

    public Bry_bfr Add_bfr_and_preserve(Bry_bfr bry_bfr) {
        int n = bry_bfr.bfr_len;
        if (this.bfr_len + n > this.bfr_max) {
            this.Resize((this.bfr_max + n) * 2);
        }
        Bry_.Copy_to(bry_bfr.bfr, 0, n, this.bfr, this.bfr_len);
        this.bfr_len += n;
        return this;
    }

    public Bry_bfr Add_bfr_and_clear(Bry_bfr bry_bfr) {
        this.Add_bfr_and_preserve(bry_bfr);
        bry_bfr.ClearAndReset();
        return this;
    }

    public Bry_bfr Add_bfr_or_mid(boolean bl, Bry_bfr bry_bfr, byte[] byArray, int n, int n2) {
        return bl ? this.Add_bfr_and_clear(bry_bfr) : this.Add_mid(byArray, n, n2);
    }

    public Bry_bfr Add_bfr_trim_and_clear(Bry_bfr bry_bfr, boolean bl, boolean bl2) {
        return this.Add_bfr_trim_and_clear(bry_bfr, bl, bl2, Bry_.Trim_ary_ws);
    }

    public Bry_bfr Add_bfr_trim_and_clear(Bry_bfr bry_bfr, boolean bl, boolean bl2, byte[] byArray) {
        byte by;
        int n;
        int n2 = bry_bfr.bfr_len;
        if (this.bfr_len + n2 > this.bfr_max) {
            this.Resize((this.bfr_max + n2) * 2);
        }
        byte[] byArray2 = bry_bfr.Bfr();
        int n3 = 0;
        int n4 = n2;
        boolean bl3 = true;
        if (bl) {
            for (n = 0; n < n2; ++n) {
                by = byArray2[n];
                if (byArray[by & 0xFF] != 0) continue;
                n3 = n;
                n = n2;
                bl3 = false;
            }
            if (bl3) {
                return this;
            }
        }
        if (bl2) {
            for (n = n2 - 1; n > -1; --n) {
                by = byArray2[n];
                if (byArray[by & 0xFF] != 0) continue;
                n4 = n + 1;
                n = -1;
                bl3 = false;
            }
            if (bl3) {
                return this;
            }
        }
        n2 = n4 - n3;
        Bry_.Copy_to(bry_bfr.bfr, n3, n4, this.bfr, this.bfr_len);
        this.bfr_len += n2;
        bry_bfr.Clear();
        return this;
    }

    public Bry_bfr Add_byte_as_a7(byte by) {
        return this.Add_byte((byte)(by + 48));
    }

    public Bry_bfr Add_byte_eq() {
        return this.Add_byte((byte)61);
    }

    public Bry_bfr Add_byte_pipe() {
        return this.Add_byte((byte)124);
    }

    public Bry_bfr Add_byte_comma() {
        return this.Add_byte((byte)44);
    }

    public Bry_bfr Add_byte_semic() {
        return this.Add_byte((byte)59);
    }

    public Bry_bfr Add_byte_apos() {
        return this.Add_byte((byte)39);
    }

    public Bry_bfr Add_byte_slash() {
        return this.Add_byte((byte)47);
    }

    public Bry_bfr Add_byte_backslash() {
        return this.Add_byte((byte)92);
    }

    public Bry_bfr Add_byte_quote() {
        return this.Add_byte((byte)34);
    }

    public Bry_bfr Add_byte_space() {
        return this.Add_byte((byte)32);
    }

    public Bry_bfr Add_byte_nl() {
        return this.Add_byte((byte)10);
    }

    public Bry_bfr Add_byte_dot() {
        return this.Add_byte((byte)46);
    }

    public Bry_bfr Add_byte_colon() {
        return this.Add_byte((byte)58);
    }

    public Bry_bfr Add_byte(byte by) {
        int n = this.bfr_len + 1;
        if (n > this.bfr_max) {
            this.Resize(this.bfr_len * 2);
        }
        this.bfr[this.bfr_len] = by;
        this.bfr_len = n;
        return this;
    }

    public Bry_bfr Add_byte_repeat(byte by, int n) {
        if (this.bfr_len + n > this.bfr_max) {
            this.Resize((this.bfr_max + n) * 2);
        }
        for (int i = 0; i < n; ++i) {
            this.bfr[i + this.bfr_len] = by;
        }
        this.bfr_len += n;
        return this;
    }

    public Bry_bfr Add_byte_if_not_last(byte by) {
        if (this.bfr_len == 0 || this.bfr_len > 0 && this.bfr[this.bfr_len - 1] == by) {
            return this;
        }
        this.Add_byte(by);
        return this;
    }

    public Bry_bfr Add_byte_variable(byte by) {
        return this.Add_int_variable(by);
    }

    public Bry_bfr Add_short_variable(short s) {
        return this.Add_int_variable(s);
    }

    public Bry_bfr Add_u8_int(int n) {
        if (this.bfr_len + 4 > this.bfr_max) {
            this.Resize((this.bfr_max + 4) * 2);
        }
        int n2 = Utf16_.Encode_int(n, this.bfr, this.bfr_len);
        this.bfr_len += n2;
        return this;
    }

    public Bry_bfr Add_bool(boolean bl) {
        return this.Add(bl ? Bool_.True_bry : Bool_.False_bry);
    }

    public Bry_bfr Add_int_bool(boolean bl) {
        return this.Add_int_fixed(bl ? 1 : 0, 1);
    }

    public Bry_bfr Add_int_variable(int n) {
        if (n < 0) {
            this.Add(Int_.To_bry(n));
            return this;
        }
        int n2 = Int_.Log10(n);
        int n3 = n > -1 ? n2 + 1 : n2 * -1 + 2;
        return this.Add_int(n, n2, n3);
    }

    public Bry_bfr Add_int_pad_bgn(byte by, int n, int n2) {
        int n3 = Int_.DigitCount(n2);
        int n4 = n - n3;
        if (n4 > 0) {
            this.Add_byte_repeat(by, n4);
        }
        this.Add_int_fixed(n2, n3);
        return this;
    }

    public Bry_bfr Add_int_digits(int n, int n2) {
        return this.Add_int(n2, Int_.Log10(n2), n);
    }

    public Bry_bfr Add_int_fixed(int n, int n2) {
        return this.Add_int(n, Int_.Log10(n), n2);
    }

    public Bry_bfr Add_int(int n, int n2, int n3) {
        int n4 = this.bfr_len;
        int n5 = this.bfr_len + n3;
        if (n5 > this.bfr_max) {
            this.Resize(n5 * 2);
        }
        if (n < 0) {
            this.bfr[n4++] = 45;
            n *= -1;
            n2 *= -1;
            --n3;
        }
        if (n2 >= n3) {
            n %= Int_.Log10Ary[n3];
        }
        for (int i = 0; i < n3; ++i) {
            int n6 = n3 - i - 1;
            int n7 = n6 < Int_.Log10AryLen ? Int_.Log10Ary[n6] : Integer.MAX_VALUE;
            this.bfr[n4 + i] = (byte)(n / n7 + 48);
            n %= n7;
        }
        this.bfr_len = n5;
        return this;
    }

    public Bry_bfr Add_long_variable(long l) {
        int n = Long_.DigitCount(l);
        return this.Add_long(l, n, n);
    }

    public Bry_bfr Add_long_fixed(long l, int n) {
        return this.Add_long(l, Long_.DigitCount(l), n);
    }

    protected Bry_bfr Add_long(long l, int n, int n2) {
        int n3 = this.bfr_len;
        int n4 = this.bfr_len + n2;
        if (n4 > this.bfr_max) {
            this.Resize(n4 * 2);
        }
        if (l < 0L) {
            this.bfr[n3++] = 45;
            l *= -1L;
            --n2;
        }
        if (n >= n2) {
            l %= Long_.Log10Ary[n2];
        }
        for (int i = 0; i < n2; ++i) {
            int n5 = n2 - i - 1;
            long l2 = n5 < 21 ? Long_.Log10Ary[n5] : Long.MAX_VALUE;
            this.bfr[n3 + i] = (byte)(l / l2 + 48L);
            l %= l2;
        }
        this.bfr_len = n4;
        return this;
    }

    public Bry_bfr Add_bry_comma(byte[] byArray) {
        return this.Add_bry((byte)44, byArray);
    }

    public Bry_bfr Add_bry(byte by, byte[] byArray) {
        if (byArray == null) {
            return this;
        }
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                this.Add_byte(by);
            }
            this.Add_int_variable(byArray[i]);
        }
        return this;
    }

    public Bry_bfr Add_bry_escape(byte by, byte[] byArray, byte[] byArray2, int n, int n2) {
        boolean bl = true;
        for (int i = n; i < n2; ++i) {
            byte by2 = byArray2[i];
            if (bl) {
                if (by2 != by) continue;
                bl = false;
                this.Add_mid(byArray2, n, i);
                this.Add(byArray);
                continue;
            }
            if (by2 == by) {
                this.Add(byArray);
                continue;
            }
            this.Add_byte(by2);
        }
        if (bl) {
            this.Add_mid(byArray2, n, n2);
        }
        return this;
    }

    public Bry_bfr Add_bry_many(byte[] ... byArray) {
        for (byte[] byArray2 : byArray) {
            if (byArray2 == null || byArray2.length <= 0) continue;
            this.Add(byArray2);
        }
        return this;
    }

    public Bry_bfr Add_bry_escape_html(byte[] byArray) {
        if (byArray == null) {
            return this;
        }
        return this.Add_bry_escape_html(byArray, 0, byArray.length);
    }

    public Bry_bfr Add_bry_escape_html(byte[] byArray, int n, int n2) {
        Bry_.Escape_html(this, false, byArray, n, n2);
        return this;
    }

    public Bry_bfr Add_bry_escape_xml(byte[] byArray, int n, int n2) {
        Bry_.Escape_html(this, true, byArray, n, n2);
        return this;
    }

    public Bry_bfr Add_str_u8_w_nl(String string) {
        this.Add_str_u8(string);
        return this.Add_byte_nl();
    }

    public Bry_bfr Add_str_u8_null(String string) {
        return this.Add_str_u8(string == null ? "<<NULL>>" : string);
    }

    public Bry_bfr Add_str_u8(String string) {
        try {
            int n = string.length();
            int n2 = Bry_.new_u8__by_len(string, n);
            if (this.bfr_len + n2 > this.bfr_max) {
                this.Resize((this.bfr_max + n2) * 2);
            }
            Bry_.new_u8__write(string, n, this.bfr, this.bfr_len);
            this.bfr_len += n2;
            return this;
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "core", "invalid UTF-8 sequence", "s", string);
        }
    }

    public Bry_bfr Add_str_u8_many(String ... stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.Add_str_u8(stringArray[i]);
        }
        return this;
    }

    public Bry_bfr Add_str_u8_fmt(String string, Object ... objectArray) {
        this.Add_str_u8(String_.Format(string, objectArray));
        return this;
    }

    public Bry_bfr Add_str_a7_null(String string) {
        return this.Add_str_a7(string == null ? "<<NULL>>" : string);
    }

    public Bry_bfr Add_str_a7_w_nl(String string) {
        this.Add_str_a7(string);
        return this.Add_byte_nl();
    }

    public Bry_bfr Add_str_a7(String string) {
        try {
            int n = string.length();
            if (this.bfr_len + n > this.bfr_max) {
                this.Resize((this.bfr_max + n) * 2);
            }
            for (int i = 0; i < n; ++i) {
                int n2 = string.charAt(i);
                if (n2 > 128) {
                    n2 = 63;
                }
                this.bfr[i + this.bfr_len] = (byte)n2;
            }
            this.bfr_len += n;
            return this;
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "core", "invalid UTF-8 sequence", "s", string);
        }
    }

    public Bry_bfr Add_str_mid(String string, int n, int n2) {
        this.Add_str_u8(String_.Mid(string, n, n2));
        return this;
    }

    public Bry_bfr Add_kv_dlm(boolean bl, String string, Object object) {
        this.Add_str_a7(string).Add_byte_colon().Add_byte_space();
        this.Add(Bry_.new_u8(Object_.Xto_str_strict_or_null_mark(object)));
        this.Add_byte(bl ? (byte)10 : 9);
        return this;
    }

    public Bry_bfr Add_float(float f) {
        this.Add_str_a7(Float_.To_str(f));
        return this;
    }

    public Bry_bfr Add_double(double d) {
        this.Add_str_a7(Double_.To_str(d));
        return this;
    }

    public Bry_bfr Add_dte(DateAdp dateAdp) {
        return this.Add_dte_segs((byte)32, dateAdp.Year(), dateAdp.Month(), dateAdp.Day(), dateAdp.Hour(), dateAdp.Minute(), dateAdp.Second(), dateAdp.Frac());
    }

    public Bry_bfr Add_dte_under(DateAdp dateAdp) {
        return this.Add_dte_segs((byte)95, dateAdp.Year(), dateAdp.Month(), dateAdp.Day(), dateAdp.Hour(), dateAdp.Minute(), dateAdp.Second(), dateAdp.Frac());
    }

    private Bry_bfr Add_dte_segs(byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.bfr_len + 19 > this.bfr_max) {
            this.Resize((this.bfr_len + 19) * 2);
        }
        this.bfr[this.bfr_len + 0] = (byte)(n / 1000 + 48);
        this.bfr[this.bfr_len + 1] = (byte)((n %= 1000) / 100 + 48);
        this.bfr[this.bfr_len + 2] = (byte)((n %= 100) / 10 + 48);
        this.bfr[this.bfr_len + 3] = (byte)((n %= 10) + 48);
        this.bfr[this.bfr_len + 4] = (byte)(n2 / 10 + 48);
        this.bfr[this.bfr_len + 5] = (byte)((n2 %= 10) + 48);
        this.bfr[this.bfr_len + 6] = (byte)(n3 / 10 + 48);
        this.bfr[this.bfr_len + 7] = (byte)((n3 %= 10) + 48);
        this.bfr[this.bfr_len + 8] = by;
        this.bfr[this.bfr_len + 9] = (byte)(n4 / 10 + 48);
        this.bfr[this.bfr_len + 10] = (byte)((n4 %= 10) + 48);
        this.bfr[this.bfr_len + 11] = (byte)(n5 / 10 + 48);
        this.bfr[this.bfr_len + 12] = (byte)((n5 %= 10) + 48);
        this.bfr[this.bfr_len + 13] = (byte)(n6 / 10 + 48);
        this.bfr[this.bfr_len + 14] = (byte)((n6 %= 10) + 48);
        this.bfr[this.bfr_len + 15] = 46;
        this.bfr[this.bfr_len + 16] = (byte)(n7 / 100 + 48);
        this.bfr[this.bfr_len + 17] = (byte)((n7 %= 100) / 10 + 48);
        this.bfr[this.bfr_len + 18] = (byte)((n7 %= 10) + 48);
        this.bfr_len += 19;
        return this;
    }

    public Bry_bfr Add_dte_utc(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.bfr_len + 20 > this.bfr_max) {
            this.Resize((this.bfr_len + 20) * 2);
        }
        this.bfr[this.bfr_len + 0] = (byte)(n / 1000 + 48);
        this.bfr[this.bfr_len + 1] = (byte)((n %= 1000) / 100 + 48);
        this.bfr[this.bfr_len + 2] = (byte)((n %= 100) / 10 + 48);
        this.bfr[this.bfr_len + 3] = (byte)((n %= 10) + 48);
        this.bfr[this.bfr_len + 4] = 45;
        this.bfr[this.bfr_len + 5] = (byte)(n2 / 10 + 48);
        this.bfr[this.bfr_len + 6] = (byte)((n2 %= 10) + 48);
        this.bfr[this.bfr_len + 7] = 45;
        this.bfr[this.bfr_len + 8] = (byte)(n3 / 10 + 48);
        this.bfr[this.bfr_len + 9] = (byte)((n3 %= 10) + 48);
        this.bfr[this.bfr_len + 10] = 84;
        this.bfr[this.bfr_len + 11] = (byte)(n4 / 10 + 48);
        this.bfr[this.bfr_len + 12] = (byte)((n4 %= 10) + 48);
        this.bfr[this.bfr_len + 13] = 58;
        this.bfr[this.bfr_len + 14] = (byte)(n5 / 10 + 48);
        this.bfr[this.bfr_len + 15] = (byte)((n5 %= 10) + 48);
        this.bfr[this.bfr_len + 16] = 58;
        this.bfr[this.bfr_len + 17] = (byte)(n6 / 10 + 48);
        this.bfr[this.bfr_len + 18] = (byte)((n6 %= 10) + 48);
        this.bfr[this.bfr_len + 19] = 90;
        this.bfr_len += 20;
        return this;
    }

    public Bry_bfr Add_swap_ws(byte[] byArray) {
        return this.Add_swap_ws(byArray, 0, byArray.length);
    }

    public Bry_bfr Add_swap_ws(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (this.bfr_len + n3 * 2 > this.bfr_max) {
            this.Resize((this.bfr_max + n3 * 2) * 2);
        }
        block5: for (int i = n; i < n2; ++i) {
            byte by = byArray[i];
            switch (by) {
                case 10: {
                    this.bfr[this.bfr_len] = 92;
                    this.bfr[this.bfr_len + 1] = 110;
                    this.bfr_len += 2;
                    continue block5;
                }
                case 9: {
                    this.bfr[this.bfr_len] = 92;
                    this.bfr[this.bfr_len + 1] = 116;
                    this.bfr_len += 2;
                    continue block5;
                }
                case 92: {
                    this.bfr[this.bfr_len] = 92;
                    this.bfr[this.bfr_len + 1] = 92;
                    this.bfr_len += 2;
                    continue block5;
                }
                default: {
                    this.bfr[this.bfr_len] = by;
                    ++this.bfr_len;
                }
            }
        }
        return this;
    }

    public Bry_bfr Add_str_pad_space_bgn(String string, int n) {
        return this.Add_str_pad_space(string, n, false);
    }

    public Bry_bfr Add_str_pad_space_end(String string, int n) {
        return this.Add_str_pad_space(string, n, true);
    }

    Bry_bfr Add_str_pad_space(String string, int n, boolean bl) {
        int n2;
        byte[] byArray = Bry_.new_u8(string);
        if (bl) {
            this.Add(byArray);
        }
        if ((n2 = n - byArray.length) > 0) {
            this.Add_byte_repeat((byte)32, n2);
        }
        if (!bl) {
            this.Add(byArray);
        }
        return this;
    }

    public Bry_bfr Add_obj(Object object) {
        if (object == null) {
            return this;
        }
        Class<?> clazz = object.getClass();
        if (clazz == byte[].class) {
            this.Add((byte[])object);
        } else if (clazz == Integer.class) {
            this.Add_int_variable(Int_.Cast(object));
        } else if (clazz == Byte.class) {
            this.Add_byte(Byte_.Cast(object));
        } else if (clazz == Long.class) {
            this.Add_long_variable(Long_.cast(object));
        } else if (clazz == String.class) {
            this.Add_str_u8((String)object);
        } else if (clazz == Bry_bfr.class) {
            this.Add_bfr_and_preserve((Bry_bfr)object);
        } else if (clazz == DateAdp.class) {
            this.Add_dte((DateAdp)object);
        } else if (clazz == Io_url.class) {
            this.Add(((Io_url)object).RawBry());
        } else if (clazz == Boolean.class) {
            this.Add_yn(Bool_.Cast(object));
        } else if (clazz == Double.class) {
            this.Add_double(Double_.cast(object));
        } else if (clazz == Float.class) {
            this.Add_float(Float_.cast(object));
        } else {
            ((Bfr_arg)object).Bfr_arg__add(this);
        }
        return this;
    }

    public Bry_bfr Add_obj_strict(Object object) {
        if (object == null) {
            return this;
        }
        Class<?> clazz = object.getClass();
        if (clazz == byte[].class) {
            this.Add((byte[])object);
        } else if (clazz == Integer.class) {
            this.Add_int_variable(Int_.Cast(object));
        } else if (clazz == Byte.class) {
            this.Add_byte(Byte_.Cast(object));
        } else if (clazz == Long.class) {
            this.Add_long_variable(Long_.cast(object));
        } else if (clazz == String.class) {
            this.Add_str_u8((String)object);
        } else if (clazz == Bry_bfr.class) {
            this.Add_bfr_and_preserve((Bry_bfr)object);
        } else if (clazz == DateAdp.class) {
            this.Add_dte((DateAdp)object);
        } else if (clazz == Io_url.class) {
            this.Add(((Io_url)object).RawBry());
        } else if (clazz == Boolean.class) {
            this.Add_bool(Bool_.Cast(object));
        } else if (clazz == Double.class) {
            this.Add_double(Double_.cast(object));
        } else if (clazz == Float.class) {
            this.Add_float(Float_.cast(object));
        } else {
            ((Bfr_arg)object).Bfr_arg__add(this);
        }
        return this;
    }

    public Bry_bfr Add_yn(boolean bl) {
        this.Add_byte(bl ? (byte)121 : 110);
        return this;
    }

    public Bry_bfr Add_base85_len_5(int n) {
        return this.Add_base85(n, 5);
    }

    public Bry_bfr Add_base85(int n, int n2) {
        int n3 = this.bfr_len + n2;
        if (n3 > this.bfr_max) {
            this.Resize(n3 * 2);
        }
        Base85_.Set_bry(n, this.bfr, this.bfr_len, n2);
        this.bfr_len = n3;
        return this;
    }

    public boolean Match_end_byt(byte by) {
        return this.bfr_len == 0 ? false : this.bfr[this.bfr_len - 1] == by;
    }

    public boolean Match_end_byt_nl_or_bos() {
        return this.bfr_len == 0 ? true : this.bfr[this.bfr_len - 1] == 10;
    }

    public boolean Match_end_ary(byte[] byArray) {
        return Bry_.Match(this.bfr, this.bfr_len - byArray.length, this.bfr_len, byArray);
    }

    public Bry_bfr Insert_at(int n, byte[] byArray) {
        return this.Insert_at(n, byArray, 0, byArray.length);
    }

    public Bry_bfr Insert_at(int n, byte[] byArray, int n2, int n3) {
        int n4 = n3 - n2;
        int n5 = this.bfr_max + n4;
        byte[] byArray2 = new byte[n5];
        if (n > 0) {
            Bry_.Copy_to(this.bfr, 0, n, byArray2, 0);
        }
        Bry_.Copy_to(byArray, n2, n3, byArray2, n);
        Bry_.Copy_to(this.bfr, n, this.bfr_len, byArray2, n + n4);
        this.bfr = byArray2;
        this.bfr_len += n4;
        this.bfr_max = n5;
        return this;
    }

    public Bry_bfr Delete_rng_to_bgn(int n) {
        return this.Delete_rng(0, n);
    }

    public Bry_bfr Delete_rng_to_end(int n) {
        return this.Delete_rng(n, this.bfr_len);
    }

    public Bry_bfr Delete_rng(int n, int n2) {
        int n3 = n2 - n;
        Bry_.Copy_to(this.bfr, n2, this.bfr_len, this.bfr, n);
        this.bfr_len -= n3;
        return this;
    }

    public Bry_bfr Del_by_1() {
        --this.bfr_len;
        this.bfr[this.bfr_len] = 0;
        return this;
    }

    public Bry_bfr Del_by(int n) {
        int n2 = this.bfr_len - n;
        if (n2 > -1) {
            this.bfr_len = n2;
        }
        return this;
    }

    public Bry_bfr Trim_end(byte by) {
        byte by2;
        if (this.bfr_len == 0) {
            return this;
        }
        int n = 0;
        for (int i = this.bfr_len - 1; i > -1 && (by2 = this.bfr[i]) == by; --i) {
            ++n;
        }
        if (n > 0) {
            this.Del_by(n);
        }
        return this;
    }

    public Bry_bfr Trim_end_ws() {
        byte by;
        if (this.bfr_len == 0) {
            return this;
        }
        int n = 0;
        for (int i = this.bfr_len - 1; i > -1 && Trim_end_ws_ary[by = this.bfr[i]]; --i) {
            ++n;
        }
        if (n > 0) {
            this.Del_by(n);
        }
        return this;
    }

    private static boolean[] Trim_end_ws_new() {
        boolean[] blArray = new boolean[256];
        blArray[32] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[13] = true;
        blArray[11] = true;
        return blArray;
    }

    public Bry_bfr Concat_skip_empty(byte[] byArray, byte[] ... byArray2) {
        int n = byArray2.length;
        for (int i = 0; i < n; ++i) {
            byte[] byArray3 = byArray2[i];
            boolean bl = Bry_.Len_gt_0(byArray3);
            if (i != 0 && bl && this.bfr_len > 0) {
                this.Add(byArray);
            }
            if (!bl) continue;
            this.Add(byArray3);
        }
        return this;
    }

    public boolean Eq(byte by) {
        return this.bfr_len == 1 && this.bfr[0] == by;
    }

    public byte[] To_bry(int n, int n2) {
        return this.bfr_len == 0 ? Bry_.Empty : Bry_.Mid(this.bfr, n, n2);
    }

    public byte[] To_bry() {
        return this.bfr_len == 0 ? Bry_.Empty : Bry_.Mid(this.bfr, 0, this.bfr_len);
    }

    public byte[] To_bry_and_clear_and_trim() {
        return this.To_bry_and_clear_and_trim(true, true, Bry_.Trim_ary_ws);
    }

    public byte[] To_bry_and_clear_and_trim(boolean bl, boolean bl2, byte[] byArray) {
        byte[] byArray2 = Bry_.Trim(this.bfr, 0, this.bfr_len, bl, bl2, byArray, false);
        this.Clear();
        return byArray2;
    }

    public byte[] To_bry_and_clear() {
        byte[] byArray = this.To_bry();
        this.Clear();
        if (this.reset > 0) {
            this.Reset_if_gt(this.reset);
        }
        return byArray;
    }

    public byte[] To_bry_and_clear_and_rls() {
        byte[] byArray = this.To_bry_and_clear();
        this.Mkr_rls();
        return byArray;
    }

    public byte[] To_reversed_bry_and_clear() {
        int n = this.Len();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[n - i - 1] = this.bfr[i];
        }
        this.Clear();
        if (this.reset > 0) {
            this.Reset_if_gt(this.reset);
        }
        return byArray;
    }

    public String To_str() {
        return String_.new_u8(this.To_bry());
    }

    public String To_str_by_pos(int n, int n2) {
        return String_.new_u8(this.To_bry(), n, n2);
    }

    public String To_str_and_clear() {
        return String_.new_u8(this.To_bry_and_clear());
    }

    public String To_str_and_clear_and_trim() {
        return String_.new_u8(this.To_bry_and_clear_and_trim());
    }

    public int To_int_and_clear(int n) {
        int n2 = this.To_int(n);
        this.Clear();
        return n2;
    }

    public int To_int(int n) {
        switch (this.bfr_len) {
            case 0: {
                return n;
            }
            case 1: {
                byte by = this.bfr[0];
                return Byte_ascii.Is_num(by) ? by - 48 : n;
            }
        }
        long l = 0L;
        long l2 = 1L;
        for (int i = this.bfr_len - 1; i > -1; --i) {
            byte by = this.bfr[i];
            if (!Byte_ascii.Is_num(by)) {
                return n;
            }
            long l3 = (long)(by - 48) * l2;
            long l4 = l + l3;
            if (l4 > Integer.MAX_VALUE) {
                return n;
            }
            l = l4;
            l2 *= 10L;
        }
        return (int)l;
    }

    public void Rls() {
        this.bfr = null;
        this.Mkr_rls();
    }

    public byte[][] To_bry_ary_and_clear() {
        if (this.bfr_len == 0) {
            return Bry_.Ary_empty;
        }
        Int_list int_list = this.Find_all((byte)10);
        int n = int_list.Len();
        byte[][] byArrayArray = new byte[n][];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = int_list.Get_at(i);
            byArrayArray[i] = Bry_.Mid(this.bfr, n2, n3);
            n2 = n3 + 1;
        }
        this.ClearAndReset();
        return byArrayArray;
    }

    public String[] To_str_ary_and_clear() {
        if (this.bfr_len == 0) {
            return String_.Ary_empty;
        }
        Int_list int_list = this.Find_all((byte)10);
        int n = int_list.Len();
        String[] stringArray = new String[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = int_list.Get_at(i);
            stringArray[i] = String_.new_u8(this.bfr, n2, n3);
            n2 = n3 + 1;
        }
        this.ClearAndReset();
        return stringArray;
    }

    private Int_list Find_all(byte by) {
        Int_list int_list = new Int_list();
        int n = 0;
        int n2 = 0;
        while (n < this.bfr_len) {
            n2 = Bry_find_.Find_fwd(this.bfr, by, n, this.bfr_len);
            if (n2 == -1) {
                int_list.Add(this.bfr_len);
                break;
            }
            int_list.Add(n2);
            n = n2 + 1;
        }
        return int_list;
    }

    public int hashCode() {
        return Bry_obj_ref.CalcHashCode(this.bfr, 0, this.bfr_len);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Bry_obj_ref bry_obj_ref = (Bry_obj_ref)object;
        return Bry_.Match(this.bfr, 0, this.bfr_len, bry_obj_ref.Val(), bry_obj_ref.Val_bgn(), bry_obj_ref.Val_end());
    }

    public void Resize(int n) {
        this.bfr_max = n;
        this.bfr = Bry_.Resize(this.bfr, 0, n);
    }

    public int Mkr_idx() {
        return this.mkr_idx;
    }

    public boolean Mkr_idx_is_null() {
        return this.mkr_idx == -1;
    }

    public int Bfr_max() {
        return this.bfr_max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bry_bfr Mkr_init(Bry_bfr_mkr_mgr bry_bfr_mkr_mgr, int n) {
        Bry_bfr bry_bfr = this;
        synchronized (bry_bfr) {
            this.mkr_mgr = bry_bfr_mkr_mgr;
            this.mkr_idx = n;
        }
        return this;
    }

    protected Bry_bfr() {
    }

    public Bry_bfr(int n) {
        this.Init(n);
    }

    protected void Init(int n) {
        this.bfr_max = n;
        this.bfr = new byte[n];
    }
}

