/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa;

import gplx.Bry_find_;
import gplx.Err_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.String_;
import gplx.core.threads.Thread_adp_;
import gplx.xowa.Xoa_manifest_item;
import gplx.xowa.Xoa_manifest_list;
import gplx.xowa.Xoa_manifest_view;

class Xoa_manifest_wkr {
    private final Xoa_manifest_view view;
    private final Xoa_manifest_list list = new Xoa_manifest_list();
    private Io_url manifest_url;
    private Io_url update_root;
    private String run_xowa_cmd;

    public Xoa_manifest_wkr(Xoa_manifest_view view) {
        this.view = view;
    }

    public void Init(Io_url manifest_url, Io_url update_root) {
        this.manifest_url = manifest_url;
        this.update_root = update_root;
        this.view.Append("loading manifest from: " + manifest_url.Raw());
        byte[] src = Io_mgr.Instance.LoadFilBry(manifest_url);
        int nl_pos = Bry_find_.Find_fwd(src, (byte)10);
        if (nl_pos == -1) {
            throw Err_.new_wo_type("could not find nl in manifest", "manifest_url", manifest_url.Raw());
        }
        this.run_xowa_cmd = String_.new_u8(src, 0, nl_pos);
        this.list.Load(src, nl_pos + 1, src.length);
        this.Wait();
    }

    private void Wait() {
        int tries = 0;
        while (tries++ < 100) {
            Thread_adp_.Sleep(1000);
            if (this.Copy_files()) break;
            String topmost = "#error";
            if (this.list.Len() > 0) {
                Xoa_manifest_item item = this.list.Get_at(0);
                topmost = item.Src().Raw();
            }
            this.view.Append("waiting for XOWA to release file: " + topmost);
        }
        this.On_exit();
    }

    public void On_exit() {
        this.view.Append("deleting update dir: " + this.update_root.Raw());
        Io_mgr.Instance.DeleteDirDeep(this.update_root);
        Io_mgr.Instance.DeleteFil(this.manifest_url);
        this.view.Mark_done(this.run_xowa_cmd);
        this.view.Run_xowa();
    }

    private boolean Copy_files() {
        int len = this.list.Len();
        int idx = 0;
        idx = 0;
        while (idx < len) {
            Xoa_manifest_item item = this.list.Get_at(idx);
            try {
                Io_mgr.Instance.DeleteFil_args(item.Trg()).MissingFails_off().Exec();
                Io_mgr.Instance.MoveFil_args(item.Src(), item.Trg(), true).Exec();
                this.view.Append(String_.Format("copied file: src={0} trg={1}", item.Src().Raw(), item.Trg().Raw()));
            }
            catch (Exception exc) {
                this.view.Append(String_.Format("failed to copy file: src={0} trg={1} err={2}", item.Src().Raw(), item.Trg().Raw(), Err_.Message_lang(exc)));
                return false;
            }
            ++idx;
        }
        int i = 0;
        while (i < idx) {
            this.list.Del_at(0);
            ++i;
        }
        return true;
    }
}

