/*
 * Decompiled with CFR 0.152.
 */
package gplx.langs.dsvs;

import gplx.Err_;
import gplx.Internal;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.core.gfo_ndes.GfoFldList;
import gplx.core.gfo_ndes.GfoFldList_;
import gplx.core.gfo_ndes.GfoNde;
import gplx.core.gfo_ndes.GfoNde_;
import gplx.core.strings.String_bldr;
import gplx.core.strings.String_bldr_;
import gplx.core.type_xtns.ClassXtn;
import gplx.core.type_xtns.ClassXtnPool;
import gplx.core.type_xtns.StringClassXtn;
import gplx.langs.dsvs.DsvStoreLayout;

class DsvTblBldr {
    GfoNde root;
    GfoNde tbl;
    DsvStoreLayout layout = DsvStoreLayout.dsv_brief_();
    List_adp fldNames = List_adp_.New();
    List_adp fldTypes = List_adp_.New();
    int stage = 0;
    @Internal
    protected static final String NullTblName = "";
    static final int Stage_Init = 0;
    static final int Stage_Hdr = 1;
    static final int Stage_Row = 2;

    public void Init() {
        this.root = GfoNde_.root_(new GfoNde[0]);
        this.tbl = GfoNde_.tbl_(NullTblName, GfoFldList_.new_(), new GfoNde[0]);
        this.fldNames.Clear();
        this.fldTypes.Clear();
        this.stage = 0;
    }

    public GfoNde BldRoot() {
        if (this.stage != 0) {
            this.CreateTbl();
        }
        return this.root;
    }

    public void MakeTblBgn(List_adp tkns) {
        if (this.stage != 0) {
            this.CreateTbl();
        }
        this.tbl.Name_((String)tkns.Get_at(0));
        this.layout.HeaderList().Add_TableName();
        this.stage = 1;
        tkns.Clear();
    }

    public void MakeFldNames(List_adp tkns) {
        if (this.stage == 2) {
            this.CreateTbl();
        }
        this.fldNames.Clear();
        for (Object fldNameObj : tkns) {
            this.fldNames.Add(fldNameObj);
        }
        this.layout.HeaderList().Add_LeafNames();
        this.stage = 1;
        tkns.Clear();
    }

    public void MakeFldTypes(List_adp tkns) {
        if (this.stage == 2) {
            this.CreateTbl();
        }
        this.fldTypes.Clear();
        for (Object fldTypeObj : tkns) {
            ClassXtn type = ClassXtnPool.Instance.Get_by_or_fail((String)fldTypeObj);
            this.fldTypes.Add(type);
        }
        this.layout.HeaderList().Add_LeafTypes();
        this.stage = 1;
        tkns.Clear();
    }

    public void MakeComment(List_adp tkns) {
        if (this.stage == 2) {
            tkns.Clear();
        } else {
            String_bldr sb = String_bldr_.new_();
            int i = 0;
            while (i < tkns.Count()) {
                sb.Add((String)tkns.Get_at(i));
                ++i;
            }
            this.layout.HeaderList().Add_Comment(sb.To_str());
            tkns.Clear();
        }
    }

    public void MakeBlankLine() {
        if (this.stage != 0) {
            this.CreateTbl();
        }
        this.layout.HeaderList().Add_BlankLine();
        this.stage = 0;
    }

    public void MakeVals(List_adp tkns) {
        if (this.stage != 2) {
            this.CreateFlds(tkns.Count());
        }
        GfoNde row = GfoNde_.vals_(this.tbl.SubFlds(), this.MakeValsAry(tkns));
        this.tbl.Subs().Add(row);
        this.stage = 2;
        tkns.Clear();
    }

    Object[] MakeValsAry(List_adp tkns) {
        GfoFldList subFlds = this.tbl.SubFlds();
        int subFldsCount = subFlds.Count();
        if (tkns.Count() > subFldsCount) {
            throw Err_.new_wo_type("values.Count cannot be greater than fields.Count", "values.Count", tkns.Count(), "fields.Count", subFldsCount);
        }
        Object[] rv = new Object[subFldsCount];
        int i = 0;
        while (i < subFldsCount) {
            ClassXtn typx = subFlds.Get_at(i).Type();
            String val = i < tkns.Count() ? (String)tkns.Get_at(i) : null;
            rv[i] = typx.ParseOrNull(val);
            ++i;
        }
        return rv;
    }

    void CreateTbl() {
        if (this.tbl.SubFlds().Count() == 0) {
            this.CreateFlds(0);
        }
        this.tbl.EnvVars().Add("StoreLayoutWtr", this.layout);
        this.root.Subs().Add(this.tbl);
        this.layout = DsvStoreLayout.dsv_brief_();
        this.tbl = GfoNde_.tbl_(NullTblName, GfoFldList_.new_(), new GfoNde[0]);
        this.stage = 1;
    }

    void CreateFlds(int valCount) {
        int fldNamesCount = this.fldNames.Count();
        int fldTypesCount = this.fldTypes.Count();
        if (fldNamesCount == 0 && fldTypesCount == 0) {
            int i = 0;
            while (i < valCount) {
                this.tbl.SubFlds().Add("fld" + i, StringClassXtn.Instance);
                ++i;
            }
        } else {
            int maxCount = fldNamesCount > fldTypesCount ? fldNamesCount : fldTypesCount;
            int i = 0;
            while (i < maxCount) {
                String name = i < fldNamesCount ? (String)this.fldNames.Get_at(i) : "fld" + i;
                StringClassXtn typx = i < fldTypesCount ? (ClassXtn)this.fldTypes.Get_at(i) : StringClassXtn.Instance;
                this.tbl.SubFlds().Add(name, typx);
                ++i;
            }
        }
    }

    public static DsvTblBldr new_() {
        return new DsvTblBldr();
    }

    DsvTblBldr() {
        this.Init();
    }
}

