/*
 * Decompiled with CFR 0.152.
 */
package gplx.langs.dsvs;

import gplx.Err_;
import gplx.Internal;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.String_;
import gplx.core.gfo_ndes.GfoFld;
import gplx.core.gfo_ndes.GfoFldList;
import gplx.core.gfo_ndes.GfoNde;
import gplx.core.stores.DataRdr;
import gplx.core.stores.GfoNdeRdr_;
import gplx.core.strings.String_bldr;
import gplx.core.strings.String_bldr_;
import gplx.core.texts.CharStream;
import gplx.langs.dsvs.DsvSymbols;
import gplx.langs.dsvs.DsvTblBldr;

class DsvParser {
    DsvSymbols sym = DsvSymbols.default_();
    String_bldr sb = String_bldr_.new_();
    List_adp tkns = List_adp_.New();
    DsvTblBldr bldr = DsvTblBldr.new_();
    boolean cmdSeqOn = false;
    boolean qteOn = false;
    boolean csvOn = false;
    int nextValType = 0;
    int lineMode = 0;
    static final int ValType_Data = 0;
    static final int ValType_CmdName = 1;
    static final int LineType_Data = 0;
    static final int LineType_Comment = 1;
    static final int LineType_TblBgn = 2;
    static final int LineType_FldNames = 3;
    static final int LineType_FldTypes = 4;
    static final int LineType_BlankLine = 5;

    DsvParser() {
    }

    @Internal
    protected DsvSymbols Symbols() {
        return this.sym;
    }

    @Internal
    protected void Init() {
        this.sb.Clear();
        this.bldr.Init();
        this.qteOn = false;
    }

    @Internal
    protected DataRdr ParseAsRdr(String raw) {
        return GfoNdeRdr_.root_(this.ParseAsNde(raw), this.csvOn);
    }

    @Internal
    protected GfoNde ParseAsNde(String raw) {
        if (String_.Eq(raw, "")) {
            return this.bldr.BldRoot();
        }
        CharStream strm = CharStream.pos0_(raw);
        while (true) {
            if (strm.AtEnd()) break;
            if (this.qteOn) {
                this.ReadStreamInQte(strm);
                continue;
            }
            if (strm.MatchAndMove(this.sym.QteDlm())) {
                this.qteOn = true;
                continue;
            }
            if (strm.MatchAndMove(this.sym.FldSep())) {
                this.ProcessFld(strm);
                continue;
            }
            if (strm.MatchAndMove(this.sym.RowSep())) {
                this.ProcessLine(strm, false);
                continue;
            }
            this.sb.Add(strm.Cur());
            strm.MoveNext();
        }
        this.ProcessLine(strm, true);
        return this.bldr.BldRoot();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void ReadStreamInQte(CharStream strm) {
        if (strm.MatchAndMove(this.sym.QteDlm())) {
            if (strm.MatchAndMove(this.sym.QteDlm())) {
                this.sb.Add(this.sym.QteDlm());
                return;
            } else if (strm.MatchAndMove(this.sym.FldSep())) {
                this.ProcessFld(strm);
                this.qteOn = false;
                return;
            } else {
                if (!strm.MatchAndMove(this.sym.RowSep()) && !strm.AtEnd()) throw Err_.new_wo_type("invalid quote in quoted field; quote must be followed by quote, fieldSpr, or recordSpr", "sym", Character.valueOf(strm.Cur()), "text", strm.To_str_by_pos(strm.Pos() - 10, strm.Pos() + 10));
                this.ProcessLine(strm, false);
                this.qteOn = false;
            }
            return;
        } else {
            this.sb.Add(strm.Cur());
            strm.MoveNext();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void ProcessFld(CharStream strm) {
        String val = this.sb.To_str_and_clear();
        if (this.cmdSeqOn) {
            this.cmdSeqOn = false;
            if (String_.Eq(val, this.sym.CmdDlm()) && this.qteOn) {
                this.nextValType = 1;
                return;
            }
            this.tkns.Add(this.sym.CmdDlm());
        }
        if (String_.Eq(val, this.sym.CmdDlm())) {
            this.cmdSeqOn = true;
            return;
        } else if (this.nextValType == 0) {
            if (String_.Len(val) == 0) {
                val = this.qteOn ? "" : null;
            }
            this.tkns.Add(val);
            return;
        } else {
            if (this.nextValType != 1) throw Err_.new_wo_type("unable to process field value", "value", val);
            if (String_.Eq(val, this.sym.TblNameSym())) {
                this.lineMode = 2;
                return;
            } else if (String_.Eq(val, this.sym.FldNamesSym())) {
                this.lineMode = 3;
                return;
            } else if (String_.Eq(val, this.sym.FldTypesSym())) {
                this.lineMode = 4;
                return;
            } else {
                if (!String_.Eq(val, this.sym.CommentSym())) throw Err_.new_wo_type("unknown dsv cmd", "cmd", val);
                this.lineMode = 1;
            }
        }
    }

    void ProcessLine(CharStream strm, boolean cleanup) {
        if (this.sb.Count() == 0 && this.tkns.Count() == 0) {
            if (this.csvOn) {
                if (cleanup) {
                    return;
                }
                this.ProcessFld(strm);
            } else {
                this.lineMode = 5;
            }
        } else {
            this.ProcessFld(strm);
        }
        if (this.cmdSeqOn) {
            this.cmdSeqOn = false;
            this.tkns.Add(this.sym.CmdDlm());
        }
        if (this.lineMode == 2) {
            this.bldr.MakeTblBgn(this.tkns);
        } else if (this.lineMode == 3) {
            this.bldr.MakeFldNames(this.tkns);
        } else if (this.lineMode == 4) {
            this.bldr.MakeFldTypes(this.tkns);
        } else if (this.lineMode == 1) {
            this.bldr.MakeComment(this.tkns);
        } else if (this.lineMode == 5) {
            this.bldr.MakeBlankLine();
        } else {
            this.bldr.MakeVals(this.tkns);
        }
        this.nextValType = 0;
        this.lineMode = 0;
    }

    @Internal
    protected static DsvParser dsv_() {
        return new DsvParser();
    }

    @Internal
    protected static DsvParser csv_(boolean hasHdr, GfoFldList flds) {
        DsvParser rv = new DsvParser();
        rv.csvOn = true;
        rv.lineMode = hasHdr ? 3 : 0;
        List_adp names = List_adp_.New();
        List_adp types = List_adp_.New();
        int i = 0;
        while (i < flds.Count()) {
            GfoFld fld = flds.Get_at(i);
            names.Add(fld.Key());
            types.Add(fld.Type().Key());
            ++i;
        }
        rv.bldr.MakeFldNames(names);
        rv.bldr.MakeFldTypes(types);
        return rv;
    }
}

