/*
 * Decompiled with CFR 0.152.
 */
package gplx.langs.dsvs;

import gplx.String_;
import gplx.core.gfo_ndes.GfoFldList;
import gplx.core.gfo_ndes.GfoFldList_;
import gplx.core.gfo_ndes.GfoNde;
import gplx.core.gfo_ndes.GfoNdeFxt;
import gplx.core.gfo_ndes.GfoNde_;
import gplx.core.type_xtns.StringClassXtn;
import gplx.langs.dsvs.DsvDataWtr;
import gplx.langs.dsvs.DsvDataWtr_;
import gplx.langs.dsvs.DsvDataWtr_fxt;
import org.junit.Test;

public class DsvDataWtr_csv_tst {
    GfoNde root;
    String expd;
    DsvDataWtr wtr = DsvDataWtr_.csv_dat_();
    DsvDataWtr_fxt fx = DsvDataWtr_fxt.new_();
    GfoNdeFxt fx_nde = GfoNdeFxt.new_();

    @Test
    public void Dat_Val_0() {
        this.root = this.fx_nde.csv_dat_(new GfoNde[0]);
        this.AddCsvRow(this.root, new String[0]);
        this.expd = String_.Concat_lines_crlf("");
        this.fx.tst_XtoStr(this.wtr, this.root, this.expd);
    }

    @Test
    public void Dat_Val_1() {
        this.root = this.fx_nde.csv_dat_(new GfoNde[0]);
        this.AddCsvRow(this.root, "a");
        this.expd = String_.Concat_lines_crlf("a");
        this.fx.tst_XtoStr(this.wtr, this.root, this.expd);
    }

    @Test
    public void Dat_Val_N() {
        this.root = this.fx_nde.csv_dat_(new GfoNde[0]);
        this.AddCsvRow(this.root, "a", "b", "c");
        this.expd = String_.Concat_lines_crlf("a,b,c");
        this.fx.tst_XtoStr(this.wtr, this.root, this.expd);
    }

    @Test
    public void Dat_Row_N() {
        this.root = this.fx_nde.csv_dat_(new GfoNde[0]);
        this.AddCsvRow(this.root, "a", "b", "c");
        this.AddCsvRow(this.root, "d", "e", "f");
        this.expd = String_.Concat_lines_crlf("a,b,c", "d,e,f");
        this.fx.tst_XtoStr(this.wtr, this.root, this.expd);
    }

    @Test
    public void Dat_Escape_FldSpr() {
        this.root = this.fx_nde.csv_dat_(new GfoNde[0]);
        this.AddCsvRow(this.root, "a", ",", "c");
        this.expd = String_.Concat_lines_crlf("a,\",\",c");
        this.fx.tst_XtoStr(this.wtr, this.root, this.expd);
    }

    @Test
    public void Dat_Escape_RcdSpr() {
        this.root = this.fx_nde.csv_dat_(new GfoNde[0]);
        this.AddCsvRow(this.root, "a", "\r\n", "c");
        this.expd = String_.Concat_lines_crlf("a,\"\r\n\",c");
        this.fx.tst_XtoStr(this.wtr, this.root, this.expd);
    }

    @Test
    public void Dat_Escape_Quote() {
        this.root = this.fx_nde.csv_dat_(new GfoNde[0]);
        this.AddCsvRow(this.root, "a", "\"", "c");
        this.expd = String_.Concat_lines_crlf("a,\"\"\"\",c");
        this.fx.tst_XtoStr(this.wtr, this.root, this.expd);
    }

    @Test
    public void Dat_Whitespace() {
        this.root = this.fx_nde.csv_dat_(new GfoNde[0]);
        this.AddCsvRow(this.root, "a", " b\t", "c");
        this.expd = String_.Concat_lines_crlf("a, b\t,c");
        this.fx.tst_XtoStr(this.wtr, this.root, this.expd);
    }

    @Test
    public void Dat_Null() {
        this.root = this.fx_nde.csv_dat_(new GfoNde[0]);
        this.AddCsvRow(this.root, "a", null, "c");
        this.expd = String_.Concat_lines_crlf("a,,c");
        this.fx.tst_XtoStr(this.wtr, this.root, this.expd);
    }

    @Test
    public void Dat_EmptyString() {
        this.root = this.fx_nde.csv_dat_(new GfoNde[0]);
        this.AddCsvRow(this.root, "a", "", "c");
        this.expd = String_.Concat_lines_crlf("a,\"\",c");
        this.fx.tst_XtoStr(this.wtr, this.root, this.expd);
    }

    @Test
    public void Hdr_Flds() {
        this.wtr = DsvDataWtr_.csv_hdr_();
        GfoFldList flds = GfoFldList_.new_().Add("id", StringClassXtn.Instance).Add("name", StringClassXtn.Instance);
        this.root = this.fx_nde.csv_hdr_(flds, new GfoNde[0]);
        this.AddCsvRow(this.root, "0", "me");
        this.expd = String_.Concat_lines_crlf("id,name", "0,me");
        this.fx.tst_XtoStr(this.wtr, this.root, this.expd);
    }

    void AddCsvRow(GfoNde root, String ... ary) {
        GfoNde sub = GfoNde_.vals_(root.SubFlds(), ary);
        root.Subs().Add(sub);
    }
}

