/*
 * Decompiled with CFR 0.152.
 */
package gplx.langs.dsvs;

import gplx.String_;
import gplx.Tfds;
import gplx.core.gfo_ndes.GfoNde;
import gplx.langs.dsvs.DsvParser;
import gplx.langs.dsvs.DsvStoreLayout;
import org.junit.Test;

public class DsvDataRdr_layout_tst {
    GfoNde root;

    @Test
    public void TableName() {
        this.run_parse_lines("table0, ,\" \",#");
        this.tst_Layout(0, 2);
    }

    @Test
    public void Comment() {
        this.run_parse_lines("-------------, ,\" \",//", "data");
        this.tst_Layout(0, 1);
    }

    @Test
    public void BlankLine() {
        this.run_parse_lines("", "data");
        this.tst_Layout(0, 3);
    }

    @Test
    public void LeafNames() {
        this.run_parse_lines("id,name, ,\" \",@");
        this.tst_Layout(0, 5);
    }

    @Test
    public void LeafTypes() {
        this.run_parse_lines("int,string, ,\" \",$");
        this.tst_Layout(0, 4);
    }

    @Test
    public void Combined() {
        this.run_parse_lines("", "-------------, ,\" \",//", "table0, ,\" \",#", "int,string, ,\" \",$", "id,name, ,\" \",@", "-------------, ,\" \",//", "0,me");
        this.tst_Layout(0, 3, 1, 2, 4, 5, 1);
    }

    @Test
    public void Tbl_N() {
        this.run_parse_lines("", "*************, ,\" \",//", "table0, ,\" \",#", "-------------, ,\" \",//", "0,me", "", "*************, ,\" \",//", "table1, ,\" \",#", "\textended data, ,\" \",//", "-------------, ,\" \",//", "1,you,more");
        this.tst_Layout(0, 3, 1, 2, 1);
        this.tst_Layout(1, 3, 1, 2, 1, 1);
    }

    @Test
    public void Tbl_N_FirstIsEmpty() {
        this.run_parse_lines("", "*************, ,\" \",//", "table0, ,\" \",#", "-------------, ,\" \",//", "", "", "*************, ,\" \",//", "table1, ,\" \",#", "\textended data, ,\" \",//", "-------------, ,\" \",//", "1,you,more");
        this.tst_Layout(0, 3, 1, 2, 1);
        this.tst_Layout(1, 3, 3, 1, 2, 1, 1);
    }

    void run_parse_lines(String ... ary) {
        String raw = String_.Concat_lines_crlf(ary);
        DsvParser parser = DsvParser.dsv_();
        this.root = parser.ParseAsNde(raw);
    }

    void tst_Layout(int subIdx, int ... expd) {
        GfoNde tbl = this.root.Subs().FetchAt_asGfoNde(subIdx);
        DsvStoreLayout layout = (DsvStoreLayout)tbl.EnvVars().Get_by("StoreLayoutWtr");
        int[] actl = new int[layout.HeaderList().Count()];
        int i = 0;
        while (i < actl.length) {
            actl[i] = layout.HeaderList().Get_at(i).Id();
            ++i;
        }
        Tfds.Eq_ary(expd, actl);
    }
}

