/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.times;

import gplx.Tfds;
import gplx.Time_span;
import gplx.Time_span_;
import org.junit.Test;

public class Time_span__parse_tst {
    @Test
    public void Zero() {
        this.tst_Parse("0", 0L);
    }

    @Test
    public void Milliseconds() {
        this.tst_Parse("0.987", 987L);
        this.tst_Parse("0.00199", 1L);
        this.tst_Parse("0.1", 100L);
    }

    @Test
    public void Seconds() {
        this.tst_Parse("1.987", 1987L);
    }

    @Test
    public void Minutes() {
        this.tst_Parse("1:02.987", 62987L);
    }

    @Test
    public void MinuteSecondOnly() {
        this.tst_Parse("1:02", 62000L);
    }

    @Test
    public void Hour() {
        this.tst_Parse("1:02:03.987", 3723987L);
    }

    @Test
    public void Negative() {
        this.tst_Parse("-1:02:03.987", -3723987L);
    }

    @Test
    public void Loopholes() {
        this.tst_Parse("001:02", 62000L);
        this.tst_Parse("1.2.3.4", 1200L);
        this.tst_Parse("60:60.9999", 3660999L);
        this.tst_Parse(" 01 : 02 : 03 . 987", 3723987L);
    }

    void tst_Parse(String text, long expd) {
        Time_span val = Time_span_.parse(text);
        Tfds.Eq(expd, val.Fracs());
    }
}

