/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.times;

import gplx.Err_;
import gplx.String_;

class IntBldr {
    int[] digits;
    int idx;
    int digitsLen;
    int sign = 1;

    IntBldr() {
    }

    public int Add(char c) {
        if (this.idx > this.digitsLen - 1) {
            throw Err_.new_missing_idx(this.idx, this.digitsLen);
        }
        this.digits[this.idx++] = this.XbyChar(c);
        return this.idx;
    }

    public int Add(int i) {
        if (this.idx > this.digitsLen - 1) {
            throw Err_.new_missing_idx(this.idx, this.digitsLen);
        }
        this.digits[this.idx++] = i;
        return this.idx;
    }

    public int Parse(String raw) {
        this.ParseStr(raw);
        try {
            return this.Bld();
        }
        catch (Exception exc) {
            throw Err_.new_parse_exc(exc, Integer.TYPE, raw);
        }
    }

    public boolean ParseTry(String raw) {
        this.ParseStr(raw);
        int i = 0;
        while (i < this.idx) {
            if (this.digits[i] < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int Bld() {
        int rv = 0;
        int exponent = 1;
        int i = this.idx - 1;
        while (i > -1) {
            int digit = this.digits[i];
            if (digit < 0) {
                throw Err_.new_wo_type("invalid char", "char", Character.valueOf((char)(-this.digits[i])), "ascii", -this.digits[i]);
            }
            rv += digit * exponent;
            exponent *= 10;
            --i;
        }
        return this.sign * rv;
    }

    public int BldAndClear() {
        int rv = this.Bld();
        this.Clear();
        return rv;
    }

    public void Clear() {
        this.idx = 0;
        this.sign = 1;
    }

    void ParseStr(String raw) {
        this.Clear();
        int rawLength = String_.Len(raw);
        int i = 0;
        while (i < rawLength) {
            char c = String_.CharAt(raw, i);
            if (i == 0 && c == '-') {
                this.sign = -1;
            } else {
                this.Add(c);
            }
            ++i;
        }
    }

    int XbyChar(char c) {
        if (c == '0') {
            return 0;
        }
        if (c == '1') {
            return 1;
        }
        if (c == '2') {
            return 2;
        }
        if (c == '3') {
            return 3;
        }
        if (c == '4') {
            return 4;
        }
        if (c == '5') {
            return 5;
        }
        if (c == '6') {
            return 6;
        }
        if (c == '7') {
            return 7;
        }
        if (c == '8') {
            return 8;
        }
        if (c == '9') {
            return 9;
        }
        return -c;
    }

    public static IntBldr new_(int digitsMax) {
        IntBldr rv = new IntBldr();
        rv.digits = new int[digitsMax];
        rv.digitsLen = digitsMax;
        return rv;
    }
}

