/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.texts;

import gplx.Object_;
import gplx.Tfds;
import gplx.core.texts.RegxPatn_cls_like;
import gplx.core.texts.RegxPatn_cls_like_;
import org.junit.Test;

public class RegxPatn_cls_like_tst {
    @Test
    public void Basic() {
        this.tst_Match("abcd", "abcd", true);
        this.tst_Match("abcd", "zbcd", false);
        this.tst_Match("abcd", "abc", false);
        this.tst_Match("a cd", "a cd", true);
    }

    @Test
    public void Wildcard() {
        this.tst_Match("abcd", "a%", true);
        this.tst_Match("abcd", "b%", false);
        this.tst_Match("abcd", "%d", true);
        this.tst_Match("abcd", "%c", false);
        this.tst_Match("abcd", "%b%", true);
        this.tst_Match("abcd", "%e%", false);
        this.tst_Match("abcd", "%a%", true);
        this.tst_Match("abcd", "%d%", true);
    }

    @Test
    public void Any() {
        this.tst_Match("abcd", "a_cd", true);
        this.tst_Match("abcd", "z_cd", false);
        this.tst_Match("abcd", "a_c", false);
    }

    @Test
    public void CharSet() {
        this.tst_Match("abcd", "a[b]cd", true);
        this.tst_Match("abcd", "a[x]cd", false);
        this.tst_Match("abcd", "a[bcde]cd", true);
        this.tst_Match("abcd", "a[xyz]cd", false);
        this.tst_Match("abcd", "a[^z]cd", true);
        this.tst_Match("abcd", "a[^b]cd", false);
    }

    @Test
    public void Escape() {
        this.tst_Match("a%b", "a|%b", true);
        this.tst_Match("a%bc", "a|%b", false);
        this.tst_Match("a|b", "a|b", false);
        this.tst_Match("a|b", "a||b", true);
    }

    @Test
    public void Escape_diffChar() {
        this.tst_Match("a%b", "a~%b", '~', true);
        this.tst_Match("a%bc", "a~%b", '~', false);
        this.tst_Match("a|b", "a|b", '~', true);
        this.tst_Match("a~b", "a~b", '~', false);
        this.tst_Match("a~b", "a~~b", '~', true);
    }

    @Test
    public void Chars() {
        this.tst_EscapeRegxChar('\\');
        this.tst_EscapeRegxChar('(');
        this.tst_EscapeRegxChar(')');
        this.tst_EscapeRegxChar('^');
        this.tst_EscapeRegxChar('$');
        this.tst_EscapeRegxChar('{');
        this.tst_EscapeRegxChar('}');
        this.tst_EscapeRegxChar('?');
        this.tst_EscapeRegxChar('*');
        this.tst_EscapeRegxChar('+');
    }

    void tst_Match(String raw, String regx, boolean expd) {
        this.tst_Match(raw, regx, '|', expd);
    }

    void tst_Match(String raw, String regx, char escape, boolean expd) {
        RegxPatn_cls_like like = RegxPatn_cls_like_.parse(regx, escape);
        boolean actl = like.Matches(raw);
        Tfds.Eq(expd, actl, "raw={0} regx={1} expd={2}", raw, regx, expd);
    }

    void tst_EscapeRegxChar(char regexChar) {
        RegxPatn_cls_like like = RegxPatn_cls_like_.parse(Object_.Xto_str_strict_or_empty(Character.valueOf(regexChar)), '|');
        Tfds.Eq(true, like.Matches(Object_.Xto_str_strict_or_empty(Character.valueOf(regexChar))));
        Tfds.Eq(false, like.Matches("a"));
    }
}

