/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.texts;

import gplx.Array_;
import gplx.Char_;
import gplx.Err_;
import gplx.String_;

public class CharStream {
    char[] ary;
    int len;
    int pos = -1;
    static final int BgnPos = -1;

    public char[] Ary() {
        return this.ary;
    }

    public int Len() {
        return this.len;
    }

    public int Pos() {
        return this.pos;
    }

    public boolean AtBgn() {
        return this.pos <= -1;
    }

    public boolean AtEnd() {
        return this.pos >= this.len;
    }

    public boolean AtMid() {
        return this.pos > -1 && this.pos < this.len;
    }

    public char Cur() {
        try {
            return this.ary[this.pos];
        }
        catch (Exception exc) {
            Err_.Noop(exc);
            throw Err_.new_missing_idx(this.pos, this.Len());
        }
    }

    public void MoveNext() {
        ++this.pos;
    }

    public void MoveNextBy(int offset) {
        this.pos += offset;
    }

    public void MoveBack() {
        --this.pos;
    }

    public void MoveBackBy(int offset) {
        this.pos -= offset;
    }

    public void Move_to(int val) {
        this.pos = val;
    }

    public boolean Match(String match) {
        int matchLen = String_.Len(match);
        int i = 0;
        while (i < matchLen) {
            int cur = this.pos + i;
            if (cur >= this.len || this.ary[cur] != String_.CharAt(match, i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean MatchAndMove(String match) {
        int matchLen = String_.Len(match);
        boolean rv = this.Match(match);
        if (rv) {
            this.MoveNextBy(matchLen);
        }
        return rv;
    }

    public boolean MatchAndMove(char match) {
        boolean rv;
        boolean bl = rv = this.ary[this.pos] == match;
        if (rv) {
            ++this.pos;
        }
        return rv;
    }

    public String To_str() {
        return Char_.To_str(this.ary, 0, this.len);
    }

    public String XtoStrAtCur(int length) {
        length = this.pos + length > this.len ? this.len - this.pos : length;
        return Char_.To_str(this.ary, this.pos, length);
    }

    public String To_str_by_pos(int bgn, int end) {
        if (bgn < 0) {
            bgn = 0;
        }
        if (end > this.len - 1) {
            end = this.len - 1;
        }
        return Char_.To_str(this.ary, bgn, end - bgn + 1);
    }

    public static CharStream pos0_(String text) {
        CharStream rv = new CharStream();
        rv.ary = String_.XtoCharAry(text);
        rv.len = Array_.Len(rv.ary);
        rv.MoveNext();
        return rv;
    }

    CharStream() {
    }
}

