/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.stores.xmls;

import gplx.Tfds;
import gplx.core.stores.DataRdr;
import gplx.core.stores.xmls.XmlDataRdr_fxt;
import org.junit.Test;

public class XmlDataRdr_tst {
    XmlDataRdr_fxt fx = XmlDataRdr_fxt.new_();

    @Test
    public void Read() {
        DataRdr rdr = this.fx.rdr_("<title id=\"1\" name=\"first\" profiled=\"false\" />");
        Tfds.Eq(rdr.NameOfNode(), "title");
        Tfds.Eq(rdr.ReadStr("name"), "first");
        Tfds.Eq(rdr.ReadInt("id"), 1);
        Tfds.Eq(rdr.ReadBool("profiled"), false);
    }

    @Test
    public void None() {
        DataRdr rdr = this.fx.rdr_("<root>", "<find/>", "</root>");
        this.fx.tst_Subs_ByName(rdr, "no_nde", "no_atr", new String[0]);
    }

    @Test
    public void One() {
        DataRdr rdr = this.fx.rdr_("<root>", "<find id=\"f0\" />", "</root>");
        this.fx.tst_Subs_ByName(rdr, "find", "id", "f0");
    }

    @Test
    public void One_IgnoreOthers() {
        DataRdr rdr = this.fx.rdr_("<root>", "<find id=\"f0\" />", "<skip id=\"s0\" />", "</root>");
        this.fx.tst_Subs_ByName(rdr, "find", "id", "f0");
    }

    @Test
    public void Many() {
        DataRdr rdr = this.fx.rdr_("<root>", "<find id=\"f0\" />", "<find id=\"f1\" />", "</root>");
        this.fx.tst_Subs_ByName(rdr, "find", "id", "f0", "f1");
    }

    @Test
    public void Nested() {
        DataRdr rdr = this.fx.rdr_("<root>", "<sub1>", "<find id=\"f0\" />", "<find id=\"f1\" />", "</sub1>", "</root>");
        this.fx.tst_Subs_ByName(rdr, "sub1/find", "id", "f0", "f1");
    }

    @Test
    public void Nested_IgnoreOthers() {
        DataRdr rdr = this.fx.rdr_("<root>", "<sub1>", "<find id=\"f0\" />", "<skip id=\"s0\" />", "</sub1>", "<sub1>", "<find id=\"f1\" />", "<skip id=\"s1\" />", "</sub1>", "</root>");
        this.fx.tst_Subs_ByName(rdr, "sub1/find", "id", "f0", "f1");
    }
}

