/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.stores;

import gplx.Object_;
import gplx.Tfds;
import gplx.core.gfo_ndes.GfoNde;
import gplx.core.gfo_ndes.GfoNdeFxt;
import gplx.core.gfo_ndes.GfoNde_;
import gplx.core.stores.DataRdr;
import gplx.core.stores.GfoNdeRdr;
import gplx.core.stores.GfoNdeRdr_;
import org.junit.Test;

public class GfoNdeRdr_tst {
    GfoNde root;
    DataRdr rootRdr;
    GfoNdeFxt fx = GfoNdeFxt.new_();

    @Test
    public void Subs_leafs() {
        this.root = this.fx.root_(this.fx.row_vals_(0), this.fx.row_vals_(1), this.fx.row_vals_(2));
        this.tst_NdeVals(this.root, 0, 1, 2);
    }

    @Test
    public void Subs_ndes() {
        this.root = this.fx.root_(this.leaf_("", 0), this.leaf_("", 1), this.leaf_("", 2));
        this.tst_NdeVals(this.root, 0, 1, 2);
    }

    @Test
    public void Subs_mix() {
        this.root = this.fx.root_(this.leaf_("", 0), this.fx.row_vals_(1), this.fx.row_vals_(2));
        this.tst_NdeVals(this.root, 0, 1, 2);
    }

    @Test
    public void Subs_rdr() {
        this.root = this.fx.root_(this.fx.row_vals_(0));
        this.rootRdr = GfoNdeRdr_.root_parseNot_(this.root);
        DataRdr rdr = this.rootRdr.Subs();
        Tfds.Eq_true(rdr.MoveNextPeer());
        Tfds.Eq(0, rdr.ReadAt(0));
        Tfds.Eq_false(rdr.MoveNextPeer());
    }

    @Test
    public void MoveNextPeer_implicit() {
        this.root = this.fx.root_(this.fx.csv_dat_(this.fx.row_vals_(0), this.fx.row_vals_(1), this.fx.row_vals_(2)));
        GfoNdeRdr rootRdr = GfoNdeRdr_.root_parseNot_(this.root);
        DataRdr subsRdr = rootRdr.Subs();
        DataRdr subRdr = subsRdr.Subs();
        this.tst_RdrVals(subRdr, Object_.Ary(0, 1, 2));
    }

    @Test
    public void MoveNextPeer_explicit() {
        this.root = this.fx.root_(this.fx.csv_dat_(this.fx.row_vals_(0), this.fx.row_vals_(1), this.fx.row_vals_(2)));
        GfoNdeRdr rootRdr = GfoNdeRdr_.root_parseNot_(this.root);
        DataRdr subsRdr = rootRdr.Subs();
        Tfds.Eq_true(subsRdr.MoveNextPeer());
        DataRdr subRdr = subsRdr.Subs();
        this.tst_RdrVals(subRdr, Object_.Ary(0, 1, 2));
    }

    @Test
    public void Xpath_basic() {
        this.root = this.fx.root_(this.leaf_("root", 0), this.leaf_("root", 1), this.leaf_("root", 2));
        this.tst_Xpath_all(this.root, "root", 0, 1, 2);
    }

    @Test
    public void Xpath_nested() {
        this.root = this.fx.root_(this.fx.tbl_("owner", this.leaf_("root", 0), this.leaf_("root", 1), this.leaf_("root", 2)));
        this.tst_Xpath_all(this.root, "owner/root", 0, 1, 2);
    }

    @Test
    public void Xpath_null() {
        this.root = this.fx.root_(this.leaf_("match", 0));
        this.rootRdr = GfoNdeRdr_.root_parseNot_(this.root);
        DataRdr sub = this.rootRdr.Subs_byName("no_match");
        Tfds.Eq_false(sub.MoveNextPeer());
    }

    @Test
    public void Xpath_moveFirst_basic() {
        this.root = this.fx.root_(this.leaf_("nde0", 0));
        this.tst_Xpath_first(this.root, "nde0", 0);
    }

    @Test
    public void Xpath_moveFirst_shallow() {
        this.root = this.fx.root_(this.leaf_("nde0", 0), this.leaf_("nde1", 1), this.leaf_("nde2", 2));
        this.tst_Xpath_first(this.root, "nde2", 2);
    }

    @Test
    public void Xpath_moveFirst_nested() {
        this.root = this.fx.root_(this.node_("nde0", Object_.Ary("0"), this.leaf_("nde00", "00")));
        this.tst_Xpath_first(this.root, "nde0", "0");
        this.tst_Xpath_first(this.root, "nde0/nde00", "00");
    }

    @Test
    public void Xpath_moveFirst_nested_similarName() {
        this.root = this.fx.root_(this.node_("nde0", Object_.Ary("0"), this.leaf_("nde00", "00")), this.node_("nde1", Object_.Ary("1"), this.leaf_("nde00", "10")));
        this.tst_Xpath_first(this.root, "nde1/nde00", "10");
    }

    @Test
    public void Xpath_moveFirst_many() {
        this.root = this.fx.root_(this.leaf_("root", 0), this.leaf_("root", 1), this.leaf_("root", 2));
        this.tst_Xpath_first(this.root, "root", 0);
    }

    @Test
    public void Xpath_moveFirst_null() {
        this.root = this.fx.root_(this.leaf_("nde0", 0), this.leaf_("nde1", 1), this.leaf_("nde2", 2));
        this.rootRdr = GfoNdeRdr_.root_parseNot_(this.root);
        DataRdr rdr = this.rootRdr.Subs_byName("nde3");
        Tfds.Eq_false(rdr.MoveNextPeer());
    }

    GfoNde leaf_(String name, Object ... vals) {
        return GfoNde_.nde_(name, vals, GfoNde_.Ary_empty);
    }

    GfoNde node_(String name, Object[] vals, GfoNde ... subs) {
        return GfoNde_.nde_(name, vals, subs);
    }

    void tst_NdeVals(GfoNde nde, Object ... exptVals) {
        GfoNdeRdr rdr = GfoNdeRdr_.root_parseNot_(nde);
        this.tst_RdrVals(rdr.Subs(), exptVals);
    }

    void tst_RdrVals(DataRdr rdr, Object[] exptVals) {
        int count = 0;
        while (rdr.MoveNextPeer()) {
            Object actl = rdr.ReadAt(0);
            Tfds.Eq(actl, exptVals[count++]);
        }
        Tfds.Eq(count, exptVals.length);
    }

    void tst_Xpath_first(GfoNde root, String xpath, Object expt) {
        GfoNdeRdr rdr = GfoNdeRdr_.root_parseNot_(root);
        DataRdr sel = rdr.Subs_byName_moveFirst(xpath);
        Object actl = sel.ReadAt(0);
        Tfds.Eq(actl, expt);
    }

    void tst_Xpath_all(GfoNde root, String xpath, Object ... exptVals) {
        GfoNdeRdr rdr = GfoNdeRdr_.root_parseNot_(root);
        this.tst_RdrVals(rdr.Subs_byName(xpath), exptVals);
    }
}

