/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.stores;

import gplx.Bool_;
import gplx.Bry_;
import gplx.Byte_;
import gplx.Char_;
import gplx.DateAdp;
import gplx.DateAdp_;
import gplx.Decimal_adp;
import gplx.Decimal_adp_;
import gplx.Double_;
import gplx.Err;
import gplx.Err_;
import gplx.Float_;
import gplx.Hash_adp;
import gplx.Hash_adp_;
import gplx.Int_;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.Keyval;
import gplx.Keyval_;
import gplx.List_adp;
import gplx.Long_;
import gplx.String_;
import gplx.UsrDlg_;
import gplx.UsrMsg;
import gplx.Virtual;
import gplx.core.ios.streams.Io_stream_rdr;
import gplx.core.ios.streams.Io_stream_rdr_;
import gplx.core.stores.DataRdr;
import gplx.core.stores.SrlMgr;
import gplx.core.stores.SrlObj;
import gplx.core.strings.String_bldr;
import gplx.core.type_xtns.BoolClassXtn;

public abstract class DataRdr_base
implements SrlMgr {
    private boolean parse;
    Io_url uri = Io_url_.Empty;
    Hash_adp envVars = Hash_adp_.New();

    public boolean Parse() {
        return this.parse;
    }

    public void Parse_set(boolean v) {
        this.parse = v;
    }

    public Io_url Uri() {
        return this.uri;
    }

    public void Uri_set(Io_url s) {
        this.uri = s;
    }

    public abstract String NameOfNode();

    @Override
    public boolean Type_rdr() {
        return true;
    }

    public Hash_adp EnvVars() {
        return this.envVars;
    }

    public abstract Object Read(String var1);

    public abstract int FieldCount();

    public abstract String KeyAt(int var1);

    public abstract Object ReadAt(int var1);

    @Virtual
    public Keyval KeyValAt(int idx) {
        return Keyval_.new_(this.KeyAt(idx), this.ReadAt(idx));
    }

    public String ReadStr(String key) {
        Object val = this.Read(key);
        try {
            return (String)val;
        }
        catch (Exception exc) {
            throw DataRdr_base.Err_dataRdr_ReadFailed_err(String.class, key, val, exc);
        }
    }

    public String ReadStrOr(String key, String or) {
        Object val = this.Read(key);
        if (val == null) {
            return or;
        }
        try {
            return (String)val;
        }
        catch (Exception exc) {
            DataRdr_base.Err_dataRdr_ReadFailed_useOr(exc, String.class, key, val, or);
            return or;
        }
    }

    public byte[] ReadBryByStr(String key) {
        return Bry_.new_u8(this.ReadStr(key));
    }

    public byte[] ReadBryByStrOr(String key, byte[] or) {
        Object val = this.Read(key);
        if (val == null) {
            return or;
        }
        try {
            return Bry_.new_u8((String)val);
        }
        catch (Exception exc) {
            DataRdr_base.Err_dataRdr_ReadFailed_useOr(exc, byte[].class, key, val, or);
            return or;
        }
    }

    @Override
    @Virtual
    public void SrlList(String key, List_adp list, SrlObj proto, String itmKey) {
        list.Clear();
        DataRdr subRdr = this.Subs_byName_moveFirst(key);
        subRdr = subRdr.Subs();
        while (subRdr.MoveNextPeer()) {
            SrlObj itm = proto.SrlObj_New(null);
            itm.SrlObj_Srl(subRdr);
            list.Add(itm);
        }
    }

    @Override
    @Virtual
    public Object StoreRoot(SrlObj root, String key) {
        SrlObj clone = root.SrlObj_New(null);
        clone.SrlObj_Srl(this);
        return clone;
    }

    public abstract DataRdr Subs_byName_moveFirst(String var1);

    public int ReadInt(String key) {
        Object val = this.Read(key);
        try {
            return this.parse ? Int_.parse(String_.as_(val)) : Int_.cast(val);
        }
        catch (Exception exc) {
            throw DataRdr_base.Err_dataRdr_ReadFailed_err(Integer.TYPE, key, val, exc);
        }
    }

    public int ReadIntOr(String key, int or) {
        Object val = this.Read(key);
        if (val == null) {
            return or;
        }
        try {
            return this.parse ? Int_.parse(String_.as_(val)) : Int_.cast(val);
        }
        catch (Exception exc) {
            DataRdr_base.Err_dataRdr_ReadFailed_useOr(exc, Integer.TYPE, key, val, or);
            return or;
        }
    }

    public long ReadLongOr(String key, long or) {
        Object val = this.Read(key);
        if (val == null) {
            return or;
        }
        try {
            return this.parse ? Long_.parse(String_.as_(val)) : Long_.cast(val);
        }
        catch (Exception exc) {
            DataRdr_base.Err_dataRdr_ReadFailed_useOr(exc, Long.TYPE, key, val, or);
            return or;
        }
    }

    @Virtual
    public boolean ReadBool(String key) {
        Object val = this.Read(key);
        try {
            return this.parse ? Bool_.Cast(BoolClassXtn.Instance.ParseOrNull(String_.as_(val))) : Bool_.Cast(val);
        }
        catch (Exception exc) {
            throw DataRdr_base.Err_dataRdr_ReadFailed_err(Boolean.TYPE, key, val, exc);
        }
    }

    @Virtual
    public boolean ReadBoolOr(String key, boolean or) {
        Object val = this.Read(key);
        if (val == null) {
            return or;
        }
        try {
            return this.parse ? Bool_.Parse(String_.as_(val)) : Bool_.Cast(val);
        }
        catch (Exception exc) {
            DataRdr_base.Err_dataRdr_ReadFailed_useOr(exc, Boolean.TYPE, key, val, or);
            return or;
        }
    }

    public long ReadLong(String key) {
        Object val = this.Read(key);
        try {
            return this.parse ? Long_.parse(String_.as_(val)) : Long_.cast(val);
        }
        catch (Exception exc) {
            throw DataRdr_base.Err_dataRdr_ReadFailed_err(Long.TYPE, key, val, exc);
        }
    }

    public float ReadFloat(String key) {
        Object val = this.Read(key);
        try {
            return this.parse ? Float_.parse(String_.as_(val)) : Float_.cast(val);
        }
        catch (Exception exc) {
            throw DataRdr_base.Err_dataRdr_ReadFailed_err(Float.TYPE, key, val, exc);
        }
    }

    public float ReadFloatOr(String key, float or) {
        Object val = this.Read(key);
        if (val == null) {
            return or;
        }
        try {
            return this.parse ? Float_.parse(String_.as_(val)) : Float_.cast(val);
        }
        catch (Exception exc) {
            DataRdr_base.Err_dataRdr_ReadFailed_useOr(exc, Float.TYPE, key, val, Float.valueOf(or));
            return or;
        }
    }

    public double ReadDouble(String key) {
        Object val = this.Read(key);
        try {
            return this.parse ? Double_.parse(String_.as_(val)) : Double_.cast(val);
        }
        catch (Exception exc) {
            throw DataRdr_base.Err_dataRdr_ReadFailed_err(Double.TYPE, key, val, exc);
        }
    }

    public double ReadDoubleOr(String key, double or) {
        Object val = this.Read(key);
        if (val == null) {
            return or;
        }
        try {
            return this.parse ? Double_.parse(String_.as_(val)) : Double_.cast(val);
        }
        catch (Exception exc) {
            DataRdr_base.Err_dataRdr_ReadFailed_useOr(exc, Double.TYPE, key, val, or);
            return or;
        }
    }

    @Virtual
    public byte ReadByte(String key) {
        Object val = this.Read(key);
        try {
            return this.parse ? Byte_.parse(String_.as_(val)) : Byte_.cast(val);
        }
        catch (Exception exc) {
            throw DataRdr_base.Err_dataRdr_ReadFailed_err(Byte.TYPE, key, val, exc);
        }
    }

    @Virtual
    public byte ReadByteOr(String key, byte or) {
        Object val = this.Read(key);
        if (val == null) {
            return or;
        }
        try {
            return this.parse ? Byte_.parse(String_.as_(val)) : Byte_.cast(val);
        }
        catch (Exception exc) {
            DataRdr_base.Err_dataRdr_ReadFailed_useOr(exc, Byte.TYPE, key, val, or);
            return or;
        }
    }

    @Virtual
    public DateAdp ReadDate(String key) {
        Object val = this.Read(key);
        try {
            return this.parse ? DateAdp_.parse_gplx(String_.as_(val)) : (DateAdp)val;
        }
        catch (Exception exc) {
            throw DataRdr_base.Err_dataRdr_ReadFailed_err(DateAdp.class, key, val, exc);
        }
    }

    @Virtual
    public DateAdp ReadDateOr(String key, DateAdp or) {
        Object val = this.Read(key);
        if (val == null) {
            return or;
        }
        try {
            return this.parse ? DateAdp_.parse_gplx(String_.as_(val)) : (DateAdp)val;
        }
        catch (Exception exc) {
            throw DataRdr_base.Err_dataRdr_ReadFailed_err(DateAdp.class, key, val, exc);
        }
    }

    @Virtual
    public Decimal_adp ReadDecimal(String key) {
        Object val = this.Read(key);
        try {
            if (this.parse) {
                return Decimal_adp_.parse(String_.as_(val));
            }
            Decimal_adp rv = Decimal_adp_.as_(val);
            return rv == null ? Decimal_adp_.db_(val) : rv;
        }
        catch (Exception exc) {
            throw DataRdr_base.Err_dataRdr_ReadFailed_err(Decimal_adp.class, key, val, exc);
        }
    }

    @Virtual
    public Decimal_adp ReadDecimalOr(String key, Decimal_adp or) {
        Object val = this.Read(key);
        if (val == null) {
            return or;
        }
        try {
            if (this.parse) {
                return Decimal_adp_.parse(String_.as_(val));
            }
            Decimal_adp rv = Decimal_adp_.as_(val);
            return rv == null ? Decimal_adp_.db_(val) : rv;
        }
        catch (Exception exc) {
            throw DataRdr_base.Err_dataRdr_ReadFailed_err(Decimal_adp.class, key, val, exc);
        }
    }

    public char ReadChar(String key) {
        Object val = this.Read(key);
        try {
            if (this.parse) {
                return Char_.parse(String_.as_(val));
            }
            return Char_.cast(val);
        }
        catch (Exception exc) {
            throw DataRdr_base.Err_dataRdr_ReadFailed_err(Character.TYPE, key, val, exc);
        }
    }

    public char ReadCharOr(String key, char or) {
        Object val = this.Read(key);
        if (val == null) {
            return or;
        }
        try {
            if (this.parse) {
                return Char_.parse(String_.as_(val));
            }
            return Char_.cast(val);
        }
        catch (Exception exc) {
            Err_.Noop(exc);
            return or;
        }
    }

    public byte[] ReadBry(String key) {
        Object val = this.Read(key);
        try {
            return (byte[])val;
        }
        catch (Exception exc) {
            throw DataRdr_base.Err_dataRdr_ReadFailed_err(byte[].class, key, val, exc);
        }
    }

    public byte[] ReadBryOr(String key, byte[] or) {
        Object val = this.Read(key);
        if (val == null) {
            return or;
        }
        try {
            return (byte[])val;
        }
        catch (Exception exc) {
            DataRdr_base.Err_dataRdr_ReadFailed_useOr(exc, byte[].class, key, val, or);
            return or;
        }
    }

    public Io_stream_rdr ReadRdr(String key) {
        return Io_stream_rdr_.Noop;
    }

    @Override
    public boolean SrlBoolOr(String key, boolean or) {
        return this.ReadBoolOr(key, or);
    }

    @Override
    public byte SrlByteOr(String key, byte or) {
        return this.ReadByteOr(key, or);
    }

    @Override
    public int SrlIntOr(String key, int or) {
        return this.ReadIntOr(key, or);
    }

    @Override
    public long SrlLongOr(String key, long or) {
        return this.ReadLongOr(key, or);
    }

    @Override
    public String SrlStrOr(String key, String or) {
        return this.ReadStrOr(key, or);
    }

    @Override
    public DateAdp SrlDateOr(String key, DateAdp or) {
        return this.ReadDateOr(key, or);
    }

    @Override
    public Decimal_adp SrlDecimalOr(String key, Decimal_adp or) {
        return this.ReadDecimalOr(key, or);
    }

    @Override
    public double SrlDoubleOr(String key, double or) {
        return this.ReadDoubleOr(key, or);
    }

    @Override
    public Object SrlObjOr(String key, Object or) {
        throw Err_.new_unimplemented();
    }

    public void XtoStr_gfml(String_bldr sb) {
        sb.Add(this.NameOfNode()).Add(":");
        int i = 0;
        while (i < this.FieldCount()) {
            Keyval kv = this.KeyValAt(i);
            if (i != 0) {
                sb.Add(" ");
            }
            sb.Add_fmt("{0}='{1}'", kv.Key(), String_.Replace(kv.Val_to_str_or_empty(), "'", "\""));
            ++i;
        }
        sb.Add(";");
    }

    public abstract DataRdr Subs();

    @Override
    public void TypeKey_(String v) {
    }

    @Override
    public abstract SrlMgr SrlMgr_new(Object var1);

    static Err Err_dataRdr_ReadFailed_err(Class<?> type, String key, Object val, Exception inner) {
        String innerMsg = inner == null ? "" : Err_.Message_lang(inner);
        return Err_.new_("DataRdr_ReadFailed", "failed to read data", "key", key, "val", val, "type", type, "innerMsg", innerMsg).Trace_ignore_add_1_();
    }

    static void Err_dataRdr_ReadFailed_useOr(Class<?> type, String key, Object val, Object or) {
        UsrDlg_.Instance.Warn(UsrMsg.new_("failed to read data; substituting default").Add("key", key).Add("val", val).Add("default", or).Add("type", type));
    }

    static void Err_dataRdr_ReadFailed_useOr(Exception exc, Class<?> type, String key, Object val, Object or) {
        UsrDlg_.Instance.Warn(UsrMsg.new_("failed to read data; substituting default").Add("key", key).Add("val", val).Add("default", or).Add("type", type));
    }
}

