/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.security;

import gplx.Array_;
import gplx.Bry_;
import gplx.String_;
import gplx.core.consoles.Console_adp;
import gplx.core.consoles.Console_adp_;
import gplx.core.ios.streams.IoStream;
import gplx.core.ios.streams.IoStream_;
import gplx.core.progs.Gfo_prog_ui;
import gplx.core.security.HashDlgWtr;
import gplx.core.security.HashDlgWtr_;
import gplx.core.security.Hash_algo;
import gplx.core.security.Hash_algo_utl_;
import gplx.core.security.Tiger192;

public class Hash_algo__tth_192
implements Hash_algo {
    public static final String KEY = "tth192";
    int blockSize = 1024;
    Tiger192 algo = new Tiger192();
    byte[][] hashMain;
    int hashMainCount = 0;
    byte[] blockA;
    byte[] blockB;
    byte[] branchRv;
    byte[] leaf0;
    byte[] leaf1;

    @Override
    public String Key() {
        return KEY;
    }

    public int BlockSize() {
        return this.blockSize;
    }

    public void BlockSize_set(int v) {
        this.blockSize = v;
    }

    @Override
    public String Hash_bry_as_str(byte[] src) {
        return String_.new_a7(this.Hash_bry_as_bry(src));
    }

    @Override
    public byte[] Hash_bry_as_bry(byte[] v) {
        return Bry_.new_a7(this.Hash_stream_as_str(Console_adp_.Noop, IoStream_.ary_(v)));
    }

    @Override
    public byte[] Hash_stream_as_bry(Gfo_prog_ui prog_ui, IoStream stream) {
        return Bry_.new_a7(this.Hash_stream_as_str(Console_adp_.Noop, stream));
    }

    @Override
    public String Hash_stream_as_str(Console_adp dialog, IoStream stream) {
        int leafCount = (int)(stream.Len() / (long)this.blockSize);
        HashDlgWtr dialogWtr = HashDlgWtr_.Current;
        dialogWtr.Bgn(dialog, stream.Url(), this.CalcWorkUnits(stream.Len()));
        if (stream.Len() % (long)this.blockSize > 0L) {
            ++leafCount;
        } else if (stream.Len() == 0L) {
            leafCount = 1;
        }
        this.hashMain = new byte[leafCount / 2 + 1][];
        this.hashMainCount = 0;
        this.HashAllBytes(dialogWtr, stream, leafCount);
        byte[] rv = this.HashAllHashes(dialogWtr);
        return Hash_algo_utl_.To_base_32_str(rv);
    }

    byte[] CalcHash_next(IoStream stream) {
        if (this.blockA == null || this.blockA.length != this.blockSize) {
            this.blockA = new byte[this.blockSize];
        }
        if (this.blockB == null || this.blockB.length != this.blockSize) {
            this.blockB = new byte[this.blockSize];
        }
        int dataSize = stream.Read(this.blockA, 0, this.blockSize);
        dataSize = stream.Read(this.blockB, 0, this.blockSize);
        if (dataSize < this.blockSize) {
            this.blockB = this.ShrinkArray(this.blockB, dataSize);
        }
        return this.CalcHash_branch(this.CalcHash_leaf(this.blockA, 0), this.CalcHash_leaf(this.blockB, 1));
    }

    void HashAllBytes(HashDlgWtr dialogWtr, IoStream stream, int leafCount) {
        int total = leafCount / 2;
        int i = 0;
        while (i < total) {
            if (dialogWtr.Canceled()) {
                dialogWtr.Fail(stream);
            }
            this.hashMain[this.hashMainCount++] = this.CalcHash_next(stream);
            dialogWtr.Do(2);
            ++i;
        }
        if (leafCount % 2 == 1) {
            byte[] block = new byte[this.blockSize];
            int dataSize = stream.Read(block, 0, this.blockSize);
            if (dataSize < this.blockSize) {
                block = this.ShrinkArray(block, dataSize);
            }
            this.hashMain[this.hashMainCount++] = this.CalcHash_leaf(block, 0);
            dialogWtr.Do(1);
        }
        stream.Rls();
    }

    /*
     * Unable to fully structure code
     */
    byte[] HashAllHashes(HashDlgWtr dialogWtr) {
        currIdx = 0;
        lastIdx = this.hashMainCount - 1;
        reuseIdx = 0;
        ** GOTO lbl16
        {
            hashA = this.hashMain[currIdx++];
            hashB = this.hashMain[currIdx++];
            this.hashMain[reuseIdx++] = this.CalcHash_branch(hashA, hashB);
            dialogWtr.Do(2);
            do {
                if (currIdx < lastIdx) continue block0;
                if (currIdx == lastIdx) {
                    this.hashMain[reuseIdx++] = this.hashMain[currIdx++];
                }
                lastIdx = reuseIdx - 1;
                currIdx = 0;
                reuseIdx = 0;
lbl16:
                // 2 sources

            } while (currIdx < lastIdx);
        }
        dialogWtr.End();
        return this.hashMain[lastIdx];
    }

    byte[] CalcHash_branch(byte[] blockA, byte[] blockB) {
        if (this.branchRv == null || this.branchRv.length != blockA.length + blockB.length + 1) {
            this.branchRv = new byte[blockA.length + blockB.length + 1];
        }
        this.branchRv[0] = 1;
        Array_.Copy_to(blockA, this.branchRv, 1);
        Array_.Copy_to(blockB, this.branchRv, blockA.length + 1);
        return this.CalcHash(this.branchRv);
    }

    byte[] CalcHash_leaf(byte[] raw, int i) {
        byte[] rv = null;
        if (i == 0) {
            if (this.leaf0 == null || this.leaf0.length != raw.length + 1) {
                this.leaf0 = new byte[raw.length + 1];
            }
            rv = this.leaf0;
        } else {
            if (this.leaf1 == null || this.leaf1.length != raw.length + 1) {
                this.leaf1 = new byte[raw.length + 1];
            }
            rv = this.leaf1;
        }
        rv[0] = 0;
        Array_.Copy_to(raw, rv, 1);
        return this.CalcHash(rv);
    }

    byte[] CalcHash(byte[] raw) {
        this.algo.Initialize();
        return this.algo.ComputeHash(raw);
    }

    byte[] ShrinkArray(byte[] raw, int newLen) {
        byte[] rv = new byte[newLen];
        int i = 0;
        while (i < newLen) {
            rv[i] = raw[i];
            ++i;
        }
        return rv;
    }

    public int CalcWorkUnits(long streamLength) {
        int leafCount;
        int phase1 = leafCount = (int)(streamLength / (long)this.blockSize);
        if (leafCount == 0) {
            phase1 = 1;
        } else if (streamLength % (long)this.blockSize != 0L) {
            ++phase1;
        }
        int phase2 = phase1 <= 1 ? 0 : phase1 - 1;
        return phase1 + phase2;
    }
}

