/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios.zips;

import gplx.Err_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.String_;
import gplx.core.envs.Op_sys;
import gplx.core.ios.zips.Io_zip_mgr;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Io_zip_mgr_base
implements Io_zip_mgr {
    byte[] tmp = new byte[4096];
    int tmpLen = 4096;
    public static final Io_zip_mgr Instance = new Io_zip_mgr_base();

    @Override
    public void Zip_fil(Io_url src_fil, Io_url trg_fil) {
        byte[] src_bry = Io_mgr.Instance.LoadFilBry(src_fil);
        byte[] trg_bry = this.Zip_bry(src_bry, 0, src_bry.length);
        Io_mgr.Instance.SaveFilBry(trg_fil, trg_bry);
    }

    @Override
    public void Zip_dir(Io_url src_dir, Io_url trg_fil) {
        try {
            byte[] bry = new byte[4096];
            FileOutputStream fil_strm = new FileOutputStream(trg_fil.Raw());
            ZipOutputStream zip_strm = new ZipOutputStream(fil_strm);
            this.Zip_dir__add_dir(zip_strm, bry, "", src_dir, this.Zip_dir__get_subs(src_dir));
            zip_strm.flush();
            zip_strm.close();
        }
        catch (IOException e) {
            Err_.new_exc(e, "io", "error duing zip", "src", src_dir.Raw(), "trg", trg_fil.Raw());
        }
    }

    private void Zip_dir__add_dir(ZipOutputStream zip_strm, byte[] bry, String zip_path, Io_url owner_dir, Io_url[] subs) {
        int len = subs.length;
        int i = 0;
        while (i < len) {
            Io_url sub = subs[i];
            String sub_path = String.valueOf(zip_path) + sub.NameAndExt_noDirSpr();
            if (sub.Type_dir()) {
                this.Zip_dir__add_dir(zip_strm, bry, String.valueOf(sub_path) + "/", sub, this.Zip_dir__get_subs(sub));
            } else {
                this.Zip_dir__add_fil(zip_strm, bry, sub_path, sub);
            }
            ++i;
        }
    }

    private void Zip_dir__add_fil(ZipOutputStream zip_strm, byte[] bry, String zip_path, Io_url fil_url) {
        try {
            int len;
            FileInputStream fil_strm = new FileInputStream(fil_url.Raw());
            zip_strm.putNextEntry(new ZipEntry(zip_path));
            while ((len = fil_strm.read(bry)) > 0) {
                zip_strm.write(bry, 0, len);
            }
            fil_strm.close();
        }
        catch (IOException e) {
            throw Err_.new_exc(e, "io", "error duing zip", "src", zip_path);
        }
    }

    private Io_url[] Zip_dir__get_subs(Io_url url) {
        return Io_mgr.Instance.QueryDir_args(url).DirInclude_().ExecAsUrlAry();
    }

    @Override
    public byte[] Zip_bry(byte[] src, int bgn, int len) {
        ByteArrayInputStream src_stream = new ByteArrayInputStream(src, bgn, len);
        ByteArrayOutputStream trg_stream = new ByteArrayOutputStream(len);
        try {
            int count;
            ZipOutputStream trgZip = new ZipOutputStream(trg_stream);
            ZipEntry entry = new ZipEntry("file");
            trgZip.putNextEntry(entry);
            while ((count = src_stream.read(this.tmp, 0, this.tmpLen)) != -1) {
                trgZip.write(this.tmp, 0, count);
            }
            trgZip.close();
        }
        catch (Exception e) {
            throw Err_.new_wo_type("failed to zip", "err", e.getMessage());
        }
        return trg_stream.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] Unzip_bry(byte[] src, int bgn, int len) {
        ByteArrayInputStream src_stream = new ByteArrayInputStream(src, bgn, len);
        ByteArrayOutputStream trg_stream = new ByteArrayOutputStream(len);
        try {
            ZipInputStream srcZip = new ZipInputStream(src_stream);
            block2: while (true) {
                if (srcZip.getNextEntry() == null) {
                    return trg_stream.toByteArray();
                }
                while (true) {
                    int count;
                    if ((count = srcZip.read(this.tmp, 0, this.tmpLen)) == -1) continue block2;
                    trg_stream.write(this.tmp, 0, count);
                }
                break;
            }
        }
        catch (Exception e) {
            throw Err_.new_wo_type("failed to unzip", "err", e.getMessage());
        }
    }

    @Override
    public void Unzip_to_dir(Io_url src_fil, Io_url trg_dir) {
        byte[] buffer = new byte[4096];
        try {
            Io_mgr.Instance.CreateDirIfAbsent(trg_dir);
            ZipInputStream zip_strm = new ZipInputStream(new FileInputStream(src_fil.Raw()));
            ZipEntry zip_eny = zip_strm.getNextEntry();
            while (zip_eny != null) {
                String itm_name = zip_eny.getName();
                if (Op_sys.Cur().Tid_is_wnt()) {
                    itm_name = String_.Replace(itm_name, "/", "\\");
                }
                Io_url itm_url = Io_url_.new_any_(trg_dir.GenSubFil(itm_name).Raw());
                Io_mgr.Instance.CreateDirIfAbsent(itm_url.OwnerDir());
                if (itm_url.Type_fil()) {
                    int len;
                    Io_mgr.Instance.SaveFilStr_args(itm_url, "").Exec();
                    File itm_file = new File(itm_url.Raw());
                    FileOutputStream itm_strm = new FileOutputStream(itm_file);
                    while ((len = zip_strm.read(buffer)) > 0) {
                        itm_strm.write(buffer, 0, len);
                    }
                    itm_strm.close();
                }
                zip_eny = zip_strm.getNextEntry();
            }
            zip_strm.closeEntry();
            zip_strm.close();
        }
        catch (IOException e) {
            throw Err_.new_exc(e, "io", "error duing unzip", "src", src_fil.Raw(), "trg", trg_dir.Raw());
        }
    }
}

