/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios.streams;

import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Err_;
import gplx.Io_url;
import gplx.String_;
import gplx.core.ios.streams.Io_stream_rdr;
import gplx.core.ios.streams.rdrs.Io_stream_rdr__adp;
import gplx.core.ios.streams.rdrs.Io_stream_rdr__bzip2;
import gplx.core.ios.streams.rdrs.Io_stream_rdr__gzip;
import gplx.core.ios.streams.rdrs.Io_stream_rdr__noop;
import gplx.core.ios.streams.rdrs.Io_stream_rdr__raw;
import gplx.core.ios.streams.rdrs.Io_stream_rdr__xz;
import gplx.core.ios.streams.rdrs.Io_stream_rdr__zip;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class Io_stream_rdr_ {
    public static final int Read_done = -1;
    public static final int Read_done_compare = 1;
    public static final Io_stream_rdr Noop = new Io_stream_rdr__noop();

    public static Io_stream_rdr New__raw(Io_url url) {
        return new Io_stream_rdr__raw().Url_(url);
    }

    public static Io_stream_rdr New__raw(InputStream strm) {
        return new Io_stream_rdr__raw().Under_(strm);
    }

    private static Io_stream_rdr New__zip(Io_url url) {
        return new Io_stream_rdr__zip().Url_(url);
    }

    private static Io_stream_rdr New__gzip(Io_url url) {
        return new Io_stream_rdr__gzip().Url_(url);
    }

    public static Io_stream_rdr New__bzip2(Io_url url) {
        return new Io_stream_rdr__bzip2().Url_(url);
    }

    public static Io_stream_rdr New__mem(String v) {
        return Io_stream_rdr_.New__mem(Bry_.new_u8(v));
    }

    public static Io_stream_rdr New__mem(byte[] v) {
        Io_stream_rdr__adp rv = new Io_stream_rdr__adp(Io_stream_rdr_.New__mem_as_stream(v));
        rv.Len_(v.length);
        return rv;
    }

    public static InputStream New__mem_as_stream(byte[] v) {
        return new ByteArrayInputStream(v);
    }

    public static Io_stream_rdr New_by_url(Io_url url) {
        String ext = url.Ext();
        if (String_.Eq(ext, ".zip")) {
            return Io_stream_rdr_.New__zip(url);
        }
        if (String_.Eq(ext, ".gz")) {
            return Io_stream_rdr_.New__gzip(url);
        }
        if (String_.Eq(ext, ".bz2")) {
            return Io_stream_rdr_.New__bzip2(url);
        }
        if (String_.Eq(ext, ".xz")) {
            return new Io_stream_rdr__xz().Url_(url);
        }
        return Io_stream_rdr_.New__raw(url);
    }

    public static Io_stream_rdr New_by_tid(byte tid) {
        switch (tid) {
            case 1: {
                return new Io_stream_rdr__raw();
            }
            case 2: {
                return new Io_stream_rdr__zip();
            }
            case 3: {
                return new Io_stream_rdr__gzip();
            }
            case 4: {
                return new Io_stream_rdr__bzip2();
            }
            case 5: {
                return new Io_stream_rdr__xz();
            }
        }
        throw Err_.new_unhandled_default(tid);
    }

    public static String Load_all_as_str(Io_stream_rdr rdr) {
        return String_.new_u8(Io_stream_rdr_.Load_all_as_bry(Bry_bfr_.New(), rdr));
    }

    public static byte[] Load_all_as_bry(Bry_bfr rv, Io_stream_rdr rdr) {
        Io_stream_rdr_.Load_all_to_bfr(rv, rdr);
        return rv.To_bry_and_clear();
    }

    public static void Load_all_to_bfr(Bry_bfr rv, Io_stream_rdr rdr) {
        try {
            int read;
            byte[] bry = new byte[4096];
            while ((read = rdr.Read(bry, 0, 4096)) >= 1) {
                rv.Add_mid(bry, 0, read);
            }
        }
        finally {
            rdr.Rls();
        }
    }

    public static int Read_by_parts(InputStream stream, int part_len, byte[] bry, int bgn, int len) {
        try {
            int rv = 0;
            int end = bgn + len;
            int cur = bgn;
            while (true) {
                int read;
                int bry_len;
                if (cur + (bry_len = part_len) > end) {
                    bry_len = end - cur;
                }
                if (cur == end || (read = stream.read(bry, cur, bry_len)) == -1) break;
                rv += read;
                cur += read;
            }
            return rv;
        }
        catch (Exception exc) {
            throw Err_.new_exc(exc, "io", "read failed", "bgn", bgn, "len", len);
        }
    }

    public static boolean Close(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
            return true;
        }
        catch (Exception e) {
            Err_.Noop(e);
            return false;
        }
    }
}

