/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.DateAdp_;
import gplx.Err_;
import gplx.Gfo_usr_dlg;
import gplx.Int_;
import gplx.Io_url;
import gplx.Long_;
import gplx.Type_adp_;
import gplx.core.ios.IoEngine_system;
import gplx.core.ios.IoEngine_xrg_downloadFil;
import gplx.core.ios.Io_download_fmt;
import gplx.core.ios.Io_download_http;
import gplx.core.ios.streams.Io_stream_rdr;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;

class Io_stream_rdr_http
implements Io_stream_rdr {
    private IoEngine_xrg_downloadFil xrg;
    private boolean exists = false;
    private Io_url url;
    private long len = -1L;
    private String src_str;
    private HttpURLConnection src_conn;
    private BufferedInputStream src_stream;
    private Io_download_fmt xfer_fmt;
    private Gfo_usr_dlg prog_dlg;
    private boolean read_done = true;
    private boolean read_failed = false;
    private Io_url session_fil = null;
    private boolean rls_done = false;

    public Io_stream_rdr_http(IoEngine_xrg_downloadFil xrg) {
        this.xrg = xrg;
    }

    @Override
    public byte Tid() {
        return 1;
    }

    @Override
    public boolean Exists() {
        return this.exists;
    }

    @Override
    public Io_url Url() {
        return this.url;
    }

    @Override
    public Io_stream_rdr Url_(Io_url v) {
        this.url = v;
        return this;
    }

    @Override
    public long Len() {
        return this.len;
    }

    @Override
    public Io_stream_rdr Len_(long v) {
        this.len = v;
        return this;
    }

    @Override
    public Io_stream_rdr Open() {
        if (Io_download_http.User_agent_reset_needed) {
            Io_download_http.User_agent_reset();
        }
        if (!IoEngine_system.Web_access_enabled) {
            this.read_failed = true;
            this.read_done = true;
            if (this.prog_dlg != null) {
                this.prog_dlg.Log_wkr().Log_msg_to_url_fmt(this.session_fil, "download disabled: src='~{0}' trg='~{1}'", this.xrg.Src(), this.xrg.Trg().Raw());
            }
            return this;
        }
        this.src_str = this.xrg.Src();
        this.xfer_fmt = this.xrg.Download_fmt();
        this.prog_dlg = this.xfer_fmt.Usr_dlg();
        try {
            this.src_conn = (HttpURLConnection)new URL(this.src_str).openConnection();
            String user_agent = this.xrg.User_agent();
            if (user_agent != null) {
                this.src_conn.setRequestProperty("User-Agent", user_agent);
            }
            long content_length = Long_.parse_or(this.src_conn.getHeaderField("Content-Length"), -1L);
            this.xrg.Src_content_length_(content_length);
            this.len = content_length;
            if (this.xrg.Src_last_modified_query()) {
                this.xrg.Src_last_modified_(DateAdp_.unixtime_lcl_ms_(this.src_conn.getLastModified()));
            }
            if (this.xrg.Exec_meta_only()) {
                this.read_done = true;
                return this;
            }
            this.read_done = false;
            this.exists = Int_.In(this.src_conn.getResponseCode(), 200, 301);
            this.src_stream = new BufferedInputStream(this.src_conn.getInputStream());
            this.xfer_fmt.Bgn(content_length);
        }
        catch (Exception e) {
            this.Err_handle(e);
        }
        return this;
    }

    @Override
    public void Open_mem(byte[] v) {
    }

    @Override
    public Object Under() {
        return this.src_stream;
    }

    @Override
    public int Read(byte[] bry, int bgn, int len) {
        if (this.read_done) {
            return -1;
        }
        if (this.xrg.Prog_cancel()) {
            this.read_failed = true;
            return -1;
        }
        try {
            int read = this.src_stream.read(bry, bgn, len);
            this.xfer_fmt.Prog(read);
            return read;
        }
        catch (Exception e) {
            this.Err_handle(e);
            return -1;
        }
    }

    @Override
    public long Skip(long len) {
        return 0L;
    }

    @Override
    public void Rls() {
        if (this.rls_done) {
            return;
        }
        try {
            try {
                this.read_done = true;
                if (this.prog_dlg != null) {
                    this.xfer_fmt.Term();
                }
                if (this.session_fil == null && this.prog_dlg != null) {
                    this.session_fil = this.prog_dlg.Log_wkr().Session_dir().GenSubFil("internet.txt");
                }
                if (!this.read_failed) {
                    if (this.prog_dlg != null) {
                        this.prog_dlg.Log_wkr().Log_msg_to_url_fmt(this.session_fil, "download pass: src='~{0}' trg='~{1}'", this.src_str, this.xrg.Trg().Raw());
                    }
                    this.xrg.Rslt_((byte)0);
                }
                this.xrg.Prog_running_(false);
            }
            catch (Exception e) {
                Err_.Noop(e);
                try {
                    if (this.src_stream != null) {
                        this.src_stream.close();
                    }
                }
                catch (Exception e2) {
                    Err_.Noop(e2);
                }
                if (this.src_conn != null) {
                    this.src_conn.disconnect();
                }
                this.src_stream = null;
                this.src_conn = null;
                this.rls_done = true;
            }
        }
        finally {
            try {
                if (this.src_stream != null) {
                    this.src_stream.close();
                }
            }
            catch (Exception e) {
                Err_.Noop(e);
            }
            if (this.src_conn != null) {
                this.src_conn.disconnect();
            }
            this.src_stream = null;
            this.src_conn = null;
            this.rls_done = true;
        }
    }

    private void Err_handle(Exception exc) {
        this.read_failed = true;
        this.read_done = true;
        this.len = -1L;
        this.xrg.Rslt_err_(exc);
        if (Type_adp_.Eq_typeSafe(exc, UnknownHostException.class)) {
            this.xrg.Rslt_((byte)1);
        } else if (Type_adp_.Eq_typeSafe(exc, FileNotFoundException.class)) {
            this.xrg.Rslt_((byte)2);
        } else {
            this.xrg.Rslt_((byte)3);
        }
        if (this.prog_dlg != null && !this.xrg.Prog_cancel()) {
            if (this.session_fil == null) {
                this.session_fil = this.prog_dlg.Log_wkr().Session_dir().GenSubFil("internet.txt");
            }
            this.prog_dlg.Log_wkr().Log_msg_to_url_fmt(this.session_fil, "download fail: src='~{0}' trg='~{1}' error='~{2}'", this.src_str, this.xrg.Trg().Raw(), Err_.Message_lang(exc));
        }
        this.Rls();
    }
}

