/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.Array_;
import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Decimal_adp;
import gplx.Decimal_adp_;
import gplx.Err_;
import gplx.GfoMsg;
import gplx.Long_;
import gplx.Math_;
import gplx.String_;

public class Io_size_ {
    private static final String[][] Units = new String[][]{String_.Ary("B", "BYTE"), String_.Ary("KB", "KILOBYTE"), String_.Ary("MB", "MEGABYTE"), String_.Ary("GB", "GIGABYTE"), String_.Ary("TB", "TERABYTE"), String_.Ary("PB", "PETABYTE"), String_.Ary("EB", "EXABYTE")};
    public static final byte[][] Units_bry = new byte[][]{Bry_.new_a7("B"), Bry_.new_a7("KB"), Bry_.new_a7("MB"), Bry_.new_a7("GB"), Bry_.new_a7("TB"), Bry_.new_a7("PB"), Bry_.new_a7("EB")};

    public static String To_str(long val) {
        return Io_size_.To_str(val, "#,##0.000");
    }

    public static String To_str(long val, String val_fmt) {
        long cur = val;
        int pow = 0;
        while (cur >= 1024L) {
            cur /= 1024L;
            ++pow;
        }
        long div = (long)Math_.Pow(1024.0, pow);
        Decimal_adp valDecimal = Decimal_adp_.divide_(val, div);
        String[] unit = Units[pow];
        return String.valueOf(valDecimal.To_str(val_fmt)) + " " + String_.PadBgn(unit[0], 2, " ");
    }

    public static String To_str(long val, int exp_1024, String val_fmt, String unit_pad, boolean round_0_to_1) {
        long exp_val = (long)Math_.Pow(1024.0, exp_1024);
        Decimal_adp val_as_decimal = Decimal_adp_.divide_(val, exp_val);
        if (round_0_to_1 && val_as_decimal.Comp_lt(1)) {
            val_as_decimal = Decimal_adp_.One;
        }
        String[] unit = Units[exp_1024];
        return String.valueOf(val_as_decimal.To_str(val_fmt)) + " " + String_.PadBgn(unit[0], 2, unit_pad);
    }

    public static String To_str_new(Bry_bfr bfr, long val, int decimal_places) {
        Io_size_.To_bfr_new(bfr, val, decimal_places);
        return bfr.To_str_and_clear();
    }

    public static void To_bfr_new(Bry_bfr bfr, long val, int decimal_places) {
        int unit_idx = 0;
        int mult = 1024;
        long cur_val = val;
        long cur_exp = 1L;
        long nxt_exp = mult;
        unit_idx = 0;
        while (unit_idx < 6) {
            if (cur_val < nxt_exp) break;
            cur_exp = nxt_exp;
            nxt_exp *= (long)mult;
            ++unit_idx;
        }
        int int_val = (int)(val / cur_exp);
        int dec_val = (int)(val % cur_exp);
        if (decimal_places == 0) {
            if ((double)dec_val >= 0.5) {
                ++int_val;
            }
            dec_val = 0;
        } else {
            long dec_factor = 0L;
            switch (decimal_places) {
                case 1: {
                    dec_factor = 10L;
                    break;
                }
                case 2: {
                    dec_factor = 100L;
                    break;
                }
                default: {
                    dec_factor = 1000L;
                }
            }
            dec_val = (int)((long)dec_val * dec_factor / cur_exp);
        }
        String unit_str = "";
        switch (unit_idx) {
            case 0: {
                unit_str = " B";
                break;
            }
            case 1: {
                unit_str = " KB";
                break;
            }
            case 2: {
                unit_str = " MB";
                break;
            }
            case 3: {
                unit_str = " GB";
                break;
            }
            case 4: {
                unit_str = " PB";
                break;
            }
            default: {
                unit_str = " EB";
            }
        }
        bfr.Add_long_variable(int_val);
        if (decimal_places > 0 && unit_idx != 0) {
            bfr.Add_byte_dot();
            bfr.Add_long_variable(dec_val);
        }
        bfr.Add_str_a7(unit_str);
    }

    public static long parse_or(String raw, long or) {
        String unitStr;
        if (raw == null || raw == "") {
            return or;
        }
        String[] terms = String_.Split(raw, " ");
        int termsLen = Array_.Len(terms);
        if (termsLen > 2) {
            return or;
        }
        Decimal_adp val = null;
        try {
            val = Decimal_adp_.parse(terms[0]);
        }
        catch (Exception exc) {
            Err_.Noop(exc);
            return or;
        }
        int unitPow = 0;
        if (termsLen > 1 && (unitPow = Io_size_.parse_unitPow_(unitStr = String_.Upper(terms[1]))) == -1) {
            return or;
        }
        int curPow = unitPow;
        while (curPow > 0) {
            val = val.Multiply(1024L);
            --curPow;
        }
        return val.To_long();
    }

    private static int parse_unitPow_(String unitStr) {
        int unitLen = Array_.Len(Units);
        int unitPow = -1;
        int i = 0;
        while (i < unitLen) {
            if (String_.Eq(unitStr, String_.Upper(Units[i][0]))) {
                return i;
            }
            if (String_.Eq(unitStr, String_.Upper(Units[i][1]))) {
                return i;
            }
            ++i;
        }
        return unitPow;
    }

    public static int Load_int_(GfoMsg m) {
        return (int)Io_size_.Load_long_(m);
    }

    public static long Load_long_(GfoMsg m) {
        String v = m.ReadStr("v");
        long rv = Io_size_.parse_or(v, Long.MIN_VALUE);
        if (rv == Long.MIN_VALUE) {
            throw Err_.new_wo_type("invalid val", "val", v);
        }
        return rv;
    }

    public static String To_str_mb(long v) {
        return Long_.To_str(v / 0x100000L);
    }

    public static long To_long_by_int_mb(int v) {
        return (long)v * 0x100000L;
    }

    public static long To_long_by_msg_mb(GfoMsg m, long cur) {
        long val = m.ReadLongOr("v", Integer.MIN_VALUE);
        return val == Integer.MIN_VALUE ? cur : val * 0x100000L;
    }
}

