/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.Internal;
import gplx.String_;
import gplx.Virtual;
import gplx.core.ios.IoUrlInfo;

abstract class IoUrlInfo_base
implements IoUrlInfo {
    @Internal
    protected static final int DirSprLen = 1;
    @Internal
    protected static final String NullString = "";
    @Internal
    protected static final String ExtSeparator = ".";
    static final int OwnerDirPos_hasNoOwner = -1;
    static final int OwnerDirPos_isNull = -2;
    static final int OwnerDirPos_isRoot = -3;

    IoUrlInfo_base() {
    }

    @Override
    public abstract String Key();

    @Override
    public abstract byte DirSpr_byte();

    @Override
    public abstract String DirSpr();

    @Override
    public abstract boolean CaseSensitive();

    @Override
    public abstract boolean Match(String var1);

    @Override
    public abstract String EngineKey();

    @Override
    public boolean IsDir(String raw) {
        return String_.Has_at_end(raw, this.DirSpr());
    }

    @Override
    public abstract String XtoRootName(String var1, int var2);

    @Override
    @Virtual
    public String Xto_api(String raw) {
        return this.IsDir(raw) ? String_.DelEnd(raw, 1) : raw;
    }

    @Override
    public String OwnerDir(String raw) {
        int rawLen = String_.Len(raw);
        int ownerDirSprPos = this.OwnerDirPos(raw, rawLen);
        if (ownerDirSprPos <= -1) {
            return NullString;
        }
        return String_.MidByLen(raw, 0, ownerDirSprPos + 1);
    }

    @Override
    @Virtual
    public String OwnerRoot(String raw) {
        String temp = raw;
        String rv = raw;
        while (!String_.Eq(temp = this.OwnerDir(temp), NullString)) {
            rv = temp;
        }
        return rv;
    }

    @Override
    public String NameAndExt(String raw) {
        int rawLen = String_.Len(raw);
        int ownerDirSprPos = this.OwnerDirPos(raw, rawLen);
        if (ownerDirSprPos == -2) {
            return NullString;
        }
        return ownerDirSprPos == -1 || ownerDirSprPos == -3 ? raw : String_.DelBgn(raw, ownerDirSprPos + 1);
    }

    @Override
    public String NameOnly(String raw) {
        String nameAndExt = this.NameAndExt(raw);
        if (this.IsDir(raw)) {
            String rootName = this.XtoRootName(raw, String_.Len(raw));
            return rootName == null ? String_.DelEnd(nameAndExt, 1) : rootName;
        }
        int pos = String_.FindBwd(nameAndExt, ExtSeparator);
        return pos == -1 ? nameAndExt : String_.MidByLen(nameAndExt, 0, pos);
    }

    @Override
    public String Ext(String raw) {
        if (this.IsDir(raw)) {
            return this.DirSpr();
        }
        String nameAndExt = this.NameAndExt(raw);
        int pos = String_.FindBwd(nameAndExt, ExtSeparator);
        return pos == -1 ? NullString : String_.DelBgn(nameAndExt, pos);
    }

    int OwnerDirPos(String raw, int rawLen) {
        if (rawLen == 0) {
            return -2;
        }
        if (this.XtoRootName(raw, rawLen) != null) {
            return -3;
        }
        int posAdj = this.IsDir(raw) ? 1 : 0;
        return String_.FindBwd(raw, this.DirSpr(), rawLen - 1 - posAdj);
    }
}

