/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.Tfds;
import gplx.core.ios.IoUrlInfo_alias;
import org.junit.Test;

public class IoUrlInfo_alias_tst {
    IoUrlInfo_alias alias;

    @Test
    public void MapWntToWnt() {
        this.Make("usr:\\", "D:\\usr\\");
        this.tst_Xto_api("usr:\\dir\\fil.txt", "D:\\usr\\dir\\fil.txt");
        this.tst_OwnerDir("usr:\\dir\\", "usr:\\");
        this.tst_OwnerDir("usr:\\", "");
        this.tst_NameOnly("usr:\\", "usr");
    }

    @Test
    public void MapToLnx() {
        this.Make("usr:\\", "/home/");
        this.tst_Xto_api("usr:\\dir\\fil.txt", "/home/dir/fil.txt");
    }

    @Test
    public void MapLnxToWnt() {
        this.Make("usr:/", "C:\\usr\\");
        this.tst_Xto_api("usr:/dir/fil.txt", "C:\\usr\\dir\\fil.txt");
    }

    @Test
    public void WntToWnt() {
        this.Make("C:\\", "X:\\");
        this.tst_Xto_api("C:\\dir\\fil.txt", "X:\\dir\\fil.txt");
        this.tst_NameOnly("C:\\", "C");
    }

    @Test
    public void WntToLnx() {
        this.Make("C:\\", "/home/");
        this.tst_Xto_api("C:\\dir\\fil.txt", "/home/dir/fil.txt");
    }

    @Test
    public void LnxToWnt() {
        this.Make("/home/", "C:\\");
        this.tst_Xto_api("/home/dir/fil.txt", "C:\\dir\\fil.txt");
        this.tst_NameOnly("/home/", "home");
        this.tst_NameOnly("/", "root");
    }

    void tst_Xto_api(String raw, String expd) {
        Tfds.Eq(expd, this.alias.Xto_api(raw));
    }

    void tst_OwnerDir(String raw, String expd) {
        Tfds.Eq(expd, this.alias.OwnerDir(raw));
    }

    void tst_NameOnly(String raw, String expd) {
        Tfds.Eq(expd, this.alias.NameOnly(raw));
    }

    void Make(String srcDir, String trgDir) {
        this.alias = IoUrlInfo_alias.new_(srcDir, trgDir, "sys");
    }
}

