/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.Err_;
import gplx.Io_url;
import gplx.Rls_able;
import gplx.String_;
import gplx.core.consoles.Console_adp;
import gplx.core.criterias.Criteria;
import gplx.core.ios.IoEngine;
import gplx.core.ios.IoEnginePool;
import gplx.core.ios.IoEngine_xrg_deleteDir;
import gplx.core.ios.IoEngine_xrg_deleteFil;
import gplx.core.ios.IoEngine_xrg_openWrite;
import gplx.core.ios.IoEngine_xrg_queryDir;
import gplx.core.ios.IoEngine_xrg_recycleFil;
import gplx.core.ios.IoEngine_xrg_xferDir;
import gplx.core.ios.IoEngine_xrg_xferFil;
import gplx.core.ios.IoItmDir;
import gplx.core.ios.IoItmDir_;
import gplx.core.ios.IoItmFil;
import gplx.core.ios.IoItmList;
import gplx.core.ios.streams.IoStream;

class IoEngineUtl {
    int bufferLength = 4096;

    public int BufferLength() {
        return this.bufferLength;
    }

    public void BufferLength_set(int v) {
        this.bufferLength = v;
    }

    public void DeleteRecycleGplx(IoEngine engine, IoEngine_xrg_recycleFil xrg) {
        Io_url recycleUrl = xrg.RecycleUrl();
        if (recycleUrl.Type_fil()) {
            engine.MoveFil(IoEngine_xrg_xferFil.move_(xrg.Url(), recycleUrl).Overwrite_(false).ReadOnlyFails_(true));
        } else {
            engine.MoveDirDeep(IoEngine_xrg_xferDir.move_(xrg.Url(), recycleUrl).Overwrite_(false).ReadOnlyFails_(true));
        }
    }

    public void DeleteDirDeep(IoEngine engine, Io_url dirUrl, IoEngine_xrg_deleteDir args) {
        Console_adp usrDlg = args.UsrDlg();
        IoItmDir dir = engine.QueryDir(dirUrl);
        if (!dir.Exists()) {
            return;
        }
        for (Object subDirObj : dir.SubDirs()) {
            IoItmDir subDir = (IoItmDir)subDirObj;
            if (!args.SubDirScanCrt().Matches(subDir) || !args.Recur()) continue;
            this.DeleteDirDeep(engine, subDir.Url(), args);
        }
        for (Object subFilObj : dir.SubFils()) {
            IoItmFil subFil = (IoItmFil)subFilObj;
            if (!args.MatchCrt().Matches(subFil)) continue;
            Io_url subFilUrl = subFil.Url();
            try {
                engine.DeleteFil_api(IoEngine_xrg_deleteFil.new_(subFilUrl).ReadOnlyFails_(args.ReadOnlyFails()));
            }
            catch (Exception exc) {
                usrDlg.Write_fmt_w_nl(Err_.Message_lang(exc), new Object[0]);
            }
        }
        if (!args.MatchCrt().Matches(dir)) {
            return;
        }
        try {
            engine.DeleteDir(dir.Url());
        }
        catch (Exception exc) {
            usrDlg.Write_fmt_w_nl(Err_.Message_lang(exc), new Object[0]);
        }
    }

    public void XferDir(IoEngine srcEngine, Io_url src, IoEngine trgEngine, Io_url trg, IoEngine_xrg_xferDir args) {
        IoItmFil srcFil;
        trgEngine.CreateDir(trg);
        IoItmDir srcDir = this.QueryDirDeep(srcEngine, IoEngine_xrg_queryDir.new_(src).Recur_(false));
        for (Object subSrcObj : srcDir.SubDirs()) {
            IoItmDir subSrc = (IoItmDir)subSrcObj;
            if (!args.SubDirScanCrt().Matches(subSrc) || !args.MatchCrt().Matches(subSrc)) continue;
            Io_url subTrg = trg.GenSubDir_nest(subSrc.Url().NameOnly());
            if (!args.Recur()) continue;
            this.XferDir(srcEngine, subSrc.Url(), trgEngine, subTrg, args);
        }
        IoItmList srcFils = IoItmList.list_(src.Info().CaseSensitive());
        for (Object srcFilObj : srcDir.SubFils()) {
            srcFil = (IoItmFil)srcFilObj;
            if (!args.MatchCrt().Matches(srcFil)) continue;
            srcFils.Add(srcFil);
        }
        for (Object srcFilObj : srcFils) {
            srcFil = (IoItmFil)srcFilObj;
            Io_url srcFilPath = srcFil.Url();
            Io_url trgFilPath = trg.GenSubFil(srcFilPath.NameAndExt());
            IoEngine_xrg_xferFil xferArgs = args.Type_move() ? IoEngine_xrg_xferFil.move_(srcFilPath, trgFilPath).Overwrite_(args.Overwrite()) : IoEngine_xrg_xferFil.copy_(srcFilPath, trgFilPath).Overwrite_(args.Overwrite());
            this.XferFil(srcEngine, xferArgs);
        }
        if (args.Type_move()) {
            srcEngine.DeleteDirDeep(IoEngine_xrg_deleteDir.new_(src).Recur_(args.Recur()).ReadOnlyFails_(args.ReadOnlyFails()));
        }
    }

    public void XferFil(IoEngine srcEngine, IoEngine_xrg_xferFil args) {
        Io_url src = args.Src();
        Io_url trg = args.Trg();
        if (String_.Eq(srcEngine.Key(), trg.Info().EngineKey())) {
            if (args.Type_move()) {
                srcEngine.MoveFil(args);
            } else {
                srcEngine.CopyFil(args);
            }
        } else {
            this.TransferStream(src, trg);
            if (args.Type_move()) {
                srcEngine.DeleteFil_api(IoEngine_xrg_deleteFil.new_(src));
            }
        }
    }

    public IoItmDir QueryDirDeep(IoEngine engine, IoEngine_xrg_queryDir args) {
        IoItmDir rv = IoItmDir_.top_(args.Url());
        rv.Exists_set(IoEngineUtl.QueryDirDeepCore(rv, args.Url(), engine, args.Recur(), args.SubDirScanCrt(), args.DirCrt(), args.FilCrt(), args.UsrDlg(), args.DirInclude()));
        return rv;
    }

    static boolean QueryDirDeepCore(IoItmDir ownerDir, Io_url url, IoEngine engine, boolean recur, Criteria subDirScanCrt, Criteria dirCrt, Criteria filCrt, Console_adp usrDlg, boolean dirInclude) {
        if (usrDlg.Canceled_chk()) {
            return false;
        }
        if (usrDlg.Enabled()) {
            usrDlg.Write_tmp(String_.Concat("scan: ", url.Raw()));
        }
        IoItmDir scanDir = engine.QueryDir(url);
        for (Object subDirObj : scanDir.SubDirs()) {
            IoItmDir subDir = (IoItmDir)subDirObj;
            if (!subDirScanCrt.Matches(subDir)) continue;
            if (dirCrt.Matches(subDir)) {
                ownerDir.SubDirs().Add(subDir);
            }
            if (!recur) continue;
            IoEngineUtl.QueryDirDeepCore(subDir, subDir.Url(), engine, recur, subDirScanCrt, dirCrt, filCrt, usrDlg, dirInclude);
        }
        for (Object subFilObj : scanDir.SubFils()) {
            IoItmFil subFil = (IoItmFil)subFilObj;
            if (!filCrt.Matches(subFil)) continue;
            ownerDir.SubFils().Add(subFil);
        }
        return scanDir.Exists();
    }

    void TransferStream(Io_url src, Io_url trg) {
        Rls_able srcStream = null;
        Rls_able trgStream = null;
        try {
            srcStream = IoEnginePool.Instance.Get_by(src.Info().EngineKey()).OpenStreamRead(src);
            trgStream = IoEngine_xrg_openWrite.new_(trg).Exec();
            srcStream.Transfer((IoStream)trgStream, this.bufferLength);
        }
        finally {
            if (srcStream != null) {
                srcStream.Rls();
            }
            if (trgStream != null) {
                trgStream.Rls();
            }
        }
    }

    public static IoEngineUtl new_() {
        return new IoEngineUtl();
    }

    IoEngineUtl() {
    }
}

