/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.gfo_regys;

import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.Tfds;
import gplx.core.gfo_regys.GfoRegy;
import gplx.core.gfo_regys.GfoRegyItm;
import org.junit.Before;
import org.junit.Test;

public class GfoRegy_RegDir_tst {
    GfoRegy regy;
    Io_url root;

    @Before
    public void setup() {
        this.regy = GfoRegy.new_();
        Io_mgr.Instance.InitEngine_mem();
        this.root = Io_url_.mem_dir_("mem/root");
    }

    @Test
    public void Basic() {
        this.ini_fil("101_tsta.txt");
        this.ini_fil("102_tstb.txt");
        this.ini_fil("103_tstc.png");
        this.ini_fil("dir1", "104_tstd.txt");
        this.regy.RegDir(this.root, "*.txt", false, "_", ".");
        this.tst_Count(2);
        this.tst_Exists("tsta");
        this.tst_Exists("tstb");
    }

    @Test
    public void Err_dupe() {
        this.ini_fil("101_tsta.txt");
        this.ini_fil("102_tsta.txt");
        try {
            this.regy.RegDir(this.root, "*.txt", false, "_", ".");
        }
        catch (Exception e) {
            Tfds.Err_has(e, "key already registered");
            return;
        }
        Tfds.Fail_expdError();
    }

    @Test
    public void Err_chopBgn() {
        this.ini_fil("123_");
        try {
            this.regy.RegDir(this.root, "*", false, "_", ".");
        }
        catch (Exception e) {
            Tfds.Err_has(e, "chopBgn results in null key");
            return;
        }
        Tfds.Fail_expdError();
    }

    @Test
    public void Err_chopEnd() {
        this.ini_fil(".txt");
        try {
            this.regy.RegDir(this.root, "*.txt", false, "_", ".");
        }
        catch (Exception e) {
            Tfds.Err_has(e, "chopEnd results in null key");
            return;
        }
        Tfds.Fail_expdError();
    }

    void tst_Count(int expd) {
        Tfds.Eq(expd, this.regy.Count());
    }

    void tst_Exists(String expd) {
        GfoRegyItm itm = this.regy.FetchOrNull(expd);
        Tfds.Eq_nullNot(itm);
    }

    void ini_fil(String ... nest) {
        Io_mgr.Instance.SaveFilStr(this.root.GenSubFil_nest(nest), "");
    }
}

