/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.gfo_regys;

import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.GfsCtx;
import gplx.Hash_adp;
import gplx.Hash_adp_;
import gplx.Internal;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.String_;
import gplx.UsrDlg_;
import gplx.UsrMsg;
import gplx.core.gfo_regys.GfoRegyItm;
import gplx.core.interfaces.ParseAble;

public class GfoRegy
implements Gfo_invk {
    Hash_adp parsers = Hash_adp_.New();
    public static final String Invk_RegDir = "RegDir";
    public static final String Invk_RegObj = "RegObj";
    Hash_adp hash = Hash_adp_.New();
    public static final String Err_ChopBgn = "chopBgn results in null key";
    public static final String Err_ChopEnd = "chopEnd results in null key";
    public static final String Err_Dupe = "key already registered";
    public static final GfoRegy Instance = new GfoRegy();

    public int Count() {
        return this.hash.Count();
    }

    public Hash_adp Parsers() {
        return this.parsers;
    }

    public GfoRegyItm FetchOrNull(String key) {
        return (GfoRegyItm)this.hash.Get_by(key);
    }

    public Object FetchValOrFail(String key) {
        GfoRegyItm rv = (GfoRegyItm)this.hash.Get_by(key);
        if (rv == null) {
            throw Err_.new_wo_type("regy does not have key", "key", key);
        }
        return rv.Val();
    }

    public Object FetchValOrNull(String key) {
        return this.FetchValOr(key, null);
    }

    public Object FetchValOr(String key, Object or) {
        GfoRegyItm itm = this.FetchOrNull(key);
        return itm == null ? or : itm.Val();
    }

    public void Del(String key) {
        this.hash.Del(key);
    }

    public void RegObj(String key, Object val) {
        this.RegItm(key, val, 1, Io_url_.Empty);
    }

    public void RegDir(Io_url dirUrl, String match, boolean recur, String chopBgn, String chopEnd) {
        Io_url[] filUrls = Io_mgr.Instance.QueryDir_args(dirUrl).FilPath_(match).Recur_(recur).ExecAsUrlAry();
        if (filUrls.length == 0 && !Io_mgr.Instance.ExistsDir(dirUrl)) {
            UsrDlg_.Instance.Stop(UsrMsg.new_("dirUrl does not exist").Add("dirUrl", dirUrl.Xto_api()));
            return;
        }
        Io_url[] io_urlArray = filUrls;
        int n = filUrls.length;
        int n2 = 0;
        while (n2 < n) {
            Io_url filUrl = io_urlArray[n2];
            String key = filUrl.NameAndExt();
            int pos = -1;
            if (String_.EqNot(chopBgn, "")) {
                pos = String_.FindFwd(key, chopBgn);
                if (pos == String_.Len(key) - 1) {
                    throw Err_.new_wo_type(Err_ChopBgn, "key", key, "chopBgn", chopBgn);
                }
                if (pos != -1) {
                    key = String_.Mid(key, pos + 1);
                }
            }
            if (String_.EqNot(chopEnd, "")) {
                pos = String_.FindBwd(key, chopEnd);
                if (pos == 0) {
                    throw Err_.new_wo_type(Err_ChopEnd, "key", key, "chopEnd", chopEnd);
                }
                if (pos != -1) {
                    key = String_.MidByLen(key, 0, pos);
                }
            }
            if (this.hash.Has(key)) {
                throw Err_.new_wo_type(Err_Dupe, "key", key, "filUrl", filUrl);
            }
            this.RegItm(key, null, 2, filUrl);
            ++n2;
        }
    }

    public void RegObjByType(String key, String val, String type) {
        Object o = val;
        if (String_.EqNot(type, "string")) {
            ParseAble parser = (ParseAble)this.parsers.Get_by(type);
            if (parser == null) {
                throw Err_.new_wo_type("could not find parser", "type", type, "key", key, "val", val);
            }
            o = parser.ParseAsObj(val);
        }
        this.RegItm(key, o, 1, Io_url_.Empty);
    }

    @Override
    public Object Invk(GfsCtx ctx, int ikey, String k, GfoMsg m) {
        if (ctx.Match(k, Invk_RegDir)) {
            Io_url dir = m.ReadIoUrl("dir");
            String match = m.ReadStrOr("match", "*.*");
            boolean recur = m.ReadBoolOr("recur", false);
            String chopBgn = m.ReadStrOr("chopBgn", "");
            String chopEnd = m.ReadStrOr("chopEnd", ".");
            if (ctx.Deny()) {
                return this;
            }
            this.RegDir(dir, match, recur, chopBgn, chopEnd);
        } else if (ctx.Match(k, Invk_RegObj)) {
            String key = m.ReadStr("key");
            String val = m.ReadStr("val");
            String type = m.ReadStrOr("type", "string");
            if (ctx.Deny()) {
                return this;
            }
            this.RegObjByType(key, val, type);
        } else {
            return Gfo_invk_.Rv_unhandled;
        }
        return this;
    }

    void RegItm(String key, Object val, int valType, Io_url url) {
        this.hash.Add_if_dupe_use_nth(key, new GfoRegyItm(key, val, valType, url));
    }

    GfoRegy() {
    }

    @Internal
    protected static GfoRegy new_() {
        return new GfoRegy();
    }
}

