/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.envs;

import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.Gfo_invk_cmd;
import gplx.Gfo_usr_dlg;
import gplx.GfsCtx;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.Rls_able;
import gplx.String_;
import gplx.Tfds;
import gplx.Virtual;
import gplx.core.brys.fmtrs.Bry_fmtr;
import gplx.core.brys.fmtrs.Bry_fmtr_eval_mgr;
import gplx.core.brys.fmtrs.Bry_fmtr_eval_mgr_;
import gplx.core.envs.Env_;
import gplx.core.envs.Op_sys;
import gplx.core.envs.System_;
import gplx.core.envs.Thread_ProcessAdp_async;
import gplx.core.envs.Thread_ProcessAdp_sync;
import gplx.core.strings.String_bldr;
import gplx.core.strings.String_bldr_;
import gplx.core.threads.Thread_adp_;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

public class Process_adp
implements Gfo_invk,
Rls_able {
    private boolean enabled = true;
    private byte exe_exists = (byte)127;
    Io_url exe_url;
    private String args_str = "";
    Bry_fmtr args_fmtr = Bry_fmtr.new_("", new String[0]);
    private boolean args__include_quotes;
    private byte run_mode = 1;
    public static final byte Run_mode_async = 0;
    public static final byte Run_mode_sync_block = 1;
    public static final byte Run_mode_sync_timeout = 2;
    int exit_code;
    private String rslt_out;
    Io_url working_dir;
    int thread_timeout = 0;
    int thread_interval = 20;
    private String thread_kill_name = "";
    Io_url tmp_dir;
    List_adp whenBgnList = List_adp_.New();
    Gfo_usr_dlg prog_dlg;
    private String prog_fmt = "";
    private Gfo_invk owner;
    List_adp whenEndList = List_adp_.New();
    static final String Invk_cmd = "cmd";
    static final String Invk_cmd_ = "cmd_";
    static final String Invk_args = "args";
    static final String Invk_args_ = "args_";
    static final String Invk_cmd_args_ = "cmd_args_";
    static final String Invk_enabled = "enabled";
    static final String Invk_enabled_ = "enabled_";
    static final String Invk_mode_ = "mode_";
    static final String Invk_timeout_ = "timeout_";
    static final String Invk_tmp_dir_ = "tmp_dir_";
    static final String Invk_owner = "owner";
    Bry_fmtr_eval_mgr cmd_url_eval;
    private Bry_fmtr notify_fmtr = Bry_fmtr.new_("", "process_exe_name", "process_exe_args", "process_seconds");
    Bry_bfr notify_bfr = Bry_bfr_.Reset(255);
    Process process;
    ProcessBuilder pb;
    public static final List_adp Test_runs = List_adp_.New();
    private static final String GRP_KEY = "gplx.process";
    public static final int Exit_pass = 0;
    public static final int Exit_init = -1;

    public boolean Enabled() {
        return this.enabled;
    }

    public Process_adp Enabled_(boolean v) {
        this.enabled = v;
        return this;
    }

    public byte Exe_exists() {
        return this.exe_exists;
    }

    public Process_adp Exe_exists_(byte v) {
        this.exe_exists = v;
        return this;
    }

    public Io_url Exe_url() {
        return this.exe_url;
    }

    public Process_adp Exe_url_(Io_url val) {
        this.exe_url = val;
        this.exe_exists = (byte)127;
        return this;
    }

    public String Args_str() {
        return this.args_str;
    }

    public Process_adp Args_str_(String val) {
        this.args_str = val;
        return this;
    }

    public Bry_fmtr Args_fmtr() {
        return this.args_fmtr;
    }

    public boolean Args__include_quotes() {
        return this.args__include_quotes;
    }

    public void Args__include_quotes_(boolean v) {
        this.args__include_quotes = v;
    }

    public byte Run_mode() {
        return this.run_mode;
    }

    public Process_adp Run_mode_(byte v) {
        this.run_mode = v;
        return this;
    }

    public int Exit_code() {
        return this.exit_code;
    }

    public boolean Exit_code_pass() {
        return this.exit_code == 0;
    }

    public String Rslt_out() {
        return this.rslt_out;
    }

    public Io_url Working_dir() {
        return this.working_dir;
    }

    public Process_adp Working_dir_(Io_url v) {
        this.working_dir = v;
        return this;
    }

    public Process_adp Cmd_args(String cmd, String args) {
        this.Exe_url_(Io_url_.new_fil_(cmd));
        this.args_fmtr.Fmt_(args);
        return this;
    }

    public Process_adp WhenBgn_add(Gfo_invk_cmd cmd) {
        this.whenBgnList.Add(cmd);
        return this;
    }

    public Process_adp WhenBgn_del(Gfo_invk_cmd cmd) {
        this.whenBgnList.Del(cmd);
        return this;
    }

    public int Thread_timeout() {
        return this.thread_timeout;
    }

    public Process_adp Thread_timeout_seconds_(int v) {
        this.thread_timeout = v * 1000;
        return this;
    }

    public int Thread_interval() {
        return this.thread_interval;
    }

    public Process_adp Thread_interval_(int v) {
        this.thread_interval = v;
        return this;
    }

    public String Thread_kill_name() {
        return this.thread_kill_name;
    }

    public Process_adp Thread_kill_name_(String v) {
        this.thread_kill_name = v;
        return this;
    }

    public Io_url Tmp_dir() {
        return this.tmp_dir;
    }

    @Virtual
    public Process_adp Tmp_dir_(Io_url v) {
        this.tmp_dir = v;
        return this;
    }

    private Process_adp WhenBgn_run() {
        return this.Invk_cmds(this.whenBgnList);
    }

    public Process_adp WhenEnd_add(Gfo_invk_cmd cmd) {
        this.whenEndList.Add(cmd);
        return this;
    }

    public Process_adp WhenEnd_del(Gfo_invk_cmd cmd) {
        this.whenEndList.Del(cmd);
        return this;
    }

    public Gfo_usr_dlg Prog_dlg() {
        return this.prog_dlg;
    }

    public Process_adp Prog_dlg_(Gfo_usr_dlg v) {
        this.prog_dlg = v;
        return this;
    }

    public String Prog_fmt() {
        return this.prog_fmt;
    }

    public Process_adp Prog_fmt_(String v) {
        this.prog_fmt = v;
        return this;
    }

    private Process_adp WhenEnd_run() {
        return this.Invk_cmds(this.whenEndList);
    }

    private Process_adp Invk_cmds(List_adp list) {
        for (Object o : list) {
            ((Gfo_invk_cmd)o).Exec();
        }
        return this;
    }

    public Process_adp Run(Object ... args) {
        if (String_.Len_eq_0(this.exe_url.Raw())) {
            return this;
        }
        if (!this.args_fmtr.Fmt_null()) {
            Bry_bfr tmp_bfr = Bry_bfr_.New();
            this.args_fmtr.Bld_bfr_many(tmp_bfr, args);
            this.args_str = tmp_bfr.To_str_and_clear();
        }
        this.prog_dlg.Log_many(GRP_KEY, "run", "running process: ~{0} ~{1}", this.exe_url.Raw(), this.args_str);
        this.exit_code = -1;
        switch (this.run_mode) {
            case 0: {
                return this.Run_async();
            }
            case 2: {
                return this.Run_wait();
            }
            case 1: {
                return this.Run_wait_sync();
            }
        }
        throw Err_.new_unhandled(this.run_mode);
    }

    public String[] Xto_process_bldr_args(String ... args) {
        String args_str = this.args_fmtr.Bld_str_many(args);
        return Process_adp.To_process_bldr_args_utl(this.exe_url, args_str, false);
    }

    @Override
    public Object Invk(GfsCtx ctx, int ikey, String k, GfoMsg m) {
        if (ctx.Match(k, Invk_enabled)) {
            return this.enabled;
        }
        if (ctx.Match(k, Invk_enabled_)) {
            this.enabled = m.ReadBool("v");
        } else {
            if (ctx.Match(k, Invk_cmd)) {
                return this.exe_url.Raw();
            }
            if (ctx.Match(k, Invk_cmd_)) {
                this.Exe_url_(Bry_fmtr_eval_mgr_.Eval_url(this.cmd_url_eval, m.ReadBry(Invk_cmd)));
            } else {
                if (ctx.Match(k, Invk_args)) {
                    return String_.new_u8(this.args_fmtr.Fmt());
                }
                if (ctx.Match(k, Invk_args_)) {
                    this.args_fmtr.Fmt_(m.ReadBry("v"));
                } else if (ctx.Match(k, Invk_cmd_args_)) {
                    this.Exe_url_(Bry_fmtr_eval_mgr_.Eval_url(this.cmd_url_eval, m.ReadBry(Invk_cmd)));
                    this.args_fmtr.Fmt_(m.ReadBry(Invk_args));
                } else if (ctx.Match(k, Invk_mode_)) {
                    this.run_mode = m.ReadByte("v");
                } else if (ctx.Match(k, Invk_timeout_)) {
                    this.thread_timeout = m.ReadInt("v");
                } else if (ctx.Match(k, Invk_tmp_dir_)) {
                    this.tmp_dir = m.ReadIoUrl("v");
                } else {
                    if (ctx.Match(k, Invk_owner)) {
                        return this.owner;
                    }
                    return Gfo_invk_.Rv_unhandled;
                }
            }
        }
        return this;
    }

    public static Process_adp ini_(Gfo_invk owner, Gfo_usr_dlg usr_dlg, Process_adp process, Bry_fmtr_eval_mgr cmd_url_eval, byte run_mode, int timeout, String cmd_url_fmt, String args_fmt, String ... args_keys) {
        process.Run_mode_(run_mode).Thread_timeout_seconds_(timeout);
        process.cmd_url_eval = cmd_url_eval;
        Io_url cmd_url = Bry_fmtr_eval_mgr_.Eval_url(cmd_url_eval, Bry_.new_u8(cmd_url_fmt));
        process.Exe_url_(cmd_url).Tmp_dir_(cmd_url.OwnerDir());
        process.Args_fmtr().Fmt_(args_fmt).Keys_(args_keys);
        process.owner = owner;
        process.Prog_dlg_(usr_dlg);
        return process;
    }

    public static String Escape_ampersands_if_process_is_cmd(boolean os_is_wnt, String exe_url, String exe_args) {
        return os_is_wnt && String_.Eq(exe_url, Invk_cmd) ? String_.Replace(exe_args, "&", "^&") : exe_args;
    }

    public void Exe_and_args_(String exe, String args) {
        Io_url exe_url = Bry_fmtr_eval_mgr_.Eval_url(this.cmd_url_eval, Bry_.new_u8(exe));
        this.Exe_url_(exe_url).Tmp_dir_(exe_url.OwnerDir());
        this.Args_fmtr().Fmt_(args);
    }

    public static Process_adp New(Gfo_usr_dlg usr_dlg, Bry_fmtr_eval_mgr eval_mgr, byte run_mode, int timeout, String exe, String args, String ... args_keys) {
        Process_adp rv = new Process_adp();
        rv.Prog_dlg_(usr_dlg);
        rv.Run_mode_(run_mode);
        rv.Thread_timeout_seconds_(timeout);
        rv.cmd_url_eval = eval_mgr;
        Io_url exe_url = Bry_fmtr_eval_mgr_.Eval_url(eval_mgr, Bry_.new_u8(exe));
        rv.Exe_url_(exe_url).Tmp_dir_(exe_url.OwnerDir());
        rv.Args_fmtr().Fmt_(args).Keys_(args_keys);
        return rv;
    }

    public Process UnderProcess() {
        return this.process;
    }

    @Override
    public void Rls() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public Process_adp Run_wait_sync() {
        if (Env_.Mode_testing()) {
            return this.Test_runs_add();
        }
        this.Process_bgn();
        this.Process_start();
        this.Process_run_and_end();
        return this;
    }

    public Process_adp Run_start() {
        if (Env_.Mode_testing()) {
            return this.Test_runs_add();
        }
        this.Process_bgn();
        this.Process_start();
        return this;
    }

    public Process_adp Run_async() {
        if (Env_.Mode_testing()) {
            return this.Test_runs_add();
        }
        this.Process_bgn();
        Thread_ProcessAdp_async thread = new Thread_ProcessAdp_async(this);
        thread.start();
        return this;
    }

    public Process_adp Run_wait() {
        int elapsed;
        int notify_checkpoint;
        block11: {
            int notify_interval;
            if (Env_.Mode_testing()) {
                return this.Test_runs_add();
            }
            notify_checkpoint = notify_interval = 100;
            elapsed = 0;
            try {
                this.Process_bgn();
                Thread_ProcessAdp_sync thread = new Thread_ProcessAdp_sync(this);
                thread.start();
                boolean thread_run = false;
                this.notify_fmtr.Fmt_(this.prog_fmt);
                while (thread.isAlive()) {
                    thread_run = true;
                    long prv = System_.Ticks();
                    Thread_adp_.Sleep(this.thread_interval);
                    long cur = System_.Ticks();
                    int dif = (int)(cur - prv);
                    if (this.prog_dlg != null && (elapsed += dif) > notify_checkpoint) {
                        elapsed = notify_checkpoint;
                        notify_checkpoint += notify_interval;
                        this.notify_fmtr.Bld_bfr_many(this.notify_bfr, this.exe_url.NameAndExt(), this.args_str, elapsed / 1000);
                        this.prog_dlg.Prog_none(GRP_KEY, "notify.prog", this.notify_bfr.To_str_and_clear());
                    }
                    if (this.thread_timeout == 0) break;
                    if (elapsed <= this.thread_timeout) continue;
                    thread.interrupt();
                    thread.Cancel();
                    try {
                        thread.join();
                        break;
                    }
                    catch (InterruptedException e) {
                        throw Err_.new_exc(e, "core", "thread interrupted at timeout", new Object[0]);
                    }
                }
                if (thread_run) break block11;
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    throw Err_.new_exc(e, "core", "thread interrupted at join 2", new Object[0]);
                }
            }
            catch (Exception exc) {
                Tfds.Write(Err_.Message_gplx_full(exc));
            }
        }
        if (elapsed != notify_checkpoint) {
            this.notify_fmtr.Bld_bfr_many(this.notify_bfr, this.exe_url.NameAndExt(), this.args_str, elapsed / 1000);
            if (this.prog_dlg != null) {
                this.prog_dlg.Prog_none(GRP_KEY, "notify.prog", this.notify_bfr.To_str_and_clear());
            }
        }
        return this;
    }

    public synchronized void Process_post(String result) {
        this.exit_code = this.process.exitValue();
        this.rslt_out = result;
        this.WhenEnd_run();
        this.process.destroy();
    }

    String Kill() {
        if (this.thread_kill_name == "") {
            return "";
        }
        String kill_exe = "";
        String kill_args = "";
        if (Op_sys.Cur().Tid_is_wnt()) {
            kill_exe = "taskkill";
            kill_args = "/F /IM ";
        } else {
            kill_exe = "kill";
            kill_args = "-9 ";
        }
        kill_args = String.valueOf(kill_args) + this.thread_kill_name;
        Process_adp kill_process = new Process_adp().Exe_url_(Io_url_.new_fil_(kill_exe)).Args_str_(kill_args).Thread_kill_name_("");
        boolean pass = kill_process.Run_wait().Exit_code_pass();
        return "killed|" + kill_exe + "|" + kill_args + "|" + pass + "|" + this.exe_url.Raw() + "|" + this.args_str;
    }

    synchronized void Process_bgn() {
        this.exit_code = -1;
        this.rslt_out = "";
        this.WhenBgn_run();
        this.pb = new ProcessBuilder(Process_adp.To_process_bldr_args_utl(this.exe_url, this.args_str, this.args__include_quotes));
        this.pb.redirectErrorStream(true);
        if (this.working_dir != null) {
            this.pb.directory(new File(this.working_dir.Xto_api()));
        } else if (!this.exe_url.OwnerDir().EqNull()) {
            this.pb.directory(new File(this.exe_url.OwnerDir().Xto_api()));
        }
    }

    protected Process Process_start() {
        try {
            this.process = this.pb.start();
        }
        catch (IOException e) {
            List<String> command_list = this.pb.command();
            String[] command_ary = new String[command_list.size()];
            command_ary = command_list.toArray(command_ary);
            throw Err_.new_exc(e, "core", "process start failed", Invk_args, String_.Concat_with_str(" ", command_ary));
        }
        return this.process;
    }

    void Process_run_and_end() {
        String_bldr sb = String_bldr_.new_();
        BufferedReader rdr = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        try {
            String line = "";
            while ((line = rdr.readLine()) != null) {
                sb.Add_str_w_crlf(line);
            }
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw Err_.new_exc(e, "core", "thread interrupted at wait_for", "exe_url", this.exe_url.Xto_api(), "exeArgs", this.args_str);
        }
        catch (IOException e) {
            throw Err_.new_exc(e, "core", "io error", "exe_url", this.exe_url.Xto_api(), "exeArgs", this.args_str);
        }
        this.exit_code = this.process.exitValue();
        this.WhenEnd_run();
        this.process.destroy();
        this.rslt_out = sb.To_str_and_clear();
    }

    public void Process_term() {
        try {
            this.process.getInputStream().close();
            this.process.getErrorStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.process.destroy();
    }

    public static void run_wait_(Io_url url) {
        Process_adp process = new Process_adp().Exe_url_(url);
        process.Run_start();
        process.Process_run_and_end();
    }

    private Process_adp Test_runs_add() {
        Test_runs.Add(String.valueOf(this.exe_url.Raw()) + " " + this.args_str);
        this.exit_code = 0;
        return this;
    }

    public static int run_wait_arg_(Io_url url, String arg) {
        Process_adp process = new Process_adp();
        process.Exe_url_(url).Args_str_(arg).Run_wait();
        return process.Exit_code();
    }

    public static String[] To_process_bldr_args_utl(Io_url exe_url, String args_str, boolean include_quotes) {
        List_adp list = List_adp_.New();
        list.Add(exe_url.Xto_api());
        String_bldr sb = String_bldr_.new_();
        int len = String_.Len(args_str);
        boolean in_quotes = false;
        int i = 0;
        while (i < len) {
            char c = String_.CharAt(args_str, i);
            if (c == ' ' && !in_quotes) {
                list.Add(sb.To_str());
                sb.Clear();
            } else if (c == '\"') {
                boolean bl = in_quotes = !in_quotes;
                if (include_quotes) {
                    sb.Add(c);
                }
            } else {
                sb.Add(c);
            }
            ++i;
        }
        if (sb.Has_some()) {
            list.Add(sb.To_str());
        }
        return list.To_str_ary();
    }
}

