/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.encoders;

import gplx.Bry_bfr;
import gplx.Err_;
import gplx.Int_;
import gplx.String_;

public class Hex_utl_ {
    public static int Parse_or(byte[] src, int or) {
        return Hex_utl_.Parse_or(src, 0, src.length, or);
    }

    public static int Parse_or(byte[] src, int bgn, int end, int or) {
        int rv = 0;
        int factor = 1;
        int b = 127;
        int i = end - 1;
        while (i >= bgn) {
            switch (src[i]) {
                case 48: {
                    b = 0;
                    break;
                }
                case 49: {
                    b = 1;
                    break;
                }
                case 50: {
                    b = 2;
                    break;
                }
                case 51: {
                    b = 3;
                    break;
                }
                case 52: {
                    b = 4;
                    break;
                }
                case 53: {
                    b = 5;
                    break;
                }
                case 54: {
                    b = 6;
                    break;
                }
                case 55: {
                    b = 7;
                    break;
                }
                case 56: {
                    b = 8;
                    break;
                }
                case 57: {
                    b = 9;
                    break;
                }
                case 65: {
                    b = 10;
                    break;
                }
                case 66: {
                    b = 11;
                    break;
                }
                case 67: {
                    b = 12;
                    break;
                }
                case 68: {
                    b = 13;
                    break;
                }
                case 69: {
                    b = 14;
                    break;
                }
                case 70: {
                    b = 15;
                    break;
                }
                case 97: {
                    b = 10;
                    break;
                }
                case 98: {
                    b = 11;
                    break;
                }
                case 99: {
                    b = 12;
                    break;
                }
                case 100: {
                    b = 13;
                    break;
                }
                case 101: {
                    b = 14;
                    break;
                }
                case 102: {
                    b = 15;
                    break;
                }
                default: {
                    b = 127;
                }
            }
            if (b == 127) {
                return or;
            }
            rv += b * factor;
            factor *= 16;
            --i;
        }
        return rv;
    }

    public static int Parse(String src) {
        int rv = Hex_utl_.Parse_or(src, -1);
        if (rv == -1) {
            throw Err_.new_parse("HexDec", "src");
        }
        return rv;
    }

    public static int Parse_or(String src, int or) {
        int rv = 0;
        int digit = 0;
        int factor = 1;
        int len = String_.Len(src);
        int i = len - 1;
        while (i > -1) {
            digit = Hex_utl_.To_int(String_.CharAt(src, i));
            if (digit == -1) {
                return or;
            }
            rv += digit * factor;
            factor *= 16;
            --i;
        }
        return rv;
    }

    public static byte[] Encode_bry(byte[] src) {
        int src_len = src.length;
        byte[] trg = new byte[src_len * 2];
        Hex_utl_.Encode_bry(src, trg);
        return trg;
    }

    public static void Encode_bry(byte[] src, byte[] trg) {
        int trg_len = trg.length;
        int src_len = src.length;
        if (trg_len != src_len * 2) {
            throw Err_.new_("hex", "trg.len must be src.len * 2", "src_len", src_len, "trg_len", trg_len);
        }
        int trg_idx = -1;
        int src_idx = 0;
        while (src_idx < src_len) {
            byte src_byte = src[src_idx];
            trg[++trg_idx] = Hex_utl_.To_byte_lcase(0xF & src_byte >>> 4);
            trg[++trg_idx] = Hex_utl_.To_byte_lcase(0xF & src_byte);
            ++src_idx;
        }
    }

    public static void Encode_bfr(Bry_bfr bfr, byte[] src) {
        int src_len = src.length;
        int src_idx = 0;
        while (src_idx < src_len) {
            byte src_byte = src[src_idx];
            bfr.Add_byte(Hex_utl_.To_byte_lcase(0xF & src_byte >>> 4));
            bfr.Add_byte(Hex_utl_.To_byte_lcase(0xF & src_byte));
            ++src_idx;
        }
    }

    public static String To_str(int val, int pad) {
        char[] ary = new char[8];
        int idx = 8;
        do {
            int byt = val % 16;
            ary[--idx] = Hex_utl_.To_char(byt);
        } while ((val /= 16) > 0);
        while (8 - idx < pad) {
            ary[--idx] = 48;
        }
        return String_.new_charAry_(ary, idx, 8 - idx);
    }

    public static void Write(byte[] bry, int bgn, int end, int val) {
        int i = end - 1;
        while (i > bgn - 1) {
            int b = val % 16;
            bry[i] = Hex_utl_.To_byte_ucase(b);
            if ((val /= 16) == 0) break;
            --i;
        }
    }

    public static void Write_bfr(Bry_bfr bfr, boolean lcase, int val) {
        int val_len = 0;
        int tmp = val;
        do {
            ++val_len;
        } while ((tmp /= 16) != 0);
        int hex_bgn = bfr.Len();
        bfr.Add_byte_repeat((byte)0, val_len);
        byte[] bry = bfr.Bfr();
        int i = 0;
        while (i < val_len) {
            int b = val % 16;
            bry[hex_bgn + val_len - i - 1] = lcase ? Hex_utl_.To_byte_lcase(b) : Hex_utl_.To_byte_ucase(b);
            val /= 16;
            ++i;
        }
    }

    public static boolean Is_hex_many(byte ... ary) {
        byte[] byArray = ary;
        int n = ary.length;
        int n2 = 0;
        while (n2 < n) {
            byte itm = byArray[n2];
            switch (itm) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private static int To_int(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': {
                return 10;
            }
            case 'B': {
                return 11;
            }
            case 'C': {
                return 12;
            }
            case 'D': {
                return 13;
            }
            case 'E': {
                return 14;
            }
            case 'F': {
                return 15;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return -1;
    }

    private static char To_char(int val) {
        switch (val) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
            case 15: {
                return 'F';
            }
        }
        throw Err_.new_parse("hexstring", Int_.To_str(val));
    }

    private static byte To_byte_ucase(int v) {
        switch (v) {
            case 0: {
                return 48;
            }
            case 1: {
                return 49;
            }
            case 2: {
                return 50;
            }
            case 3: {
                return 51;
            }
            case 4: {
                return 52;
            }
            case 5: {
                return 53;
            }
            case 6: {
                return 54;
            }
            case 7: {
                return 55;
            }
            case 8: {
                return 56;
            }
            case 9: {
                return 57;
            }
            case 10: {
                return 65;
            }
            case 11: {
                return 66;
            }
            case 12: {
                return 67;
            }
            case 13: {
                return 68;
            }
            case 14: {
                return 69;
            }
            case 15: {
                return 70;
            }
        }
        throw Err_.new_parse("hexstring", Int_.To_str(v));
    }

    private static byte To_byte_lcase(int v) {
        switch (v) {
            case 0: {
                return 48;
            }
            case 1: {
                return 49;
            }
            case 2: {
                return 50;
            }
            case 3: {
                return 51;
            }
            case 4: {
                return 52;
            }
            case 5: {
                return 53;
            }
            case 6: {
                return 54;
            }
            case 7: {
                return 55;
            }
            case 8: {
                return 56;
            }
            case 9: {
                return 57;
            }
            case 10: {
                return 97;
            }
            case 11: {
                return 98;
            }
            case 12: {
                return 99;
            }
            case 13: {
                return 100;
            }
            case 14: {
                return 101;
            }
            case 15: {
                return 102;
            }
        }
        throw Err_.new_parse("hexstring", Int_.To_str(v));
    }
}

