/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.criterias;

import gplx.DateAdp_;
import gplx.Io_url_;
import gplx.Tfds;
import gplx.core.criterias.Criteria;
import gplx.core.criterias.CriteriaFxt;
import gplx.core.criterias.Criteria_;
import gplx.core.criterias.Criteria_fld;
import gplx.core.criterias.Criteria_ioMatch;
import gplx.core.ios.IoItmFil;
import gplx.core.ios.IoItm_base;
import gplx.core.ios.IoItm_fxt;
import org.junit.Test;

public class Criteria_ioItm_tst {
    IoItmFil fil;
    Criteria crt;
    IoItm_fxt fx = IoItm_fxt.new_();

    @Test
    public void IoType() {
        this.crt = this.crt_("type", Criteria_.eq_(2));
        this.tst_Match(true, this.crt, this.fx.fil_wnt_("C:\\fil.txt"));
        this.tst_Match(false, this.crt, this.fx.dir_wnt_("C:\\dir"));
    }

    @Test
    public void Ext() {
        this.crt = this.crt_("ext", Criteria_.eq_(".txt"));
        this.tst_Match(true, this.crt, this.fx.fil_wnt_("C:\\fil.txt"));
        this.tst_Match(false, this.crt, this.fx.fil_wnt_("C:\\fil.xml"), this.fx.fil_wnt_("C:\\fil.txt1"), this.fx.fil_wnt_("C:\\fil1.txt.xml"), this.fx.dir_wnt_("C:\\.txt"));
    }

    @Test
    public void Modified() {
        this.fil = this.fx.fil_wnt_("C:\\fil.txt");
        this.crt = this.crt_("modified", Criteria_.mte_(DateAdp_.parse_gplx("2001-01-01")));
        this.tst_Match(true, this.crt, this.fil.ModifiedTime_(DateAdp_.parse_gplx("2001-01-02")), this.fil.ModifiedTime_(DateAdp_.parse_gplx("2001-01-01")));
        this.tst_Match(false, this.crt, this.fil.ModifiedTime_(DateAdp_.parse_gplx("2000-12-31")));
    }

    @Test
    public void IoMatch() {
        Criteria_ioMatch crt = Criteria_ioMatch.parse(true, "*.txt", false);
        CriteriaFxt fx_crt = new CriteriaFxt();
        fx_crt.tst_Matches(crt, Io_url_.new_any_("file.txt"));
        fx_crt.tst_MatchesNot(crt, Io_url_.new_any_("file.xml"));
    }

    Criteria crt_(String fld, Criteria crt) {
        return Criteria_fld.new_(fld, crt);
    }

    void tst_Match(boolean expt, Criteria fieldCrt, IoItm_base ... ary) {
        IoItm_base[] ioItm_baseArray = ary;
        int n = ary.length;
        int n2 = 0;
        while (n2 < n) {
            IoItm_base itm = ioItm_baseArray[n2];
            Tfds.Eq(expt, fieldCrt.Matches(itm));
            ++n2;
        }
    }
}

