/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.criterias;

import gplx.Array_;
import gplx.Err_;
import gplx.core.criterias.Criteria;
import gplx.core.criterias.Criteria_and;
import gplx.core.criterias.Criteria_between;
import gplx.core.criterias.Criteria_comp;
import gplx.core.criterias.Criteria_const;
import gplx.core.criterias.Criteria_eq;
import gplx.core.criterias.Criteria_in;
import gplx.core.criterias.Criteria_like;
import gplx.core.criterias.Criteria_not;
import gplx.core.criterias.Criteria_or;
import gplx.core.texts.RegxPatn_cls_like_;

public class Criteria_ {
    public static final Criteria All = new Criteria_const(true);
    public static final Criteria None = new Criteria_const(false);
    public static final byte Tid_custom = 0;
    public static final byte Tid_const = 1;
    public static final byte Tid_not = 2;
    public static final byte Tid_and = 3;
    public static final byte Tid_or = 4;
    public static final byte Tid_eq = 5;
    public static final byte Tid_between = 6;
    public static final byte Tid_in = 7;
    public static final byte Tid_like = 8;
    public static final byte Tid_comp = 9;
    public static final byte Tid_wrapper = 10;
    public static final byte Tid_iomatch = 11;
    public static final byte Tid_db_obj_ary = 12;

    public static Criteria Not(Criteria arg) {
        return new Criteria_not(arg);
    }

    public static Criteria And(Criteria lhs, Criteria rhs) {
        return new Criteria_and(lhs, rhs);
    }

    public static Criteria And_many(Criteria ... ary) {
        int len = Array_.Len(ary);
        if (len == 0) {
            throw Err_.new_wo_type("cannot AND 0 criterias;", new Object[0]);
        }
        Criteria rv = ary[0];
        int i = 1;
        while (i < len) {
            rv = Criteria_.And(rv, ary[i]);
            ++i;
        }
        return rv;
    }

    public static Criteria Or(Criteria lhs, Criteria rhs) {
        return new Criteria_or(lhs, rhs);
    }

    public static Criteria Or_many(Criteria ... ary) {
        int len = Array_.Len(ary);
        if (len == 0) {
            throw Err_.new_wo_type("cannot OR 0 criterias;", new Object[0]);
        }
        Criteria rv = ary[0];
        int i = 1;
        while (i < len) {
            rv = Criteria_.Or(rv, ary[i]);
            ++i;
        }
        return rv;
    }

    public static Criteria eq_(Object arg) {
        return new Criteria_eq(false, arg);
    }

    public static Criteria eqn_(Object arg) {
        return new Criteria_eq(true, arg);
    }

    public static Criteria in_(Object ... array) {
        return new Criteria_in(false, array);
    }

    public static Criteria inn_(Object ... array) {
        return new Criteria_in(true, array);
    }

    public static Criteria lt_(Comparable val) {
        return new Criteria_comp(-1, val);
    }

    public static Criteria lte_(Comparable val) {
        return new Criteria_comp(-2, val);
    }

    public static Criteria mt_(Comparable val) {
        return new Criteria_comp(1, val);
    }

    public static Criteria mte_(Comparable val) {
        return new Criteria_comp(2, val);
    }

    public static Criteria between_(Comparable lhs, Comparable rhs) {
        return new Criteria_between(false, lhs, rhs);
    }

    public static Criteria between_(boolean negated, Comparable lhs, Comparable rhs) {
        return new Criteria_between(negated, lhs, rhs);
    }

    public static Criteria like_(String pattern) {
        return new Criteria_like(false, RegxPatn_cls_like_.parse(pattern, '|'));
    }

    public static Criteria liken_(String pattern) {
        return new Criteria_like(true, RegxPatn_cls_like_.parse(pattern, '|'));
    }
}

