/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.consoles;

import gplx.Bry_;
import gplx.Err_;
import gplx.String_;
import gplx.core.consoles.Console_adp;
import gplx.core.envs.Env_;
import gplx.core.envs.Op_sys;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class Console_adp__sys
implements Console_adp {
    private String tmp_txt;
    private boolean canceled = false;
    int chars_per_line_max = 80;
    private boolean backspace_by_bytes = Op_sys.Cur().Tid_is_lnx();
    public static final Console_adp__sys Instance = new Console_adp__sys();

    @Override
    public boolean Enabled() {
        return true;
    }

    public boolean Canceled() {
        return this.canceled;
    }

    public void Canceled_set(boolean v) {
        this.canceled = v;
    }

    @Override
    public boolean Canceled_chk() {
        if (this.canceled) {
            throw Err_.new_op_canceled();
        }
        return this.canceled;
    }

    @Override
    public int Chars_per_line_max() {
        return this.chars_per_line_max;
    }

    @Override
    public void Chars_per_line_max_(int v) {
        this.chars_per_line_max = v;
    }

    public boolean Backspace_by_bytes() {
        return this.backspace_by_bytes;
    }

    public Console_adp__sys Backspace_by_bytes_(boolean v) {
        this.backspace_by_bytes = v;
        return this;
    }

    @Override
    public void Write_str(String s) {
        this.Clear_tmp();
        this.Write_str_lang(s);
    }

    public void Write_str_w_nl(String s) {
        this.Clear_tmp();
        this.Write_str_w_nl_lang(s);
    }

    @Override
    public void Write_fmt_w_nl(String fmt, Object ... args) {
        this.Clear_tmp();
        this.Write_str_w_nl_lang(String_.Format(fmt, args));
    }

    @Override
    public char Read_key(String s) {
        this.Write_str(s);
        return this.Read_key_lang();
    }

    @Override
    public String Read_line(String s) {
        this.Write_str(s);
        return this.Read_line_lang();
    }

    @Override
    public void Write_tmp(String s) {
        this.Clear_tmp();
        if (String_.Has(s, "\r")) {
            s = String_.Replace(s, "\r", " ");
        }
        if (String_.Has(s, "\n")) {
            s = String_.Replace(s, "\n", " ");
        }
        if (String_.Len(s) >= this.chars_per_line_max) {
            s = String.valueOf(String_.Mid(s, 0, this.chars_per_line_max - String_.Len("...") - 1)) + "...";
        }
        this.tmp_txt = s;
        this.Write_str_lang(s);
    }

    private void Clear_tmp() {
        if (this.tmp_txt == null) {
            return;
        }
        if (Env_.Mode_debug()) {
            this.Write_str_lang("\r\n");
            return;
        }
        int count = this.backspace_by_bytes ? Bry_.new_u8(this.tmp_txt).length : String_.Len(this.tmp_txt);
        String moveBack = String_.Repeat("\b", count);
        this.Write_str_lang(moveBack);
        this.Write_str_lang(String_.Repeat(" ", count));
        this.Write_str_lang(moveBack);
        this.tmp_txt = null;
    }

    private void Write_str_lang(String s) {
        System.out.print(s);
    }

    private void Write_str_w_nl_lang(String s) {
        System.out.println(s);
    }

    private String Read_line_lang() {
        return System.console() == null ? "" : System.console().readLine();
    }

    private char Read_key_lang() {
        String text = this.Read_line_lang();
        return String_.Len(text) == 0 ? (char)'\u0000' : String_.CharAt(text, 0);
    }

    public void Write_str_w_nl_utf8(String s) {
        PrintStream ps;
        try {
            ps = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Err_.new_wo_type("unsupported exception", new Object[0]);
        }
        ps.println(s);
    }
}

